/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.geom;

import uibk.mtk.geom.Vector3D;

public class Punkt3D {
    public double x1;
    public double x2;
    public double x3;
    public double h = 1.0;

    public Punkt3D(double x, double y, double z) {
        this.x1 = x;
        this.x2 = y;
        this.x3 = z;
    }

    public Punkt3D() {
    }

    public Punkt3D(Punkt3D p) {
        this.x1 = p.x1;
        this.x2 = p.x2;
        this.x3 = p.x3;
    }

    public void toCanonical() {
        this.x1 /= this.h;
        this.x2 /= this.h;
        this.x3 /= this.h;
    }

    public Punkt3D add(Punkt3D b) {
        return new Punkt3D(this.x1 + b.x1, this.x2 + b.x2, this.x3 + b.x3);
    }

    public Punkt3D sub(Punkt3D v) {
        return new Punkt3D(this.x1 - v.x1, this.x2 - v.x2, this.x3 - v.x3);
    }

    public static Punkt3D inverse(Punkt3D a) {
        return new Punkt3D(-a.x1, -a.x2, -a.x3);
    }

    public void setLocation(Punkt3D p) {
        this.x1 = p.x1;
        this.x2 = p.x2;
        this.x3 = p.x3;
    }

    public void setLocation(double x1, double x2, double x3) {
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
    }

    public void scaleself(double s) {
        this.x1 *= s;
        this.x2 *= s;
        this.x3 *= s;
    }

    public Punkt3D scale(double s) {
        Punkt3D b = new Punkt3D();
        b.x1 = this.x1 * s;
        b.x2 = this.x2 * s;
        b.x3 = this.x3 * s;
        return b;
    }

    public Vector3D crossProd(Punkt3D b) {
        Vector3D c = new Vector3D();
        c.x1 = this.x2 * b.x3 - this.x3 * b.x2;
        c.x2 = this.x3 * b.x1 - this.x1 * b.x3;
        c.x3 = this.x1 * b.x2 - this.x2 * b.x1;
        return c;
    }

    public double dotProd(Punkt3D a) {
        return a.x1 * this.x1 + a.x2 * this.x2 + a.x3 * this.x3;
    }

    public double norm() {
        return Math.sqrt(this.x1 * this.x1 + this.x2 * this.x2 + this.x3 * this.x3);
    }

    public double quadnorm() {
        return this.x1 * this.x1 + this.x2 * this.x2 + this.x3 * this.x3;
    }

    public void normalize() {
        double n = Math.sqrt(this.x1 * this.x1 + this.x2 * this.x2 + this.x3 * this.x3);
        this.x1 /= n;
        this.x2 /= n;
        this.x3 /= n;
    }

    public String toString() {
        return "(" + this.x1 + "," + this.x2 + "," + this.x3 + ")";
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.x1) || Double.isInfinite(this.x2) || Double.isInfinite(this.x3);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x1) || Double.isNaN(this.x2) || Double.isNaN(this.x3);
    }

    public boolean isReal() {
        return !this.isNaN() && !this.isInfinite();
    }

    public Object clone() {
        return new Punkt3D(this.x1, this.x2, this.x3);
    }
}

