/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.objects;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.util.MiscDrawing2D;
import uibk.mtk.draw3d.base.Drawable3D;
import uibk.mtk.draw3d.objects.Messages;
import uibk.mtk.draw3d.util.LineClipping3D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.geom.Punkt3D;

public class MathArrow3D
extends Drawable3D {
    protected Punkt3D base = new Punkt3D();
    protected Punkt3D head = new Punkt3D();
    protected int lengtharrowhead = 10;
    protected int offsetwings = 5;

    public void setLengthArrowHead(int length) {
        if (length < 0) {
            throw new IllegalArgumentException(Messages.getString("MathArrow3D.0"));
        }
        this.lengtharrowhead = length;
    }

    public void setOffsetWings(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException(Messages.getString("MathArrow3D.1"));
        }
        this.lengtharrowhead = length;
    }

    public MathArrow3D(Punkt3D base, Punkt3D head) {
        base.setLocation(base);
        head.setLocation(head);
    }

    public MathArrow3D() {
        this.head.x1 = 1.0;
    }

    public Punkt3D getHead() {
        return this.head;
    }

    public Punkt3D getBase() {
        return this.base;
    }

    public void setBase(Punkt3D base) {
        this.base.setLocation(base);
    }

    public void setHead(Punkt3D head) {
        this.head.setLocation(head);
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        g2.setColor(this.color);
        Punkt3D cbase = new Punkt3D();
        Punkt3D chead = new Punkt3D();
        Punkt3D wc_base = this.scene3d.getWC(this.base);
        Punkt3D wc_head = this.scene3d.getWC(this.head);
        if (LineClipping3D.clipline3d(wc_base, wc_head, cbase, chead, this.scene3d.getClippingPlane())) {
            Punkt2D phead = new Punkt2D(this.scene3d.wctoDevice(chead));
            Punkt2D pbase = new Punkt2D(this.scene3d.wctoDevice(cbase));
            MiscDrawing2D.drawArrow(g2, pbase, phead, this.lengtharrowhead, this.offsetwings);
        }
    }
}

