/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.mtk.draw2d.util.LineClipping2D;
import uibk.mtk.draw3d.base.Drawable3D;
import uibk.mtk.draw3d.util.LineClipping3D;
import uibk.mtk.geom.CoordinateBox3D;
import uibk.mtk.geom.GeomUtil;
import uibk.mtk.geom.Punkt3D;

public class Graph3D
extends Drawable3D {
    protected Stroke stroke = new BasicStroke();
    protected Vector points = new Vector();
    protected boolean limitsdirty = true;
    protected CoordinateBox3D limits = new CoordinateBox3D();

    public Graph3D() {
        this.color = Color.red;
    }

    protected void recalcLimits() {
        this.limits = this.points != null && this.points.size() > 0 ? GeomUtil.getLimits3D(this.points) : new CoordinateBox3D();
    }

    public void addPoint(Punkt3D p) {
        this.points.add(p);
        this.limitsdirty = true;
    }

    public void clearpoints() {
        this.points.clear();
        this.limits = new CoordinateBox3D();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setPoints(Vector points) {
        this.points = points;
        this.limitsdirty = true;
    }

    public CoordinateBox3D getLimits() {
        if (this.limitsdirty) {
            this.recalcLimits();
        }
        return (CoordinateBox3D)this.limits.clone();
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.stroke);
        g2.setColor(this.color);
        Punkt3D[] vertices = new Punkt3D[this.points.size()];
        int i = 0;
        while (i < vertices.length) {
            vertices[i] = this.scene3d.getWC((Punkt3D)this.points.elementAt(i));
            ++i;
        }
        Rectangle clippingrect = new Rectangle(0, 0, this.panel.getWidth(), this.panel.getHeight());
        double yc = this.scene3d.getClippingPlane();
        Punkt3D ca = new Punkt3D();
        Punkt3D cb = new Punkt3D();
        Point p = new Point();
        Point q = new Point();
        int i2 = 0;
        while (i2 < this.points.size() - 1) {
            Point p2;
            Point p1;
            Punkt3D start = vertices[i2];
            Punkt3D end = vertices[i2 + 1];
            if (LineClipping3D.clipline3d(start, end, ca, cb, yc) && LineClipping2D.cohensutherland(p1 = this.scene3d.wctoDevice(ca), p2 = this.scene3d.wctoDevice(cb), p, q, clippingrect)) {
                g2.drawLine(p.x, p.y, q.x, q.y);
            }
            ++i2;
        }
        g2.setStroke(oldStroke);
    }
}

