/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.mtk.draw3d.base.Drawable3D;
import uibk.mtk.draw3d.base.MathPanel3D;
import uibk.mtk.draw3d.objects.MathArrow3D;
import uibk.mtk.draw3d.objects.MathPoint3D;
import uibk.mtk.draw3d.objects.Messages;
import uibk.mtk.geom.Punkt3D;
import uibk.mtk.geom.Vector3D;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.DerivationException;
import uibk.mtk.math.functions.ParametricCurve3D;
import uibk.mtk.math.functions.SingularPointException;

public class Dreibein
extends Drawable3D
implements PrepaintComputable {
    ParametricCurve3D curve;
    double parameterpos = 0.0;
    MathArrow3D arrowVelocity = new MathArrow3D();
    MathArrow3D arrowAcceleration = new MathArrow3D();
    MathArrow3D arrowNormal = new MathArrow3D();
    MathPoint3D basepoint = new MathPoint3D();
    int mode;
    public static final int DRAW_VELOCITY = 0;
    public static final int DRAW_VELOCITY_AND_ACCELERATION = 1;
    public static final int DRAW_DREIBEIN = 2;
    private Vector3D velocity = new Vector3D();
    private Vector3D acceleration = new Vector3D();
    private Vector3D normal = new Vector3D();
    Interval interval = new Interval(0.0, 1.0);

    public void setMode(int style) {
        this.mode = style;
    }

    public Dreibein(ParametricCurve3D curve) {
        this();
        this.curve = curve;
    }

    public Interval getParameterInterval() {
        return (Interval)this.interval.clone();
    }

    public void setParameterInterval(Interval interval) {
        this.interval = interval;
    }

    public Dreibein() {
        this.arrowVelocity.setColor(Color.blue);
        this.arrowAcceleration.setColor(Color.green);
        this.arrowNormal.setColor(Color.orange);
        this.basepoint.setColor(Color.blue);
        this.draw = false;
    }

    public int getMode() {
        return this.mode;
    }

    private Vector3D calcVelocityVector() throws Exception {
        Vector3D velocity;
        try {
            velocity = this.curve.velocityVector(this.parameterpos);
        }
        catch (SingularPointException ex) {
            this.draw = false;
            throw new Exception(String.valueOf(Messages.getString("Dreibein.0")) + this.parameterpos);
        }
        catch (DerivationException ex) {
            this.draw = false;
            throw new Exception(ex.getMessage());
        }
        return velocity;
    }

    private Vector3D calcAccelerationVector() throws Exception {
        Vector3D acceleration;
        try {
            acceleration = this.curve.accelerationVector(this.parameterpos);
        }
        catch (DerivationException ex) {
            this.draw = false;
            throw new Exception(ex.getMessage());
        }
        return acceleration;
    }

    @Override
    public void prepaintcompute() throws Exception {
        Punkt3D base = this.curve.calcPoint(this.parameterpos);
        this.draw = true;
        this.basepoint.setCoordinates(base);
        switch (this.mode) {
            case 0: {
                this.velocity = this.calcVelocityVector();
                Punkt3D headV = base.add(this.velocity);
                this.arrowVelocity.setBase(base);
                this.arrowVelocity.setHead(headV);
                break;
            }
            case 1: {
                this.velocity = this.calcVelocityVector();
                Punkt3D headV = base.add(this.velocity);
                this.arrowVelocity.setBase(base);
                this.arrowVelocity.setHead(headV);
                this.acceleration = this.calcAccelerationVector();
                Punkt3D headA = base.add(this.acceleration);
                this.arrowAcceleration.setBase(base);
                this.arrowAcceleration.setHead(headA);
                break;
            }
            case 2: {
                this.velocity = this.calcVelocityVector();
                this.acceleration = this.calcAccelerationVector();
                this.normal = this.velocity.crossProd(this.acceleration);
                this.acceleration = this.normal.crossProd(this.velocity);
                this.velocity.normalize();
                this.acceleration.normalize();
                this.normal.normalize();
                double scale = this.scene3d.getBoundingBox().maxBoundingBox() / 2.0;
                this.velocity.scaleself(scale);
                this.acceleration.scaleself(scale);
                this.normal.scaleself(scale);
                Punkt3D headV = base.add(this.velocity);
                Punkt3D headA = base.add(this.acceleration);
                Punkt3D headN = base.add(this.normal);
                this.arrowVelocity.setBase(base);
                this.arrowVelocity.setHead(headV);
                this.arrowAcceleration.setBase(base);
                this.arrowAcceleration.setHead(headA);
                this.arrowNormal.setBase(base);
                this.arrowNormal.setHead(headN);
            }
        }
    }

    public Vector3D getAccelerationVector() {
        return this.acceleration;
    }

    public Vector3D getVelocityVector() {
        return this.velocity;
    }

    public Vector3D getNormalVector() {
        return this.normal;
    }

    public double getParameterPos() {
        return this.parameterpos;
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (!this.draw) {
            return;
        }
        switch (this.mode) {
            case 0: {
                this.arrowVelocity.draw(framebuffer, g2);
                break;
            }
            case 1: {
                this.arrowVelocity.draw(framebuffer, g2);
                this.arrowAcceleration.draw(framebuffer, g2);
                break;
            }
            case 2: {
                this.arrowVelocity.draw(framebuffer, g2);
                this.arrowAcceleration.draw(framebuffer, g2);
                this.arrowNormal.draw(framebuffer, g2);
                break;
            }
        }
        this.basepoint.draw(framebuffer, g2);
    }

    @Override
    public void setMathPanel3D(MathPanel3D panel) {
        super.setMathPanel3D(panel);
        this.arrowVelocity.setMathPanel3D(panel);
        this.arrowAcceleration.setMathPanel3D(panel);
        this.arrowNormal.setMathPanel3D(panel);
        this.basepoint.setMathPanel3D(panel);
    }

    public void setParameterPos(double param) {
        if (!this.interval.contains(param)) {
            throw new IllegalArgumentException();
        }
        this.parameterpos = param;
    }

    public void setParametricCurve(ParametricCurve3D curve) {
        this.curve = curve;
    }
}

