/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.parametriccurve3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.parametriccurve3d.AppletParametricCurve3D;
import uibk.applets.parametriccurve3d.Messages;
import uibk.mtk.geom.Vector3D;
import uibk.mtk.math.Interval;
import uibk.mtk.swing.base.DoubleSlider;
import uibk.mtk.swing.base.DoubleTextField;
import uibk.mtk.swing.base.TitledPanel;
import uibk.mtk.text.Formatter;

class PanelDreibein
extends TitledPanel
implements ActionListener {
    AppletParametricCurve3D main;
    ButtonGroup groupDreibeinOpt = new ButtonGroup();
    DoubleSlider slider = new DoubleSlider();
    JRadioButton optVelocity;
    JRadioButton optNothing;
    JRadioButton optDreibein;
    JRadioButton optVelocityAndAccel;
    DoubleTextField texttime;
    JLabel label = new JLabel(Messages.getString("PanelDreibein.0"));
    Formatter formatter = new Formatter();

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.optNothing.setSelected(true);
            this.texttime.setEnabled(false);
            this.label.setEnabled(false);
            this.slider.setEnabled(false);
        }
    }

    public PanelDreibein(AppletParametricCurve3D main) {
        super(Messages.getString("PanelDreibein.1"));
        this.main = main;
        this.initComponents();
    }

    void initComponents() {
        this.setPreferredSize(new Dimension(2000, 210));
        this.setLayout(new GridBagLayout());
        this.optVelocity = new JRadioButton(Messages.getString("PanelDreibein.2"));
        this.optVelocity.setActionCommand("velocity");
        this.optVelocity.addActionListener(this);
        this.optVelocity.setToolTipText(Messages.getString("PanelDreibein.4"));
        this.optNothing = new JRadioButton(Messages.getString("PanelDreibein.3"));
        this.optNothing.setActionCommand("dreibein_nothing");
        this.optNothing.addActionListener(this);
        this.optNothing.setToolTipText(Messages.getString("PanelDreibein.7"));
        this.optDreibein = new JRadioButton(Messages.getString("PanelDreibein.8"));
        this.optDreibein.setActionCommand("velocity_normal");
        this.optDreibein.addActionListener(this);
        this.optDreibein.setToolTipText(Messages.getString("PanelDreibein.10"));
        this.optVelocityAndAccel = new JRadioButton(Messages.getString("PanelDreibein.11"));
        this.optVelocityAndAccel.setActionCommand("velocity_acceleration");
        this.optVelocityAndAccel.addActionListener(this);
        this.optVelocityAndAccel.setToolTipText(Messages.getString("PanelDreibein.13"));
        this.optNothing.setSelected(true);
        this.groupDreibeinOpt.add(this.optNothing);
        this.groupDreibeinOpt.add(this.optVelocityAndAccel);
        this.groupDreibeinOpt.add(this.optVelocity);
        this.groupDreibeinOpt.add(this.optDreibein);
        this.slider.setToolTipText(Messages.getString("PanelDreibein.14"));
        this.slider.setValue(0);
        this.slider.setEnabled(false);
        this.label = new JLabel(Messages.getString("PanelDreibein.15"));
        this.texttime = new DoubleTextField(8, null, null, null, null);
        this.texttime.setActionCommand("goto");
        this.texttime.addActionListener(this);
        this.texttime.setToolTipText(Messages.getString("PanelDreibein.17"));
        this.add((Component)this.optNothing, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.optVelocity, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.optVelocityAndAccel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.optDreibein, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.slider, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.label, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.texttime, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DoubleSlider slider = (DoubleSlider)evt.getSource();
                double value = slider.getDoubleValue();
                PanelDreibein.this.main.dreibein.setParameterPos(value);
                if (PanelDreibein.this.groupDreibeinOpt.getSelection().getActionCommand().equals("velocity")) {
                    PanelDreibein.this.main.dreibein.setMode(0);
                    try {
                        PanelDreibein.this.main.dreibein.prepaintcompute();
                        PanelDreibein.this.main.mathpanel3d.report(PanelDreibein.this.getReportString());
                    }
                    catch (Exception ex) {
                        PanelDreibein.this.main.mathpanel3d.reportError(ex);
                    }
                }
                if (PanelDreibein.this.groupDreibeinOpt.getSelection().getActionCommand().equals("velocity_normal")) {
                    PanelDreibein.this.main.dreibein.setMode(2);
                    try {
                        PanelDreibein.this.main.dreibein.prepaintcompute();
                        PanelDreibein.this.main.mathpanel3d.report(PanelDreibein.this.getReportString());
                    }
                    catch (Exception ex) {
                        PanelDreibein.this.main.mathpanel3d.reportError(ex);
                    }
                }
                if (PanelDreibein.this.groupDreibeinOpt.getSelection().getActionCommand().equals("velocity_acceleration")) {
                    PanelDreibein.this.main.dreibein.setMode(1);
                    try {
                        PanelDreibein.this.main.dreibein.prepaintcompute();
                        PanelDreibein.this.main.mathpanel3d.report(PanelDreibein.this.getReportString());
                    }
                    catch (Exception ex) {
                        PanelDreibein.this.main.mathpanel3d.reportError(ex);
                    }
                }
                PanelDreibein.this.main.mathpanel3d.repaint();
            }
        });
    }

    private String roundParam(double x) {
        double dist = this.main.mathpanel3d.getScene3D().getBoundingBox().minBoundingBox() / 1000.0;
        return this.formatter.format(x, dist);
    }

    private String roundVector(Vector3D v) {
        double dist = this.main.mathpanel3d.getScene3D().getBoundingBox().minBoundingBox() / 1000.0;
        String rx = this.formatter.format(v.x1, dist);
        String ry = this.formatter.format(v.x2, dist);
        String rz = this.formatter.format(v.x3, dist);
        return "(" + rx + "," + ry + "," + rz + ")";
    }

    String getReportString() {
        String str = null;
        int mode = this.main.dreibein.getMode();
        switch (mode) {
            case 0: {
                str = "t=" + String.valueOf(this.roundParam(this.main.dreibein.getParameterPos())) + " v=" + this.roundVector(this.main.dreibein.getVelocityVector()).toString();
                break;
            }
            case 1: {
                str = "t=" + String.valueOf(this.roundParam(this.main.dreibein.getParameterPos())) + " v=" + this.roundVector(this.main.dreibein.getVelocityVector()).toString() + "  a=" + this.roundVector(this.main.dreibein.getAccelerationVector()).toString();
                break;
            }
            case 2: {
                str = "t=" + String.valueOf(this.roundParam(this.main.dreibein.getParameterPos())) + " v=" + this.roundVector(this.main.dreibein.getVelocityVector()).toString() + "  a=" + this.roundVector(this.main.dreibein.getAccelerationVector()).toString() + "  n=" + this.roundVector(this.main.dreibein.getNormalVector()).toString();
                break;
            }
        }
        return str;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("dreibein_nothing")) {
            this.main.dreibein.setVisible(false);
            this.slider.setEnabled(false);
            this.label.setEnabled(false);
            this.texttime.setEnabled(false);
        }
        if (ev.getActionCommand().equals("velocity")) {
            this.activateZweibein(0);
        }
        if (ev.getActionCommand().equals("velocity_normal")) {
            this.activateZweibein(2);
        }
        if (ev.getActionCommand().equals("velocity_acceleration")) {
            this.activateZweibein(1);
        }
        if (ev.getActionCommand().equals("goto")) {
            this.gotoparam();
        }
        this.main.mathpanel3d.repaint();
    }

    private void activateZweibein(int mode) {
        this.main.dreibein.setMode(mode);
        if (mode == 2) {
            this.main.mathpanel3d.getScene3D().setScalingMode(0);
            this.main.panelscale3d.update();
        }
        this.main.dreibein.setParameterPos(this.slider.getDoubleValue());
        this.slider.setEnabled(true);
        this.main.dreibein.setVisible(true);
        this.label.setEnabled(true);
        this.texttime.setEnabled(true);
        this.main.mathpanel3d.repaint();
    }

    private void gotoparam() {
        try {
            double param = Double.parseDouble(this.texttime.getText());
            Interval interval = this.main.dreibein.getParameterInterval();
            if (!interval.contains(param)) {
                this.main.mathpanel3d.reportError(String.valueOf(Messages.getString("PanelDreibein.39")) + interval + Messages.getString("PanelDreibein.40"));
                return;
            }
            this.main.dreibein.setParameterPos(param);
            this.main.mathpanel3d.repaint();
            this.main.mathpanel3d.report(this.getReportString());
        }
        catch (Exception ex) {
            this.main.mathpanel3d.reportError(ex);
        }
    }
}

