/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.swing.Messages;
import uibk.mtk.swing.base.ButtonNoFocus;
import uibk.mtk.swing.base.TitledPanel;

public class PanelScale2D
extends TitledPanel
implements ActionListener {
    protected JRadioButton optAxesEqual;
    protected JRadioButton optAxesIndependent;
    protected ButtonNoFocus buttonBothZoomIn;
    protected ButtonNoFocus buttonBothZoomOut;
    protected ButtonNoFocus buttonXZoomIn;
    protected ButtonNoFocus buttonXZoomOut;
    protected ButtonNoFocus buttonYZoomIn;
    protected ButtonNoFocus buttonYZoomOut;
    MathPanel2D mathpanel2d;
    CoordinateRect2D limits = new CoordinateRect2D();
    private static final String STRTITLE = Messages.getString("PanelScale2D.0");
    private static final String STRINDEPENDENTLY = Messages.getString("PanelScale2D.1");
    private static final String STREQUAL = Messages.getString("PanelScale2D.2");
    private double scalefactor = 1.3;
    Scene2D scene2d;

    public PanelScale2D(MathPanel2D mathpanel2d) {
        super(STRTITLE);
        if (mathpanel2d == null) {
            throw new NullPointerException(Messages.getString("PanelScale2D.3"));
        }
        this.mathpanel2d = mathpanel2d;
        this.scene2d = mathpanel2d.getScene2d();
        this.initComponents();
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 220));
        this.optAxesIndependent = new JRadioButton(STRINDEPENDENTLY);
        this.optAxesIndependent.setActionCommand("axes_independent");
        this.optAxesIndependent.addActionListener(this);
        this.optAxesEqual = new JRadioButton(STREQUAL);
        this.optAxesEqual.setActionCommand("axes_equal");
        this.optAxesEqual.addActionListener(this);
        ButtonGroup groupAxesOpt = new ButtonGroup();
        groupAxesOpt.add(this.optAxesEqual);
        groupAxesOpt.add(this.optAxesIndependent);
        URL urlIconPlus = this.getClass().getResource("res/plus.gif");
        URL urlIconMinus = this.getClass().getResource("res/minus.gif");
        this.buttonBothZoomIn = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.buttonBothZoomOut = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.buttonBothZoomIn.setActionCommand("bothzoomin");
        this.buttonBothZoomOut.setActionCommand("bothzoomout");
        this.buttonXZoomIn = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.buttonXZoomOut = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.buttonXZoomIn.setActionCommand("xzoomin");
        this.buttonXZoomOut.setActionCommand("xzoomout");
        this.buttonYZoomIn = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.buttonYZoomOut = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.buttonYZoomIn.setActionCommand("yzoomin");
        this.buttonYZoomOut.setActionCommand("yzoomout");
        this.buttonBothZoomIn.addActionListener(this);
        this.buttonBothZoomOut.addActionListener(this);
        this.buttonXZoomIn.addActionListener(this);
        this.buttonXZoomOut.addActionListener(this);
        this.buttonYZoomIn.addActionListener(this);
        this.buttonYZoomOut.addActionListener(this);
        this.update();
        this.add((Component)this.optAxesEqual, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonBothZoomOut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonBothZoomIn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.buttonYZoomIn, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
        this.add((Component)this.optAxesIndependent, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonXZoomOut, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonXZoomIn, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.buttonYZoomOut, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("bothzoomout")) {
            this.scene2d.setScaleFactorX(this.scene2d.getScaleFactorX() * this.scalefactor);
            this.scene2d.setScaleFactorY(this.scene2d.getScaleFactorY() * this.scalefactor);
        }
        if (ev.getActionCommand().equals("bothzoomin")) {
            this.scene2d.setScaleFactorX(this.scene2d.getScaleFactorX() * 1.0 / this.scalefactor);
            this.scene2d.setScaleFactorY(this.scene2d.getScaleFactorY() * 1.0 / this.scalefactor);
        }
        if (ev.getActionCommand().equals("xzoomout")) {
            this.scene2d.setScaleFactorX(this.scene2d.getScaleFactorX() * this.scalefactor);
        }
        if (ev.getActionCommand().equals("yzoomout")) {
            this.scene2d.setScaleFactorY(this.scene2d.getScaleFactorY() * this.scalefactor);
        }
        if (ev.getActionCommand().equals("xzoomin")) {
            this.scene2d.setScaleFactorX(this.scene2d.getScaleFactorX() * 1.0 / this.scalefactor);
        }
        if (ev.getActionCommand().equals("yzoomin")) {
            this.scene2d.setScaleFactorY(this.scene2d.getScaleFactorY() * 1.0 / this.scalefactor);
        }
        if (ev.getActionCommand().equals("axes_equal")) {
            this.scene2d.setLimits(this.limits);
            this.scene2d.axesequal(true);
            this.scene2d.setScaleFactorX(1.0);
            this.scene2d.setScaleFactorY(1.0);
        }
        if (ev.getActionCommand().equals("axes_independent")) {
            this.scene2d.setLimits(this.limits);
            this.scene2d.axesequal(false);
            this.scene2d.setScaleFactorX(1.0);
            this.scene2d.setScaleFactorY(1.0);
        }
        this.update();
        this.mathpanel2d.repaint();
    }

    public void update() {
        this.limits = (CoordinateRect2D)this.mathpanel2d.getScene2d().getOriginalLimits().clone();
        if (this.mathpanel2d.getScene2d().isAxesEqualEnabled()) {
            this.optAxesEqual.setSelected(true);
        } else {
            this.optAxesIndependent.setSelected(true);
        }
        if (this.optAxesEqual.isSelected()) {
            this.optAxesEqual.setSelected(true);
            this.buttonXZoomIn.setEnabled(false);
            this.buttonXZoomOut.setEnabled(false);
            this.buttonYZoomIn.setEnabled(false);
            this.buttonYZoomOut.setEnabled(false);
            this.buttonBothZoomIn.setEnabled(true);
            this.buttonBothZoomOut.setEnabled(true);
        } else {
            this.optAxesIndependent.setSelected(true);
            this.buttonXZoomIn.setEnabled(true);
            this.buttonXZoomOut.setEnabled(true);
            this.buttonYZoomIn.setEnabled(true);
            this.buttonYZoomOut.setEnabled(true);
            this.buttonBothZoomIn.setEnabled(false);
            this.buttonBothZoomOut.setEnabled(false);
            this.optAxesIndependent.setSelected(true);
        }
    }

    public void setScaleFactor(double factor) {
        if (factor <= 1.0) {
            throw new IllegalArgumentException("");
        }
        this.scalefactor = factor;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            if (this.mathpanel2d.getScene2d().isAxesEqualEnabled()) {
                this.optAxesEqual.setSelected(true);
            } else {
                this.optAxesIndependent.setSelected(true);
            }
            this.update();
        }
    }
}

