/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.FixedArrow2D;
import uibk.mtk.draw2d.objects.MathArrow2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.draw2d.objects.Messages;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.geom.Vector2D;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.DerivationException;
import uibk.mtk.math.functions.ParametricCurve2D;
import uibk.mtk.math.functions.SingularPointException;

public class Zweibein
extends Drawable2D
implements PrepaintComputable {
    ParametricCurve2D curve;
    double parameterpos = 0.0;
    Vector2D velocity = new Vector2D();
    Vector2D acceleration = new Vector2D();
    Vector2D normal = new Vector2D();
    MathArrow2D arrowVelocity = new MathArrow2D();
    MathArrow2D arrowAcceleration = new MathArrow2D();
    FixedArrow2D arrowVelocityFixed = new FixedArrow2D();
    FixedArrow2D arrowNormalFixed = new FixedArrow2D();
    MathPoint2D basepoint = new MathPoint2D();
    int mode;
    public static final int DRAW_VELOCITY = 0;
    public static final int DRAW_ZWEIBEIN = 1;
    public static final int DRAW_VELOCITY_AND_ACCELERATION = 2;
    Interval interval = new Interval(0.0, 1.0);

    public void setMode(int style) {
        this.mode = style;
    }

    public Interval getParameterInterval() {
        return (Interval)this.interval.clone();
    }

    public void setParameterInterval(Interval interval) {
        this.interval = interval;
    }

    public Zweibein() {
        this.arrowVelocity.setColor(Color.blue);
        this.arrowAcceleration.setColor(Color.green);
        this.arrowVelocityFixed.setColor(Color.blue);
        this.arrowNormalFixed.setColor(Color.green);
        this.basepoint.setColor(Color.blue);
        this.basepoint.setRadius(2);
    }

    public Zweibein(ParametricCurve2D curve) {
        this();
        this.curve = curve;
    }

    public Vector2D getAccelerationVector() {
        return this.acceleration;
    }

    public Vector2D getVelocityVector() {
        return this.velocity;
    }

    public Vector2D getNormalVector() {
        return this.normal;
    }

    private Vector2D calcVelocityVector() throws Exception {
        Vector2D dirV;
        try {
            dirV = this.curve.velocityVector(this.parameterpos);
        }
        catch (SingularPointException ex) {
            this.draw = false;
            throw new Exception(String.valueOf(Messages.getString("Zweibein.0")) + this.parameterpos);
        }
        catch (DerivationException ex) {
            this.draw = false;
            throw new Exception(ex.getMessage());
        }
        return dirV;
    }

    private Vector2D calcAccelerationVector() throws Exception {
        try {
            return this.curve.accelerationVector(this.parameterpos);
        }
        catch (Exception ex) {
            this.draw = false;
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public void prepaintcompute() throws Exception {
        this.draw = true;
        Punkt2D base = this.curve.calcPoint(this.parameterpos);
        this.basepoint.setCoordinates(base);
        switch (this.mode) {
            case 0: {
                this.velocity = this.calcVelocityVector();
                this.arrowVelocity.setBase(base);
                Punkt2D headV = base.add(this.velocity);
                this.arrowVelocity.setHead(headV);
                this.arrowVelocity.prepaintcompute();
                break;
            }
            case 2: {
                this.velocity = this.calcVelocityVector();
                this.arrowVelocity.setBase(base);
                Punkt2D headV = base.add(this.velocity);
                this.arrowVelocity.setHead(headV);
                this.arrowVelocity.prepaintcompute();
                this.acceleration = this.calcAccelerationVector();
                Punkt2D headA = base.add(this.acceleration);
                this.arrowAcceleration.setBase(base);
                this.arrowAcceleration.setHead(headA);
                this.arrowAcceleration.prepaintcompute();
                break;
            }
            case 1: {
                this.velocity = this.calcVelocityVector();
                this.arrowVelocityFixed.setBase(base);
                this.arrowVelocityFixed.setDirection(this.velocity);
                this.arrowVelocityFixed.setLength(this.panel.getWidth() / 5);
                this.arrowVelocityFixed.prepaintcompute();
                this.normal = new Vector2D(-this.velocity.y, this.velocity.x);
                this.arrowNormalFixed.setBase(base);
                this.arrowNormalFixed.setDirection(this.normal);
                this.arrowNormalFixed.setLength(this.panel.getWidth() / 5);
                this.arrowNormalFixed.prepaintcompute();
            }
        }
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (!this.draw) {
            return;
        }
        switch (this.mode) {
            case 0: {
                this.arrowVelocity.draw(framebuffer, g2);
                this.basepoint.draw(framebuffer, g2);
                break;
            }
            case 2: {
                this.arrowVelocity.draw(framebuffer, g2);
                this.arrowAcceleration.draw(framebuffer, g2);
                this.basepoint.draw(framebuffer, g2);
                break;
            }
            case 1: {
                this.arrowNormalFixed.draw(framebuffer, g2);
                this.arrowVelocityFixed.draw(framebuffer, g2);
                this.basepoint.draw(framebuffer, g2);
                break;
            }
        }
    }

    @Override
    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
        this.arrowVelocity.setMathPanel2D(panel);
        this.arrowVelocityFixed.setMathPanel2D(panel);
        this.arrowNormalFixed.setMathPanel2D(panel);
        this.arrowAcceleration.setMathPanel2D(panel);
        this.basepoint.setMathPanel2D(panel);
    }

    public void setParameterPos(double param) {
        if (!this.interval.contains(param)) {
            throw new IllegalArgumentException();
        }
        this.parameterpos = param;
    }

    public int getMode() {
        return this.mode;
    }

    public double getParameterPos() {
        return this.parameterpos;
    }

    public void setParametricCurve(ParametricCurve2D curve) {
        this.curve = curve;
    }
}

