/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.parametriccurve2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.parametriccurve2d.AppletParametricCurve2D;
import uibk.applets.parametriccurve2d.Messages;
import uibk.mtk.draw2d.util.GraphUtil;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ParametricCurve2D;
import uibk.mtk.math.parsing.ParametricCurve2DParser;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.MPanel;

public class PanelCurve
extends MPanel
implements ActionListener {
    private final AppletParametricCurve2D main;
    JTextField textFormula;
    IntervalTextField textParamInterval;
    JCheckBox checkDefinePoints;
    JButton buttonCalc;
    boolean defaultNumPoints = true;
    JSlider sliderPlotPoints;
    JLabel labelpoints;

    public PanelCurve(AppletParametricCurve2D main) {
        this.main = main;
        this.initComponents();
    }

    void initComponents() {
        TitledBorder border = BorderFactory.createTitledBorder(Messages.getString("PanelCurve.0"));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(2000, 210));
        this.textFormula = new JTextField(16);
        this.textFormula.setActionCommand("compute");
        this.textFormula.addActionListener(this);
        this.textFormula.setToolTipText(String.valueOf(Messages.getString("PanelCurve.2")) + 't' + Messages.getString("PanelCurve.3"));
        this.textParamInterval = new IntervalTextField(8, Messages.getString("PanelCurve.1"), true);
        this.textFormula.setActionCommand("compute");
        this.textFormula.addActionListener(this);
        this.textFormula.setToolTipText(Messages.getString("PanelCurve.6"));
        this.checkDefinePoints = new JCheckBox(Messages.getString("PanelCurve.7"));
        this.checkDefinePoints.setActionCommand("definepoints");
        this.checkDefinePoints.addActionListener(this);
        this.checkDefinePoints.setToolTipText(Messages.getString("PanelCurve.9"));
        JLabel labelFormula = new JLabel("(x(t),y(t))=");
        this.buttonCalc = new JButton(Messages.getString("PanelCurve.4"));
        this.buttonCalc.setActionCommand("compute");
        this.buttonCalc.addActionListener(this);
        this.buttonCalc.setToolTipText(Messages.getString("PanelCurve.15"));
        this.labelpoints = new JLabel(String.valueOf(Messages.getString("PanelCurve.16")) + 500);
        this.sliderPlotPoints = new JSlider();
        this.sliderPlotPoints.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                PanelCurve.this.labelpoints.setText(String.valueOf(Messages.getString("PanelCurve.17")) + String.valueOf(n));
            }
        });
        this.sliderPlotPoints.setMinimum(5);
        this.sliderPlotPoints.setMaximum(2000);
        this.sliderPlotPoints.setValue(500);
        this.sliderPlotPoints.setEnabled(!this.defaultNumPoints);
        this.labelpoints.setEnabled(!this.defaultNumPoints);
        this.add((Component)labelFormula, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.textFormula, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCurve.18")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.textParamInterval, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.checkDefinePoints, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.labelpoints, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 0), 0, 0));
        this.add((Component)this.sliderPlotPoints, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.buttonCalc, new GridBagConstraints(0, 5, 3, 1, 0.5, 0.0, 10, 0, new Insets(0, 0, 3, 0), 0, 0));
    }

    private ParametricCurve2D getFunction() {
        try {
            String strfunc = this.textFormula.getText();
            return ParametricCurve2DParser.parse('t', strfunc);
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(Messages.getString("PanelCurve.19"), e);
            return null;
        }
    }

    void compute() {
        this.main.panelzweibein.slider.setValue(0);
        this.main.panelzweibein.setEnabled(false);
        this.main.zweibein.setVisible(false);
        ParametricCurve2D curve = this.getFunction();
        if (curve == null) {
            return;
        }
        this.main.zweibein.setParametricCurve(curve);
        try {
            Interval interval = this.textParamInterval.getInterval();
            int numpoints = this.defaultNumPoints ? 500 : this.sliderPlotPoints.getValue();
            this.main.graph.setPoints(GraphUtil.compute(curve, interval.a, interval.b, numpoints));
            this.main.mathpanel2d.getScene2d().setLimits(this.main.graph.getLimits());
            this.main.panelaxes.update();
            this.main.axes.setVisible(true);
            this.main.panelzweibein.slider.setDoubleMinimum(interval.a);
            this.main.panelzweibein.slider.setDoubleMaximum(interval.b);
            if (this.defaultNumPoints) {
                this.main.panelzweibein.setEnabled(true);
                this.main.zweibein.setParameterInterval(interval);
                this.main.panelzweibein.slider.setNumTicks(numpoints);
            } else {
                this.main.panelzweibein.setEnabled(false);
            }
            this.main.panelaxes.setEnabled(true);
            this.main.panelzweibein.setEnabled(true);
            this.main.panelenlarge.setEnabled(true);
            this.main.mathpanel2d.repaint();
            this.main.mathpanel2d.reportSuccess(Messages.getString("PanelCurve.20"));
        }
        catch (Exception ex) {
            this.main.panelzweibein.setEnabled(false);
            this.main.panelaxes.setEnabled(false);
            this.main.panelenlarge.setEnabled(false);
            this.main.mathpanel2d.reportError(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("compute")) {
            this.main.panelzweibein.setEnabled(false);
            this.compute();
        }
        if (ev.getActionCommand().equals("definepoints")) {
            this.defaultNumPoints = !this.checkDefinePoints.isSelected();
            this.sliderPlotPoints.setEnabled(this.checkDefinePoints.isSelected());
            this.labelpoints.setEnabled(this.checkDefinePoints.isSelected());
            this.main.panelzweibein.setEnabled(false);
            this.main.zweibein.setVisible(false);
        }
    }
}

