/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.datatable;

import javax.swing.table.AbstractTableModel;
import uibk.mtk.swing.datatable.Datagrid;

public class MyTableModel
extends AbstractTableModel {
    transient Datagrid datagrid = new Datagrid();
    String[] columnnames;
    String countername = "n";
    boolean editable = true;

    public MyTableModel(double[][] data) {
        if (data != null) {
            this.setData(data);
        }
    }

    public void cleardata() {
        this.datagrid.clear();
    }

    public MyTableModel(int rows, int cols) {
        this.datagrid = new Datagrid(rows, cols);
    }

    public void create(int rows, int cols) {
        this.datagrid = new Datagrid(rows, cols);
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.datagrid.getRows();
    }

    @Override
    public int getColumnCount() {
        if (this.columnnames != null) {
            return this.columnnames.length + 1;
        }
        if (this.datagrid == null || this.datagrid.isEmpty()) {
            return 0;
        }
        return this.datagrid.getColumns() + 1;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        return this.editable;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return this.countername;
        }
        if (this.columnnames == null) {
            return "x" + columnIndex;
        }
        return this.columnnames[columnIndex - 1];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return;
        }
        try {
            double d = Double.parseDouble(aValue.toString());
            this.datagrid.setValue(new Double(d), rowIndex, columnIndex - 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void setData(double[][] data) {
        this.cleardata();
        int m = data[0].length;
        int n = data.length;
        this.datagrid = new Datagrid(m, n);
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                this.setValueAt(new Double(data[j][i]), i, j + 1);
                ++j;
            }
            ++i;
        }
        this.fireTableStructureChanged();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return String.valueOf(row + 1);
        }
        Object obj = this.datagrid.getValue(row, col - 1);
        if (obj == null) {
            return "";
        }
        return obj;
    }
}

