/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.bisection;

import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import uibk.applets.bisection.Messages;
import uibk.mtk.swing.datatable.DataTable;

public class ReportingTable
extends DataTable {
    MyCellRenderer cellrenderer = new MyCellRenderer();
    static String[] labels = new String[]{Messages.getString("Approximation"), Messages.getString("Error")};

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.cellrenderer;
    }

    public ReportingTable() {
        super(labels);
        this.setShowGrid(false);
        this.getColumn(this.getColumnName(0)).setMaxWidth(40);
    }

    @Override
    public boolean getRowSelectionAllowed() {
        return true;
    }

    private static class MyCellRenderer
    implements TableCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return new JLabel("");
            }
            switch (column) {
                case 0: {
                    return new JLabel(String.valueOf(value));
                }
                case 1: {
                    return new JLabel("<html><font color=blue>" + value.toString());
                }
                case 2: {
                    NumberFormat df = NumberFormat.getNumberInstance(Locale.US);
                    if (df != null) {
                        if (Double.valueOf(value.toString()) == 0.0) {
                            return new JLabel("0");
                        }
                        ((DecimalFormat)df).applyPattern("0.0000E0");
                        String str = ((DecimalFormat)df).format(Double.valueOf(value.toString()));
                        return new JLabel(str);
                    }
                    return new JLabel(value.toString());
                }
            }
            return null;
        }
    }
}

