/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.bisection;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import uibk.applets.bisection.AppletBisection;
import uibk.applets.bisection.Messages;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.swing.base.TitledPanel;

public class PanelBisection
extends TitledPanel
implements ActionListener {
    AppletBisection main;
    JCheckBox optAutoResize;
    JButton buttonNext;
    JTextField textEps;

    public PanelBisection(AppletBisection main) {
        super(Messages.getString("Bisectionmethod"));
        this.main = main;
        this.initComponents();
    }

    private void next() {
        double eps = 0.0;
        try {
            eps = Misc.parseEps(this.textEps.getText(), 1.0E-12);
        }
        catch (Exception ex) {
            this.main.mathpanel2d.reportError(ex);
            return;
        }
        this.main.bisecvisual.setEps(eps);
        this.main.bisecvisual.setAutoResize(this.optAutoResize.isSelected());
        if (!this.main.bisecvisual.hasNext()) {
            return;
        }
        try {
            this.main.bisecvisual.next();
        }
        catch (Exception ex) {
            this.main.mathpanel2d.reportError(ex);
            this.main.bisecvisual.reset();
            return;
        }
        if (this.main.bisecvisual.getState() == 2) {
            this.main.table.add(this.main.bisecvisual.getLast());
            this.main.table.scrollToLastLine();
            this.main.table.revalidate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("next")) {
            this.next();
        }
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 150));
        this.textEps = new JTextField(8);
        this.textEps.setActionCommand("eps");
        this.textEps.addActionListener(this);
        this.textEps.setToolTipText(Messages.getString("ToleranceMustBeEntered"));
        this.buttonNext = new JButton(Messages.getString("Bisection"));
        this.buttonNext.setActionCommand("next");
        this.buttonNext.addActionListener(this);
        this.buttonNext.setToolTipText(Messages.getString("ApplyNextStepInB"));
        this.optAutoResize = new JCheckBox(Messages.getString("AdjustCoordinateSystem"));
        this.optAutoResize.setSelected(true);
        this.add((Component)new JLabel(Messages.getString("Tolerance")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.textEps, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.optAutoResize, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 10, 0), 0, 0));
        this.add((Component)this.buttonNext, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

