/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.bisection;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.applets.bisection.Messages;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.FunctionValue2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.util.GraphUtil;
import uibk.mtk.math.BisectionMethod;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.Function1D;

public class BisectionVisualisation
extends Drawable2D {
    protected Function1D function;
    protected BisectionMethod bisection = new BisectionMethod();
    protected Graph2D graph = new Graph2D();
    private int count;
    Interval startinterval;
    Vector oldlimits = new Vector();
    private static final int NUMBERPOINTS_GRAPH = 500;
    private static final BasicStroke DASHEDSTROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f}, 0.0f);
    boolean autoresize = true;
    DragableIntervalLimit lower = new DragableIntervalLimit();
    DragableIntervalLimit upper = new DragableIntervalLimit();
    DragableIntervalLimit approx = new DragableIntervalLimit();
    private int state = 1;
    static final int STATE_LIMITS = 1;
    static final int STATE_NEW_VALUE = 2;
    protected Vector lines = new Vector();
    double[] lastapprox = new double[2];

    public void setStartInterval(Interval interval) {
        this.startinterval = interval;
    }

    private void nextState() {
        if (this.state == 2) {
            this.state = 1;
            return;
        }
        if (this.state == 1) {
            this.state = 2;
        }
    }

    public double[] getLast() {
        return (double[])this.lastapprox.clone();
    }

    public BisectionVisualisation() {
        this.lower.setColor(Color.blue);
        this.upper.setColor(Color.blue);
        this.approx.setColor(Color.green);
        this.approx.setStroke(DASHEDSTROKE);
        this.lower.setStroke(DASHEDSTROKE);
        this.upper.setStroke(DASHEDSTROKE);
    }

    public void setFunction(Function1D function) {
        this.function = function;
        this.lower.setFunction(function);
        this.upper.setFunction(function);
        this.approx.setFunction(function);
        this.bisection.setFunction(function);
    }

    public void setAutoResize(boolean autoresize) {
        this.autoresize = autoresize;
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (!this.visible) {
            return;
        }
        this.graph.draw(framebuffer, g2);
        int i = 0;
        while (i < this.oldlimits.size()) {
            IntervalLimit limit = (IntervalLimit)this.oldlimits.elementAt(i);
            limit.setColor(new Color(0, 0, 255, 80));
            limit.draw(framebuffer, g2);
            ++i;
        }
    }

    public void initialize() throws Exception {
        double a = this.startinterval.a;
        double b = this.startinterval.b;
        this.graph.setPoints(GraphUtil.compute(this.function, a, b, 500));
        this.scene2d.setLimits(this.graph.getLimits());
        this.scene2d.ensureZeroY(true);
        this.panel.add(this.lower);
        this.panel.add(this.upper);
        this.panel.add(this.approx);
        this.lower.setPos(a);
        this.upper.setPos(b);
        this.approx.setVisible(false);
        this.approx.enabledrag(false);
        this.panel.report(String.valueOf(Messages.getString("StartInterval[")) + a + "," + b + "]");
    }

    @Override
    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
        this.graph.setMathPanel2D(panel);
    }

    public boolean hasNext() {
        return this.count <= 0 || !(this.bisection.getError() < this.bisection.getEps());
    }

    public void next() throws Exception {
        this.lower.enabledrag(false);
        this.upper.enabledrag(false);
        if (this.count > 0 && this.bisection.getError() < this.bisection.getEps()) {
            return;
        }
        if (this.state == 1) {
            double a = this.lower.getPos() < this.upper.getPos() ? this.lower.getPos() : this.upper.getPos();
            double b = this.lower.getPos() < this.upper.getPos() ? this.upper.getPos() : this.lower.getPos();
            this.bisection.setInterval(new Interval(a, b));
            double newapprox = 0.0;
            newapprox = this.bisection.nextApproximation();
            this.approx.setPos(newapprox);
            this.approx.setVisible(true);
            this.lastapprox[0] = newapprox;
            this.lastapprox[1] = this.bisection.getError();
            this.panel.report(String.valueOf(Messages.getString("currentApproximation")) + newapprox + Messages.getString("withError") + this.bisection.getError());
            if (this.bisection.getError() < this.bisection.getEps()) {
                this.panel.reportSuccess(Messages.getString("PrecisionAchieved"));
                ++this.count;
            }
        } else {
            IntervalLimit limit;
            Interval interval = this.bisection.getInterval();
            if (this.lower.getPos() == interval.a || this.lower.getPos() == interval.b) {
                limit = new IntervalLimit();
                limit.setFunction(this.function);
                limit.setPos(this.upper.getPos());
                limit.setStroke(DASHEDSTROKE);
                limit.setMathPanel2D(this.panel);
                this.oldlimits.add(limit);
            } else {
                limit = new IntervalLimit();
                limit.setFunction(this.function);
                limit.setPos(this.lower.getPos());
                limit.setStroke(DASHEDSTROKE);
                limit.setMathPanel2D(this.panel);
                this.oldlimits.add(limit);
            }
            this.lower.setPos(interval.a);
            this.upper.setPos(interval.b);
            this.approx.setVisible(false);
            if (this.autoresize && this.scene2d.xToPixel(Math.abs(interval.a - interval.b)) - this.scene2d.xToPixel(0.0) < 40) {
                this.scene2d.enableRoundY(false);
                this.scene2d.setXInterval(interval);
                this.scene2d.enableRoundY(true);
                int i = 0;
                while (i < this.oldlimits.size()) {
                    double pos = ((IntervalLimit)this.oldlimits.elementAt(i)).getPos();
                    if (pos < this.scene2d.getXmin() || pos > this.scene2d.getXmax()) {
                        this.oldlimits.remove(i);
                    }
                    ++i;
                }
                this.graph.setPoints(GraphUtil.compute(this.function, this.scene2d.getXmin(), this.scene2d.getXmax(), 500));
                Interval intervalY = new Interval(this.graph.getLimits().ymin, this.graph.getLimits().ymax);
                this.scene2d.setYInterval(intervalY);
            }
        }
        this.panel.repaint();
        this.nextState();
    }

    public int getState() {
        return this.state;
    }

    public void setEps(double eps) {
        this.bisection.setEps(eps);
    }

    public void reset() {
        this.count = 0;
        this.state = 1;
        this.oldlimits.clear();
        this.lower.enabledrag(true);
        this.upper.enabledrag(true);
    }

    class DragableIntervalLimit
    extends FunctionValue2D {
        @Override
        public void drag(MouseEvent ev) {
            super.drag(ev);
            this.line.setPoints(this.pointAxis, this.pointGraph);
            BisectionVisualisation.this.state = 1;
            double a = BisectionVisualisation.this.lower.getPos() < BisectionVisualisation.this.upper.getPos() ? BisectionVisualisation.this.lower.getPos() : BisectionVisualisation.this.upper.getPos();
            double b = BisectionVisualisation.this.lower.getPos() < BisectionVisualisation.this.upper.getPos() ? BisectionVisualisation.this.upper.getPos() : BisectionVisualisation.this.lower.getPos();
            this.panel.report(String.valueOf(Messages.getString("StartInterval[")) + a + "," + b + "]");
        }

        @Override
        public void draw(BufferedImage framebuffer, Graphics2D g2) {
            super.draw(framebuffer, g2);
            String caption = this.pointGraph.getY() < 0.0 ? "-" : "+";
            FontMetrics metrics = g2.getFontMetrics();
            Font oldfont = g2.getFont();
            int lengthStr = metrics.stringWidth(caption);
            int heightStr = metrics.getHeight();
            int offVertical = this.pointGraph.getY() < 0.0 ? heightStr / 2 + 5 : -5;
            int offHorizontal = -lengthStr / 2;
            g2.setFont(new Font("Arial", 1, 14));
            g2.drawString(caption, this.scene2d.xToPixel(this.pointGraph.getX()) + offHorizontal, this.scene2d.yToPixel(this.pointGraph.getY()) + offVertical);
            g2.setFont(oldfont);
        }
    }

    class IntervalLimit
    extends DragableIntervalLimit {
        public IntervalLimit() {
            this.enabledrag(false);
        }
    }
}

