/*
|| Die Funktion displayElement() macht ein verstecktes HTML-Element sichtbar.
|| Das HTML-Element ist in aller Regel ein mit <div> ... </div> umspannter
|| HTML-Abschnitt.
||
|| IN-Parameter: element_id ... ID des sichtbarzumachenden HTML-Elements
||
*/

function displayElement( element_id ) {
	if ( notNN4( ) )
	{
		var elementToDisplay = document.getElementById( element_id );
		elementToDisplay.className = 'show';
	}
}



/*
|| Die Funktion hideElement() macht ein HTML-Element unsichtbar.
|| Das HTML-Element ist in aller Regel ein mit <div> ... </div> umspannter
|| HTML-Abschnitt.
||
|| IN-Parameter: element_id ... ID des zu versteckenden HTML-Elements
||
*/

function hideElement( element_id ) {
	if ( notNN4( ) )
	{
		var elementToHide = document.getElementById( element_id );
		elementToHide.className = 'hide';
	}
}



/*
|| Die Funktion resetValue() setzt Radiobuttons, Dropdown-Menues und Checkboxes auf ihre
|| Ausgangswerte (beim Laden des Formulars) zurueck.
||
|| IN-Parameter: element ... Radiobutton-, Dropdown- oder Checkbox-Element
||
*/

function resetValue( element ) {
	for ( var i = 0; i < element.length; i++ )
	{
		element[i].checked = element[i].defaultChecked;
		element[i].selected = element[i].defaultSelected;
	}
}



/*
|| Die Funktion toggleDisplay() invertiert die Sichtbarkeit eines
|| HTML-Elements.
|| Das HTML-Element ist in aller Regel ein mit <div> ... </div> umspannter
|| HTML-Abschnitt.
||
|| IN-Parameter: element_id ... ID des zu invertierenden HTML-Elements
||
*/

function toggleDisplay( element_id ) {
	if ( notNN4( ) )
	{
		var elementToToggle = document.getElementById( element_id );
		var elementClass = elementToToggle.className;
		if ( elementClass == 'hide' )
			elementToToggle.className = "display";
		else
			elementToToggle.className = "hide";
	}
}

/*
|| Die Funktion toggleActive() setzt das Attribut 'readonly' eines
|| HTML-Eingabeelements.
||
|| IN-Parameter: element ... HTML-Eingabeelement
|| IN-Parameter: status ... entweder 'active' oder 'deactive'
||
*/

function toggleActive( element, status ) {

	if ( notNN4( ) )
	{
 		var elementToToggle = document.getElementById( element.id );

 		if ( status == 'active' )
 		{
 			element.readOnly = false;
 			elementToToggle.className = "active";
 		}
 		else
 		{
 			element.readOnly = true;
 			elementToToggle.className = "deactive";
 		}
	}
}



/*
|| Die Funktion changeActivity() setzt das Attribut 'readonly' eines
|| HTML-Eingabeelements in Abhaengigkeit des Uebergabeparameters 'value'.
||
|| IN-Parameter: value ... Wert eines HTML-Eingabelements
|| IN-Parameter: element ... HTML-Eingabeelement
||
*/

function changeActivity( value, element ) {
	if ( value == null || value == '' )
		toggleActive( element, 'active' );
	else
		toggleActive( element, 'deactive' );
}



/*
|| Die Funktion pasteValueAndDeactivate() setzt den Wert eines HTML-Eingabeelements
|| und setzt das Attribut 'readonly', je nachdem ob der uebergebene Wert ungleich
|| dem Leerstring ist oder nicht.
||
|| IN-Parameter: value ... zu setzender Wert
|| IN-Parameter: element ... HTML-Eingabeelement
||
*/

function pasteValueAndDeactivate( value, element ) {
	if ( notNN4( ) )
	{
		var elementToSet = document.getElementById( element.id );
		elementToSet.value = value;
		if ( value != null && value != '' )
		{
			element.readOnly = true;
			elementToSet.className = "deactive";
		}
		else
		{
			element.readOnly = false;
			elementToSet.className = "active";
		}
	}
}



/*
|| Die Funktion popitup() oeffnet im Browser links oben ein Fenster
|| mit bestimmten Eigenschaften (keine Statuszeile, kein Browsermenue, etc.).
|| URL und Groesse des Fensters werden als Parameter uebergeben.
||
|| IN-Parameter: url ... in dem Fenster zu oeffnende URL
|| IN-Parameter: win_width ... Breite des zu oeffnenden Fensters
|| IN-Parameter: win_height ... Hoehe des zu oeffnenden Fensters
||
*/

function popitup( url, win_width, win_height ) {
	var features = "resizable, scrollbars=yes,status=no, menubar=no, toolbar=no, screenX=20, screenY=20, width=" + win_width + ", height=" + win_height;
	newwindow=window.open( url, 'Info', features );
	/* die folgende Anweisung verursacht im IE eine Zugriffsverletzung, daher auskommentiert! */
	// newwindow.moveTo( 20, 20);
	if ( window.focus )
		newwindow.focus( );
}



/*
|| Die Funktion initialize() deaktiviert das StyleSheet styles_opera.css (ausser fuer Opera).
|| Ausserdem werden in Browsern, die JavaScript aktiviert haben, die Icon-Info-Links durch href-Werte ersetzt,
|| die kein neues Browser-Fenster, sondern ein kleines Fenster oeffnen (s. Funktion javascriptWindows).
|| Der Parameter url hat entweder den Wert http://www.help.gv.at/formulare/infotexte/ oder
|| http://e-www.help.gv.at/linkdb/formulare/infotexte/, je nachdem in welcher Umgebung man sich befindet
*/

function initialize( url ) {
	if ( notNN4( ) ) {
            if (document.getElementsByTagName) {
                  if ( document.getElementsByTagName('link').length > 1 )
			{
				document.getElementsByTagName('link')[1].disabled = true;
				javascriptWindows( url );
			}
		  schattieren( );
		}
      }
}


/*
|| Die Funktion javascriptWindows() ersetzt in den Formularen bei aktiviertem JavaScript
|| die Links bei den Infobuttons durch window.open-Befehle, so dass diese Infotexte in
|| einem kleinen Fenster im Browser links oben geoeffnet werden.
|| Der Parameter url hat entweder den Wert http://www.help.gv.at/formulare/infotexte/ oder
|| http://e-www.help.gv.at/linkdb/formulare/infotexte/, je nachdem in welcher Umgebung man sich befindet.
*/

function javascriptWindows( url ) {
	var aElement,
	    href,
	    newHref,
	    lastIndex;
	if ( notNN4( ) )
	{
		for ( var i = 0; i < document.getElementsByTagName( 'a' ).length; i++ )
		{
			aElement = document.getElementsByTagName( 'a' )[i];
			href = aElement.href;
			if ( href.indexOf( 'info_' ) != -1 )
			{
				lastIndex = href.lastIndexOf( '/' );
				newHref = href.substring( lastIndex + 1 );
				newHref = "javascript:popitup('" + url + newHref + "',660,500);";
				aElement.setAttribute( 'href', newHref );
				aElement.setAttribute( 'target', '_self' );
			}
		}
	}
}

/*
|| Die Funktion submitButton() erzeugt einen Submit-Button, der ein automatisches
|| Abschicken verhindert, wenn der User in einem Eingabefeld die Return-Taste
|| betaetigt.
|| Wurde durch die Funktion generateButton() abgeloest.
*/

function submitButton( ) {
  document.writeln('<input type="button" name="JavaScriptButton" value="Senden" class="button" ' +
                   'onclick="document.formular.Senden.value=\'Senden\'; document.formular.submit()" ' +
                   'onkeypress="document.formular.Senden.value=\'Senden\'; document.formular.submit()" />');
}

/*
|| Die Funktion cancelButton() erzeugt einen Abbrechen-Button, der ein automatisches
|| Abschicken verhindert, wenn der User in einem Eingabefeld die Return-Taste
|| betaetigt.
|| Wurde durch die Funktion generateButton() abgeloest.
*/

function cancelButton( ) {
  document.writeln('<input type="button" name="JavaScriptButton" value="Abbrechen" class="button" ' +
                   'onclick="document.formular.Senden.value=\'Abbrechen\'; document.formular.submit()" ' +
                   'onkeypress="document.formular.Senden.value=\'Abbrechen\'; document.formular.submit()" />');
}

/*
|| Die Funktion generateButton() erzeugt einen Button, der ein automatisches
|| Abschicken verhindert, wenn der User in einem Eingabefeld die Return-Taste
|| betaetigt. Die Art des Buttons wird durch den uebergebenen Wert bestimmt.
|| Moegliche Werte: Senden, Abbrechen, Signieren, etc.
*/

function generateButton( kind ) {

  document.write('<input type="button" name="JavaScriptButton" value="' + kind + '" class="button" ' +
                   'onclick="' );
  if ( kind == 'Druckversion' )
    document.write( 'document.formular.target=\'_blank\' ;' );
  else
    document.write( 'document.formular.target=\'_self\' ; ' );
  document.write( 'document.formular.Senden.value=\'' + kind + '\'; document.formular.submit()" ' +
                   'onkeypress="' );
  if ( kind == 'Druckversion' )
    document.write( 'document.formular.target=\'_blank\'; ' );
  else
    document.write( 'document.formular.target=\'_self\';' );
  document.writeln( 'document.formular.Senden.value=\'' + kind + '\'; document.formular.submit()" />');

}

/*
|| Die Funktion NN4 testet, ob es sich bei dem Browser um einen Netscape
|| Navigator der Version 4 handelt.
*/

function notNN4( ) {
	return ( ! document.layers );
}

/*
|| Die Funktion schattieren setzt in den Beilagen-Tabellen abwechselnd Farben
|| Quelle: Andreas Borutta, http://borumat.de/html/tab-schattieren.php
*/


function schattieren () {
var tabelle=document.getElementsByTagName("table");
  for(i=0; i<=tabelle.length-1; i++) {
    var klasse=tabelle[i].className;
    var pos1=klasse.indexOf("attachmenttable");
    if (pos1 > -1) {
      pos1=klasse.indexOf("ab_");
      if (pos1 > -1 ) var von=parseInt(klasse.substr(pos1+3,2));
      else var von=3;
      var pos2=klasse.indexOf("fuss_");
      if (pos2 > -1 ) var fuss=parseInt(klasse.substr(pos2+5,2));
      else var fuss=0;
      var reihe=tabelle[i].getElementsByTagName("tr");
      for (j=von -1; j<=reihe.length -fuss -1; j=j+2)
        reihe[j].className="s";
    } //endIf
  } //endFor
} //endFunc
