/*
 * Decompiled with CFR 0.152.
 */
package uibk.geom;

import java.awt.Point;
import uibk.geom.Vector2D;

public class Punkt2D {
    public double x;
    public double y;

    public Punkt2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Punkt2D() {
    }

    public Punkt2D(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public Punkt2D(Punkt2D punkt2D) {
        this.x = punkt2D.x;
        this.y = punkt2D.y;
    }

    public static Punkt2D add(Punkt2D punkt2D, Punkt2D punkt2D2) {
        return new Punkt2D(punkt2D.x + punkt2D2.x, punkt2D.y + punkt2D2.y);
    }

    public static Punkt2D sub(Punkt2D punkt2D, Punkt2D punkt2D2) {
        return new Punkt2D(punkt2D.x - punkt2D2.x, punkt2D.y - punkt2D2.y);
    }

    public void add(Punkt2D punkt2D) {
        this.x += punkt2D.x;
        this.y += punkt2D.y;
    }

    public void sub(Punkt2D punkt2D) {
        this.x -= punkt2D.x;
        this.y -= punkt2D.y;
    }

    public static Punkt2D inverse(Punkt2D punkt2D) {
        return new Punkt2D(-punkt2D.x, -punkt2D.y);
    }

    public void setLocation(Punkt2D punkt2D) {
        this.x = punkt2D.x;
        this.y = punkt2D.y;
    }

    public void scale(double d) {
        this.x *= d;
        this.y *= d;
    }

    public static Punkt2D scale(Punkt2D punkt2D, double d) {
        Punkt2D punkt2D2 = new Punkt2D();
        punkt2D2.x = punkt2D.x * d;
        punkt2D2.y = punkt2D.y * d;
        return punkt2D2;
    }

    static double dotProd(Punkt2D punkt2D, Punkt2D punkt2D2) {
        return punkt2D.x * punkt2D2.x + punkt2D.y * punkt2D2.y;
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double quadnorm() {
        return this.x * this.x + this.y * this.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public void normalize() {
        double d = this.norm();
        this.x /= d;
        this.y /= d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Punkt2D)) {
            return false;
        }
        Punkt2D punkt2D = (Punkt2D)object;
        return this.x == punkt2D.x && this.y == punkt2D.y;
    }

    public boolean isReal() {
        return !Double.isInfinite(this.x) && !Double.isInfinite(this.y) && !Double.isNaN(this.x) && !Double.isNaN(this.y);
    }

    public Vector2D toVector() {
        return new Vector2D(this.x, this.y);
    }
}

