/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.objects;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import uibk.draw2d.base.Drawable2D;
import uibk.geom.Punkt2D;
import uibk.lang.PrepaintComputable;

public class MathArrow2D
extends Drawable2D
implements PrepaintComputable {
    Punkt2D base = new Punkt2D();
    Punkt2D head = new Punkt2D();
    protected Point basepix = new Point();
    protected Point headpix = new Point();
    protected Point leftwingpix = new Point();
    protected Point rightwingpix = new Point();
    int lengtharrowhead = 6;
    int offsetwings = 3;

    public MathArrow2D(Punkt2D punkt2D, Punkt2D punkt2D2) {
        this.base.setLocation(punkt2D);
        this.head.setLocation(punkt2D2);
    }

    public MathArrow2D() {
        this.draw = true;
    }

    public void setArrowheadLength(int n) {
        this.lengtharrowhead = n;
    }

    public Punkt2D getHead() {
        return this.head;
    }

    public Punkt2D getBase() {
        return this.base;
    }

    static double norm(Point point) {
        return Math.sqrt(point.x * point.x + point.y * point.y);
    }

    public void setBase(Punkt2D punkt2D) {
        this.base.setLocation(punkt2D);
    }

    public void setHead(Punkt2D punkt2D) {
        this.head.setLocation(punkt2D);
    }

    public void draw(BufferedImage bufferedImage, Graphics2D graphics2D) {
        if (!this.draw) {
            return;
        }
        graphics2D.setColor(this.color);
        graphics2D.drawLine(this.basepix.x, this.basepix.y, this.headpix.x, this.headpix.y);
        graphics2D.drawLine(this.rightwingpix.x, this.rightwingpix.y, this.headpix.x, this.headpix.y);
        graphics2D.drawLine(this.leftwingpix.x, this.leftwingpix.y, this.headpix.x, this.headpix.y);
    }

    public void prepaintcompute() throws Exception {
        this.draw = false;
        this.basepix = this.scene2d.project(this.base);
        this.headpix = this.scene2d.project(this.head);
        Punkt2D punkt2D = Punkt2D.sub(this.head, this.base);
        punkt2D.normalize();
        if (Double.isNaN(punkt2D.x) || Double.isInfinite(punkt2D.x) || Double.isNaN(punkt2D.y) || Double.isInfinite(punkt2D.y) || punkt2D.x == 0.0 && punkt2D.y == 0.0) {
            this.draw = false;
            return;
        }
        double d = Math.max(this.scene2d.getXRange(), this.scene2d.getYRange()) / 10.0;
        punkt2D.scale(d);
        Punkt2D punkt2D2 = this.scene2d.projectdouble(new Punkt2D(0.0, 0.0));
        Punkt2D punkt2D3 = Punkt2D.sub(this.scene2d.projectdouble(punkt2D), punkt2D2);
        punkt2D3.normalize();
        if (Double.isNaN(punkt2D3.x) || Double.isInfinite(punkt2D3.x) || Double.isNaN(punkt2D3.y) || Double.isInfinite(punkt2D3.y) || punkt2D3.x == 0.0 && punkt2D3.y == 0.0) {
            this.draw = false;
            return;
        }
        Punkt2D punkt2D4 = new Punkt2D(-punkt2D3.y, punkt2D3.x);
        this.leftwingpix.x = (int)((double)this.headpix.x - (double)this.lengtharrowhead * punkt2D3.x + (double)this.offsetwings * punkt2D4.x);
        this.leftwingpix.y = (int)((double)this.headpix.y - (double)this.lengtharrowhead * punkt2D3.y + (double)this.offsetwings * punkt2D4.y);
        this.rightwingpix.x = (int)((double)this.headpix.x - (double)this.lengtharrowhead * punkt2D3.x - (double)this.offsetwings * punkt2D4.x);
        this.rightwingpix.y = (int)((double)this.headpix.y - (double)this.lengtharrowhead * punkt2D3.y - (double)this.offsetwings * punkt2D4.y);
        this.draw = true;
    }
}

