/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.objects;

import java.awt.Point;
import java.awt.Rectangle;
import uibk.geom.CoordinateRect2D;
import uibk.geom.Punkt2D;

public final class LineClipping2D {
    private static final byte EMPTY = 0;
    private static final byte LEFT = 1;
    private static final byte RIGHT = 2;
    private static final byte BOTTOM = 4;
    private static final byte TOP = 8;

    private LineClipping2D() {
    }

    private static byte regioncode(long l, long l2, Rectangle rectangle) {
        byte by = 0;
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        if (l < (long)n) {
            by = 1;
        }
        if (l > (long)n2) {
            by = 2;
        }
        if (l2 > (long)n4) {
            by = (byte)(by | 8);
        }
        if (l2 < (long)n3) {
            by = (byte)(by | 4);
        }
        return by;
    }

    private static byte regioncode(Punkt2D punkt2D, CoordinateRect2D coordinateRect2D) {
        byte by = 0;
        if (punkt2D.x < coordinateRect2D.xmin) {
            by = 1;
        }
        if (punkt2D.x > coordinateRect2D.xmax) {
            by = 2;
        }
        if (punkt2D.y > coordinateRect2D.ymax) {
            by = (byte)(by | 8);
        }
        if (punkt2D.y < coordinateRect2D.ymin) {
            by = (byte)(by | 4);
        }
        return by;
    }

    public static boolean cohen_sutherland(Point point, Point point2, Point point3, Point point4, Rectangle rectangle) {
        int n = 0;
        if (Double.isInfinite(point.x) || Double.isNaN(point.y) || Double.isInfinite(point2.x) || Double.isNaN(point2.y)) {
            return false;
        }
        int n2 = rectangle.x;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y;
        int n5 = rectangle.y + rectangle.height;
        long l = point.x;
        long l2 = point.y;
        long l3 = point2.x;
        long l4 = point2.y;
        byte by = LineClipping2D.regioncode(l, l2, rectangle);
        byte by2 = LineClipping2D.regioncode(l3, l4, rectangle);
        boolean bl = l != l3;
        long l5 = 0L;
        long l6 = 0L;
        double d = 0.0;
        if (bl) {
            d = (double)(l4 - l2) / (double)(l3 - l);
        }
        while (by != 0 || by2 != 0) {
            byte by3;
            if ((by & by2) != 0) {
                return false;
            }
            byte by4 = by3 = by == 0 ? by2 : by;
            if ((by3 & 1) != 0) {
                l5 = n2;
                l6 = (long)((double)l2 + (double)(l5 - l) * d);
            }
            if ((by3 & 2) != 0) {
                l5 = n3;
                l6 = (long)((double)l2 + (double)(l5 - l) * d);
            }
            if ((by3 & 4) != 0) {
                l6 = n4;
                l5 = bl ? (long)((double)l + (double)(l6 - l2) / d) : l;
            }
            if ((by3 & 8) != 0) {
                l6 = n5;
                l5 = bl ? (long)((double)l + (double)(l6 - l2) / d) : l;
            }
            if (by3 == by) {
                l = l5;
                l2 = l6;
                by = LineClipping2D.regioncode(l, l2, rectangle);
            } else {
                l3 = l5;
                l4 = l6;
                by2 = LineClipping2D.regioncode(l3, l4, rectangle);
            }
            if (++n <= 100) continue;
            System.out.println("S");
            System.out.println(point);
            System.out.println(point2);
        }
        point3.x = (int)l;
        point3.y = (int)l2;
        point4.x = (int)l3;
        point4.y = (int)l4;
        return true;
    }

    public static boolean cohen_sutherland_double(Punkt2D punkt2D, Punkt2D punkt2D2, Punkt2D punkt2D3, Punkt2D punkt2D4, CoordinateRect2D coordinateRect2D) {
        if (Double.isInfinite(punkt2D3.x) || Double.isNaN(punkt2D3.y) || Double.isInfinite(punkt2D4.x) || Double.isNaN(punkt2D4.x)) {
            return false;
        }
        double d = coordinateRect2D.xmin;
        double d2 = coordinateRect2D.xmax;
        double d3 = coordinateRect2D.ymin;
        double d4 = coordinateRect2D.ymax;
        punkt2D3.x = punkt2D.x;
        punkt2D3.y = punkt2D.y;
        punkt2D4.x = punkt2D2.x;
        punkt2D4.y = punkt2D2.y;
        byte by = LineClipping2D.regioncode(punkt2D3, coordinateRect2D);
        byte by2 = LineClipping2D.regioncode(punkt2D4, coordinateRect2D);
        boolean bl = punkt2D3.x != punkt2D4.x;
        Punkt2D punkt2D5 = new Punkt2D();
        double d5 = 0.0;
        if (bl) {
            d5 = (punkt2D4.y - punkt2D3.y) / (punkt2D4.x - punkt2D3.x);
        }
        while (by != 0 || by2 != 0) {
            byte by3;
            if ((by & by2) != 0) {
                return false;
            }
            byte by4 = by3 = by == 0 ? by2 : by;
            if ((by3 & 1) != 0) {
                punkt2D5.x = d;
                punkt2D5.y = punkt2D3.y + (punkt2D5.x - punkt2D3.x) * d5;
            }
            if ((by3 & 2) != 0) {
                punkt2D5.x = d2;
                punkt2D5.y = punkt2D3.y + (punkt2D5.x - punkt2D3.x) * d5;
            }
            if ((by3 & 4) != 0) {
                punkt2D5.y = d3;
                punkt2D5.x = bl ? punkt2D3.x + (punkt2D5.y - punkt2D3.y) / d5 : punkt2D3.x;
            }
            if ((by3 & 8) != 0) {
                punkt2D5.y = d4;
                punkt2D5.x = bl ? punkt2D3.x + (punkt2D5.y - punkt2D3.y) / d5 : punkt2D3.x;
            }
            if (by3 == by) {
                punkt2D3.x = punkt2D5.x;
                punkt2D3.y = punkt2D5.y;
                by = LineClipping2D.regioncode(punkt2D3, coordinateRect2D);
                continue;
            }
            punkt2D4.x = punkt2D5.x;
            punkt2D4.y = punkt2D5.y;
            by2 = LineClipping2D.regioncode(punkt2D4, coordinateRect2D);
        }
        return true;
    }
}

