/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.draw2d.base.Drawable2D;
import uibk.geom.CoordinateRect2D;
import uibk.geom.Punkt2D;

public class Graph2D
extends Drawable2D {
    protected Stroke stroke;
    protected Vector points = new Vector();
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    Color colorpoints = Color.red;
    int radius = 2;
    int count;
    private static int X_COMPONENT = 0;
    private static int Y_COMPONENT = 1;

    public Graph2D() {
        this.color = Color.red;
        this.stroke = new BasicStroke();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setPoints(Vector vector) {
        this.points = vector;
        this.recalcLimits();
    }

    public void addPoint(Punkt2D punkt2D) {
        this.points.add(punkt2D);
    }

    public void recalcLimits() {
        this.xmin = Graph2D.min(this.points, X_COMPONENT);
        this.xmax = Graph2D.max(this.points, X_COMPONENT);
        this.ymin = Graph2D.min(this.points, Y_COMPONENT);
        this.ymax = Graph2D.max(this.points, Y_COMPONENT);
    }

    public void clearpoints() {
        this.points.clear();
        this.xmin = -1.0;
        this.xmax = 1.0;
        this.ymin = -1.0;
        this.ymax = 1.0;
    }

    public Vector getPoints() {
        return this.points;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public CoordinateRect2D getLimits() {
        if (this.xmin != this.xmax || this.ymin != this.ymax) {
            return new CoordinateRect2D(this.xmin, this.xmax, this.ymin, this.ymax);
        }
        return new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    }

    private static double max(Vector vector, int n) {
        int n2;
        double d = 0.0;
        if (n == X_COMPONENT) {
            d = ((Punkt2D)vector.elementAt((int)0)).x;
            n2 = 1;
            while (n2 < vector.size()) {
                if (((Punkt2D)vector.elementAt((int)n2)).x > d) {
                    d = ((Punkt2D)vector.elementAt((int)n2)).x;
                }
                ++n2;
            }
        }
        if (n == Y_COMPONENT) {
            d = ((Punkt2D)vector.elementAt((int)0)).y;
            n2 = 1;
            while (n2 < vector.size()) {
                if (((Punkt2D)vector.elementAt((int)n2)).y > d) {
                    d = ((Punkt2D)vector.elementAt((int)n2)).y;
                }
                ++n2;
            }
        }
        return d;
    }

    private static double min(Vector vector, int n) {
        int n2;
        double d = 0.0;
        if (n == X_COMPONENT) {
            d = ((Punkt2D)vector.elementAt((int)0)).x;
            n2 = 1;
            while (n2 < vector.size()) {
                if (((Punkt2D)vector.elementAt((int)n2)).x < d) {
                    d = ((Punkt2D)vector.elementAt((int)n2)).x;
                }
                ++n2;
            }
        }
        if (n == Y_COMPONENT) {
            d = ((Punkt2D)vector.elementAt((int)0)).y;
            n2 = 1;
            while (n2 < vector.size()) {
                if (((Punkt2D)vector.elementAt((int)n2)).y < d) {
                    d = ((Punkt2D)vector.elementAt((int)n2)).y;
                }
                ++n2;
            }
        }
        return d;
    }

    public void draw(BufferedImage bufferedImage, Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(this.color);
        Point point = new Point();
        Point point2 = new Point();
        int n = 0;
        while (n < this.points.size() - 1) {
            Punkt2D punkt2D = (Punkt2D)this.points.elementAt(n);
            Punkt2D punkt2D2 = (Punkt2D)this.points.elementAt(n + 1);
            int n2 = this.scene2d.xToPixel(punkt2D.x);
            int n3 = this.scene2d.yToPixel(punkt2D.y);
            int n4 = this.scene2d.xToPixel(punkt2D2.x);
            int n5 = this.scene2d.yToPixel(punkt2D2.y);
            graphics2D.setColor(this.color);
            graphics2D.drawLine(n2, n3, n4, n5);
            ++n;
        }
        graphics2D.setStroke(stroke);
    }
}

