/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.base;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import uibk.draw2d.base.MathPanel2D;
import uibk.geom.CoordinateRect2D;
import uibk.geom.Punkt2D;
import uibk.math.Interval;
import uibk.math.Rounder;

public class Scene2D {
    public static final int ROUND_X = 0;
    public static final int ROUND_XY = 1;
    public static final int ROUND_Y = 2;
    public static final int AREA_UPPERLEFT = 0;
    public static final int AREA_UPPERRIGHT = 1;
    public static final int AREA_UPPER = 2;
    public static final int AREA_LOWERLEFT = 3;
    public static final int AREA_LOWERRIGHT = 4;
    public static final int AREA_LOWER = 5;
    public static final int AREA_RIGHT = 6;
    public static final int AREA_LEFT = 7;
    public static final int AREA_ALL = 8;
    protected boolean changed = true;
    private int edge = 15;
    private Insets insets = new Insets(0, 0, 0, 0);
    private MathPanel2D mathpanel2d;
    private Insets requestedInsets = new Insets(0, 0, 0, 0);
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;

    public Scene2D() {
        this(-1.0, 1.0, -1.0, 1.0);
    }

    public Rectangle getCoordinatePixelRectangle() {
        Rectangle rectangle = new Rectangle();
        rectangle.x = this.xToPixel(this.xmin);
        rectangle.y = this.yToPixel(this.ymax);
        rectangle.width = this.xToPixel(this.xmax) - this.xToPixel(this.xmin);
        rectangle.height = this.yToPixel(this.ymin) - this.yToPixel(this.ymax);
        return rectangle;
    }

    public Scene2D(double d, double d2, double d3, double d4) {
        this.setLimits(d, d2, d3, d4);
    }

    boolean isScaleTooSmall() {
        return this.pixelToX(0) - this.pixelToX(1) == 0.0 || this.pixelToY(0) - this.pixelToY(1) == 0.0;
    }

    public void setXInterval(Interval interval) {
        this.setLimits(interval.a, interval.b, this.ymin, this.ymax);
    }

    public void setYInterval(Interval interval) {
        this.setLimits(this.xmin, this.xmax, interval.a, interval.b);
    }

    public boolean containsCoordinateSystem(Scene2D scene2D) {
        return this.xmin <= scene2D.xmin && this.xmax >= scene2D.xmax && this.ymin <= scene2D.ymin && this.ymax >= scene2D.ymax;
    }

    public void coordsChanged() {
        this.changed = true;
    }

    public void equalizeCoords() {
        int n = this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right;
        int n2 = this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom;
        double d = this.xmin;
        double d2 = this.xmax;
        double d3 = this.ymin;
        double d4 = this.ymax;
        double d5 = (this.xmax - this.xmin) / (double)n;
        double d6 = (this.ymax - this.ymin) / (double)n2;
        int n3 = this.getArea();
        if (d5 < d6) {
            double d7 = d6 * (double)n - (this.xmax - this.xmin);
            if (n3 == 1 || n3 == 6 || n3 == 4) {
                d2 = this.xmax + d7;
            }
            if (n3 == 2 || n3 == 8 || n3 == 5) {
                d = this.xmin - d7 / 2.0;
                d2 = this.xmax + d7 / 2.0;
            }
            if (n3 == 0 || n3 == 7 || n3 == 3) {
                d = this.xmin - d7;
            }
        } else {
            double d8 = d5 * (double)n2 - (this.ymax - this.ymin);
            if (n3 == 1 || n3 == 2 || n3 == 0) {
                d4 = this.ymax + d8;
            }
            if (n3 == 7 || n3 == 8 || n3 == 6) {
                d4 = this.ymax + d8 / 2.0;
                d3 = this.ymin - d8 / 2.0;
            }
            if (n3 == 4 || n3 == 5 || n3 == 3) {
                d3 = this.ymin - d8;
            }
        }
        this.checkAndSetLimits(d, d2, d3, d4);
    }

    public CoordinateRect2D getCoordinates() {
        return new CoordinateRect2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public int getEdge() {
        return this.edge;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXPixelScale() {
        return (this.xmax - this.xmin) / (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right);
    }

    public double getYmax() {
        return this.ymax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYPixelScale() {
        return (this.ymax - this.ymin) / (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom);
    }

    public double pixelToX(int n) {
        return this.xmin + (double)(n - this.edge - this.insets.left) * (this.xmax - this.xmin) / (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right - 1);
    }

    public double pixelToY(int n) {
        return this.ymax - (double)(n - this.edge - this.insets.top) * (this.ymax - this.ymin) / (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom - 1);
    }

    public void processRequests() {
        if (this.requestedInsets.left != 0 || this.requestedInsets.right != 0 || this.requestedInsets.top != 0 || this.requestedInsets.bottom != 0) {
            this.insets.left += this.requestedInsets.left;
            this.insets.right += this.requestedInsets.right;
            this.insets.top += this.requestedInsets.top;
            this.insets.bottom += this.requestedInsets.bottom;
            this.changed = true;
            this.requestedInsets.left = 0;
            this.requestedInsets.right = 0;
            this.requestedInsets.top = 0;
            this.requestedInsets.bottom = 0;
        }
    }

    public void requestSpaceBottom(int n) {
        if (n >= this.mathpanel2d.getHeight() - this.edge && Math.abs(n - this.mathpanel2d.getHeight() + this.edge) > this.requestedInsets.bottom) {
            this.requestedInsets.bottom = Math.abs(n - this.mathpanel2d.getHeight() + this.edge);
        }
    }

    public void requestSpaceLeft(int n) {
        if (n <= this.edge && Math.abs(this.edge - n) > this.requestedInsets.left) {
            this.requestedInsets.left = Math.abs(this.edge - n);
        }
    }

    public void requestSpaceRight(int n) {
        if (n >= this.mathpanel2d.getWidth() - this.edge && Math.abs(n - this.mathpanel2d.getWidth() + this.edge) > this.requestedInsets.right) {
            this.requestedInsets.right = Math.abs(n - this.mathpanel2d.getWidth() + this.edge);
        }
    }

    public void requestSpaceTop(int n) {
        if (n <= this.edge && Math.abs(this.edge - n) > this.requestedInsets.top) {
            this.requestedInsets.top = Math.abs(this.edge - n);
        }
    }

    protected void resetInsets() {
        this.insets.bottom = 0;
        this.insets.top = 0;
        this.insets.left = 0;
        this.insets.right = 0;
        this.requestedInsets.bottom = 0;
        this.requestedInsets.top = 0;
        this.requestedInsets.left = 0;
        this.requestedInsets.right = 0;
    }

    public void roundCoords(int n, int n2) {
        CoordinateRect2D coordinateRect2D = Scene2D.roundCoords(n, n2, this.getCoordinates());
        this.setLimits(coordinateRect2D);
    }

    public static CoordinateRect2D roundCoords(int n, int n2, CoordinateRect2D coordinateRect2D) {
        double d = coordinateRect2D.ymin;
        double d2 = coordinateRect2D.ymax;
        double d3 = coordinateRect2D.xmin;
        double d4 = coordinateRect2D.xmax;
        double d5 = d;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = Math.abs((d4 - d3) / 100.0 * (double)n);
        double d10 = Math.abs((d2 - d) / 100.0 * (double)n);
        if (n2 == 2 || n2 == 1) {
            d6 = Rounder.getUpperRoundValue(d2, d10);
            d5 = Rounder.getLowerRoundValue(d, d10);
        }
        if (n2 == 0 || n2 == 1) {
            d8 = Rounder.getUpperRoundValue(d4, d9);
            d7 = Rounder.getLowerRoundValue(d3, d9);
        }
        if (n2 == 2 || n2 == 1) {
            if (d > 0.0 && d - d10 < 0.0) {
                d5 = 0.0;
            }
            if (d2 < 0.0 && d2 + d10 > 0.0) {
                d6 = 0.0;
            }
        }
        if (n2 == 0 || n2 == 1) {
            if (d3 > 0.0 && d3 - d9 < 0.0) {
                d7 = 0.0;
            }
            if (d4 < 0.0 && d4 + d9 > 0.0) {
                d8 = 0.0;
            }
        }
        return new CoordinateRect2D(d7, d8, d5, d6);
    }

    public void setEdge(int n) {
        if (this.edge != n) {
            this.changed = true;
            this.edge = n;
        }
    }

    public void setLimits(CoordinateRect2D coordinateRect2D) {
        this.setLimits(coordinateRect2D.xmin, coordinateRect2D.xmax, coordinateRect2D.ymin, coordinateRect2D.ymax);
    }

    public void setLimits(double d, double d2, double d3, double d4) {
        if (this.xmin != d || this.xmax != d2 || this.ymin != d3 || this.ymax != d4) {
            this.changed = true;
        }
        this.checkAndSetLimits(d, d2, d3, d4);
    }

    public void ensureLimits(CoordinateRect2D coordinateRect2D) {
        double d = this.xmin < coordinateRect2D.xmin ? this.xmin : coordinateRect2D.xmin;
        double d2 = this.xmax < coordinateRect2D.xmax ? coordinateRect2D.xmax : this.xmax;
        double d3 = this.ymin < coordinateRect2D.ymin ? this.ymin : coordinateRect2D.ymin;
        double d4 = this.ymax < coordinateRect2D.ymax ? coordinateRect2D.ymax : this.ymax;
        this.setLimits(d, d2, d3, d4);
    }

    public void ensureZeroY() {
        if (this.ymin > 0.0) {
            this.setLimits(this.xmin, this.xmax, 0.0, this.ymax);
            return;
        }
        if (this.ymax < 0.0) {
            this.setLimits(this.xmin, this.xmax, this.ymin, 0.0);
            return;
        }
    }

    private void checkAndSetLimits(double d, double d2, double d3, double d4) {
        if (this.xmin != d || this.xmax != d2 || this.ymin != d3 || this.ymax != d4) {
            this.changed = true;
        }
        if (d == d2) {
            this.xmin = -2.0 * Math.abs(d);
            this.xmax = 2.0 * Math.abs(d);
        } else {
            this.xmin = d;
            this.xmax = d2;
        }
        if (d3 == d4) {
            this.ymin = -2.0 * Math.abs(d3);
            this.ymax = 2.0 * Math.abs(d3);
        } else {
            this.ymin = d3;
            this.ymax = d4;
        }
    }

    public void SetPanel(MathPanel2D mathPanel2D) {
        this.mathpanel2d = mathPanel2D;
    }

    public String toString() {
        return new String("[xmin=" + this.xmin + ",xmax=" + this.xmax + " ymin=" + this.ymin + ",ymax=" + this.ymax + "]");
    }

    public int xToPixel(double d) {
        int n = this.edge + this.insets.left + (int)Math.round((d - this.xmin) / (this.xmax - this.xmin) * (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right - 1));
        return n;
    }

    public int yToPixel(double d) {
        int n = this.edge + this.insets.top + (int)Math.round((this.ymax - d) / (this.ymax - this.ymin) * (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom - 1));
        return n;
    }

    public Point project(Punkt2D punkt2D) {
        return new Point(this.xToPixel(punkt2D.x), this.yToPixel(punkt2D.y));
    }

    public Punkt2D projectdouble(Punkt2D punkt2D) {
        return new Punkt2D(this.xToPixel(punkt2D.x), this.yToPixel(punkt2D.y));
    }

    public CoordinateRect2D getLimits() {
        return new CoordinateRect2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public double getXRange() {
        return Math.abs(this.xmax - this.xmin);
    }

    public double getYRange() {
        return Math.abs(this.ymax - this.ymin);
    }

    public double getMinRange() {
        return Math.min(this.getYRange(), this.getXRange());
    }

    public int getArea() {
        if (this.ymin >= 0.0) {
            if (this.xmin >= 0.0) {
                return 1;
            }
            if (this.xmax <= 0.0) {
                return 0;
            }
            return 2;
        }
        if (this.ymax <= 0.0) {
            if (this.xmin >= 0.0) {
                return 4;
            }
            if (this.xmax <= 0.0) {
                return 3;
            }
            return 5;
        }
        if (this.xmax <= 0.0) {
            return 7;
        }
        if (this.xmin >= 0.0) {
            return 6;
        }
        return 8;
    }
}

