/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uibk.draw2d.base.Drawable2D;
import uibk.draw2d.base.Scene2D;
import uibk.lang.Dragable;
import uibk.lang.Options;
import uibk.lang.PrepaintComputable;
import uibk.lang.ToolTipable;

public class MathPanel2D
extends JPanel
implements ComponentListener {
    public BufferedImage framebuffer;
    protected Vector drawItems = new Vector();
    Dragable dragged = null;
    boolean listenForDrags = false;
    private Scene2D scene2d;
    private JLabel jLabelReports = null;
    private MyMouseListening mouseListener = new MyMouseListening();
    private MyMouseMotionListening mouseMotionListener = new MyMouseMotionListening();

    public void requestRecompute() {
        this.scene2d.changed = true;
    }

    public void repaint() {
        if (this.scene2d != null) {
            this.scene2d.changed = true;
        }
        super.repaint();
    }

    public MathPanel2D() {
        this.setBackground(Color.white);
        this.scene2d = new Scene2D(-1.0, 1.0, -1.0, 1.0);
        this.scene2d.SetPanel(this);
        this.addComponentListener(this);
    }

    public Scene2D getScene2d() {
        return this.scene2d;
    }

    public boolean isPointInCoordsArea(Point point) {
        Insets insets = this.scene2d.getInsets();
        int n = this.scene2d.getEdge();
        return point.x > insets.left + n && point.x < this.getWidth() - insets.right - n && point.y < this.getHeight() - insets.bottom - n && point.y > insets.top + n;
    }

    public void setListenForDrags(boolean bl) {
        if (bl == this.listenForDrags) {
            return;
        }
        this.listenForDrags = bl;
        if (bl) {
            this.addMouseListener(this.mouseListener);
            this.addMouseMotionListener(this.mouseMotionListener);
        } else {
            this.removeMouseListener(this.mouseListener);
            this.removeMouseMotionListener(this.mouseMotionListener);
        }
    }

    public void add(Object object) {
        if (object != null && object instanceof Drawable2D && !this.drawItems.contains(object)) {
            Drawable2D drawable2D = (Drawable2D)object;
            drawable2D.setMathPanel2d(this);
            this.drawItems.addElement(drawable2D);
        }
    }

    void preparebuffer() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.framebuffer != null && (this.framebuffer.getWidth() != n || this.framebuffer.getHeight() != n2)) {
            this.scene2d.coordsChanged();
        }
        if (this.framebuffer == null || n > this.framebuffer.getWidth() || n2 > this.framebuffer.getHeight()) {
            this.framebuffer = (BufferedImage)this.createImage(n, n2);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.preparebuffer();
        this.scene2d.SetPanel(this);
        Graphics2D graphics2D = this.framebuffer.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.framebuffer.getWidth(), this.framebuffer.getHeight());
        this.drawDrawables(this.framebuffer, graphics2D);
        graphics.drawImage(this.framebuffer, 0, 0, null);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.scene2d.changed = true;
        this.repaint();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    protected void drawDrawables(BufferedImage bufferedImage, Graphics2D graphics2D) {
        Options.setRenderingHints(graphics2D);
        int n = this.drawItems.size();
        this.scene2d.processRequests();
        this.scene2d.resetInsets();
        int n2 = 0;
        while (n2 < n) {
            if (this.drawItems.elementAt(n2) instanceof PrepaintComputable && ((Drawable2D)this.drawItems.elementAt(n2)).getVisible()) {
                try {
                    ((PrepaintComputable)this.drawItems.elementAt(n2)).prepaintcompute();
                }
                catch (Exception exception) {
                    this.reportError(exception.getMessage());
                }
            }
            ++n2;
        }
        this.scene2d.processRequests();
        if (this.scene2d.changed) {
            n2 = 0;
            while (n2 < n) {
                if (this.drawItems.elementAt(n2) instanceof PrepaintComputable && ((Drawable2D)this.drawItems.elementAt(n2)).getVisible()) {
                    try {
                        ((PrepaintComputable)this.drawItems.elementAt(n2)).prepaintcompute();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n) {
            Drawable2D drawable2D = (Drawable2D)this.drawItems.elementAt(n2);
            if (drawable2D.getVisible()) {
                drawable2D.draw(bufferedImage, graphics2D);
            }
            ++n2;
        }
        this.scene2d.changed = false;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.drawItems.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.drawItems.elementAt(n2) instanceof ToolTipable && ((ToolTipable)this.drawItems.elementAt(n2)).isToolTipEnabled() && ((ToolTipable)this.drawItems.elementAt(n2)).tooltipcontains(mouseEvent.getX(), mouseEvent.getY())) {
                return ((ToolTipable)this.drawItems.elementAt(n2)).getToolTipText(mouseEvent);
            }
            ++n2;
        }
        return null;
    }

    public void report(String string) {
        this.jLabelReports.setForeground(Color.black);
        this.jLabelReports.setText(string);
    }

    public void reportError(String string) {
        this.jLabelReports.setForeground(new Color(255, 51, 0));
        this.jLabelReports.setText(string);
    }

    public void reportSuccess(String string) {
        this.jLabelReports.setForeground(new Color(0, 200, 0));
        this.jLabelReports.setText(string);
    }

    public void setReportingLabel(JLabel jLabel) {
        this.jLabelReports = jLabel;
    }

    private class MyMouseListening
    extends MouseAdapter {
        MyMouseListening() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = MathPanel2D.this.drawItems.size() - 1;
            while (n >= 0) {
                if (MathPanel2D.this.drawItems.elementAt(n) instanceof Dragable && ((Dragable)MathPanel2D.this.drawItems.elementAt(n)).dragcontains(mouseEvent.getX(), mouseEvent.getY())) {
                    MathPanel2D.this.dragged = (Dragable)MathPanel2D.this.drawItems.elementAt(n);
                    MathPanel2D.this.drawItems.remove(n);
                    MathPanel2D.this.drawItems.add((Drawable2D)((Object)MathPanel2D.this.dragged));
                }
                --n;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MathPanel2D.this.dragged = null;
        }
    }

    private class MyMouseMotionListening
    extends MouseMotionAdapter {
        MyMouseMotionListening() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (MathPanel2D.this.dragged == null) {
                return;
            }
            MathPanel2D.this.dragged.drag(mouseEvent);
            MathPanel2D.this.repaint();
        }
    }
}

