/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.Vector;
import uibk.draw2d.axes2d.Axes2D;
import uibk.draw2d.axes2d.Tick;
import uibk.draw2d.base.Scene2D;
import uibk.geom.Punkt2D;

class YAxis {
    Vector ticks;
    Point startPix = new Point();
    Point endPix = new Point();
    int arrowLength = 15;
    int offArrow = 5;
    int offarrowLength = 5;
    private final int ARROW_UP = 0;
    private final int ARROW_DOWN = 1;
    Axes2D axes;

    public YAxis(Axes2D axes2D) {
        this.axes = axes2D;
    }

    public void setTicks(Vector vector) {
        this.ticks = vector;
    }

    public void compute(Punkt2D punkt2D, Punkt2D punkt2D2, Punkt2D punkt2D3, int n, Graphics2D graphics2D, Scene2D scene2D) {
        int n2;
        int n3 = this.axes.styleYAxis;
        this.axes.getClass();
        if (n3 != 2) {
            Vector vector = this.axes.computeTickPositions(punkt2D.y, punkt2D2.y, scene2D.getYPixelScale());
            if (vector != null && vector.size() > 0) {
                this.ticks = this.axes.createTicks(vector, n, scene2D.getYPixelScale(), punkt2D.x);
            }
            if (this.ticks != null) {
                n2 = 0;
                while (n2 < this.ticks.size()) {
                    ((Tick)this.ticks.elementAt(n2)).compute(graphics2D, scene2D);
                    ++n2;
                }
            }
        }
        int n4 = scene2D.xToPixel(punkt2D.x);
        n2 = scene2D.yToPixel(punkt2D.y);
        int n5 = scene2D.xToPixel(punkt2D2.x);
        int n6 = scene2D.yToPixel(punkt2D2.y);
        if (punkt2D3 != null && Math.abs(punkt2D.y - punkt2D3.y) > Math.abs(punkt2D2.y - punkt2D3.y)) {
            this.startPix.x = n5;
            this.startPix.y = n6;
            this.endPix.x = n4;
            this.endPix.y = n2;
            scene2D.requestSpaceBottom(this.endPix.y + this.arrowLength);
            if (this.axes.area == 8 || this.axes.area == 6 || this.axes.area == 7) {
                this.startPix.y -= this.arrowLength;
                scene2D.requestSpaceTop(this.startPix.y);
            }
        } else {
            this.startPix.x = n4;
            this.startPix.y = n2;
            this.endPix.x = n5;
            this.endPix.y = n6;
            scene2D.requestSpaceTop(this.endPix.y - this.arrowLength);
            if (this.axes.area == 8 || this.axes.area == 6 || this.axes.area == 7) {
                this.startPix.y += this.arrowLength;
                scene2D.requestSpaceBottom(this.startPix.y);
            }
        }
        scene2D.requestSpaceRight(this.startPix.x + this.offArrow);
        scene2D.requestSpaceLeft(this.startPix.x - this.offArrow);
    }

    private void drawArrow(Graphics2D graphics2D, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                graphics2D.drawLine(n, n2, n, n2 - this.arrowLength);
                graphics2D.drawLine(n, n2 - this.arrowLength, n - this.offArrow, n2 - this.arrowLength + this.offarrowLength);
                graphics2D.drawLine(n, n2 - this.arrowLength, n + this.offArrow, n2 - this.arrowLength + this.offarrowLength);
                break;
            }
            case 1: {
                graphics2D.drawLine(n, n2, n, n2 + this.arrowLength);
                graphics2D.drawLine(n, n2 + this.arrowLength, n - this.offArrow, n2 + this.arrowLength - this.offarrowLength);
                graphics2D.drawLine(n, n2 + this.arrowLength, n + this.offArrow, n2 + this.arrowLength - this.offarrowLength);
            }
        }
    }

    public void draw(Graphics2D graphics2D, Scene2D scene2D) {
        graphics2D.setColor(Color.black);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.5f));
        if (this.axes.style == 1) {
            if (this.startPix.y > this.endPix.y) {
                this.drawArrow(graphics2D, this.endPix.x, this.endPix.y, 0);
            } else {
                this.drawArrow(graphics2D, this.endPix.x, this.endPix.y, 1);
            }
            graphics2D.drawLine(this.startPix.x, this.startPix.y, this.endPix.x, this.endPix.y);
        }
        graphics2D.setStroke(stroke);
        if (this.ticks != null) {
            int n = this.axes.styleYAxis;
            this.axes.getClass();
            if (n != 2) {
                int n2 = this.axes.styleYAxis;
                this.axes.getClass();
                boolean bl = n2 == 1;
                int n3 = 0;
                while (n3 < this.ticks.size()) {
                    ((Tick)this.ticks.elementAt(n3)).draw(graphics2D, scene2D, bl);
                    ++n3;
                }
            }
        }
    }
}

