/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import uibk.draw2d.axes2d.Axes2D;
import uibk.draw2d.base.Scene2D;

public class Tick {
    public static final int TL_LEFT = 0;
    public static final int TL_RIGHT = 1;
    public static final int TL_TOP = 2;
    public static final int TL_BOTTOM = 3;
    public static final int LABEL_CENTER = 0;
    public static final int LABEL_MOVEUP = 1;
    public static final int LABEL_MOVEDOWN = 2;
    public static final int LABEL_MOVERIGHT = 3;
    public static final int LABEL_MOVELEFT = 4;
    boolean bigTick;
    double tickPosX;
    double tickPosY;
    int labelXPos;
    int labelYPos;
    int labelPos;
    String label;
    int lengthBigTick = 6;
    int lengthSmallTick = 3;
    Axes2D axes;
    int pos;
    int space = 10;

    Tick(int n, double d, double d2, boolean bl, String string, int n2, Axes2D axes2D) {
        this.pos = n;
        this.tickPosX = d;
        this.tickPosY = d2;
        this.bigTick = bl;
        this.labelPos = n2;
        this.label = string;
        this.axes = axes2D;
    }

    public void compute(Graphics2D graphics2D, Scene2D scene2D) {
        if (!this.bigTick) {
            return;
        }
        int n = scene2D.xToPixel(this.tickPosX);
        int n2 = scene2D.yToPixel(this.tickPosY);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.axes.font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(this.label);
        int n4 = fontMetrics.getHeight();
        graphics2D.setFont(font);
        switch (this.pos) {
            case 0: {
                switch (this.labelPos) {
                    case 1: {
                        this.labelYPos = n2 - this.lengthSmallTick;
                        break;
                    }
                    case 2: {
                        this.labelYPos = n2 + n4 / 2 + this.lengthSmallTick;
                        break;
                    }
                    default: {
                        this.labelYPos = n2 + n4 / 4;
                    }
                }
                this.labelXPos = n - n3 - this.space;
                scene2D.requestSpaceLeft(this.labelXPos);
                break;
            }
            case 1: {
                this.labelXPos = n + this.space;
                this.labelYPos = n2 + n4 / 4;
                scene2D.requestSpaceRight(this.labelXPos + n3);
                break;
            }
            case 2: {
                this.labelXPos = n - n3 / 2;
                this.labelYPos = n2 - this.space;
                scene2D.requestSpaceRight(this.labelXPos + n3);
                scene2D.requestSpaceLeft(this.labelXPos);
                scene2D.requestSpaceTop(this.labelYPos);
                break;
            }
            case 3: {
                switch (this.labelPos) {
                    case 3: {
                        this.labelXPos = n + this.lengthSmallTick;
                        break;
                    }
                    case 4: {
                        this.labelXPos = n - n3 - this.lengthSmallTick;
                        break;
                    }
                    default: {
                        this.labelXPos = n - n3 / 2;
                    }
                }
                this.labelYPos = n2 + this.space + n4 / 2;
                scene2D.requestSpaceRight(this.labelXPos + n3);
                scene2D.requestSpaceLeft(this.labelXPos);
                scene2D.requestSpaceBottom(this.labelYPos);
            }
        }
    }

    public void drawTick(Graphics2D graphics2D, Scene2D scene2D) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(0.5f));
        int n = this.bigTick ? this.lengthBigTick : this.lengthSmallTick;
        int n2 = scene2D.xToPixel(this.tickPosX);
        int n3 = scene2D.yToPixel(this.tickPosY);
        switch (this.pos) {
            case 0: {
                graphics2D.drawLine(n2 - n, n3, n2, n3);
                break;
            }
            case 1: {
                graphics2D.drawLine(n2 + n, n3, n2, n3);
                break;
            }
            case 2: {
                graphics2D.drawLine(n2, n3 - n, n2, n3);
                break;
            }
            case 3: {
                graphics2D.drawLine(n2, n3 + n, n2, n3);
            }
        }
        graphics2D.setStroke(stroke);
    }

    public void drawLabel(Graphics2D graphics2D) {
        if (!this.bigTick) {
            return;
        }
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.axes.font);
        if (this.label != null) {
            graphics2D.drawString(this.label, this.labelXPos, this.labelYPos);
        }
        graphics2D.setFont(font);
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    public void draw(Graphics2D graphics2D, Scene2D scene2D, boolean bl) {
        this.drawLabel(graphics2D);
        if (bl) {
            this.drawTick(graphics2D, scene2D);
        }
    }
}

