/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.draw2d.axes2d.Tick;
import uibk.draw2d.axes2d.XAxis;
import uibk.draw2d.axes2d.YAxis;
import uibk.draw2d.base.Drawable2D;
import uibk.geom.Punkt2D;
import uibk.lang.Options;
import uibk.lang.PrepaintComputable;
import uibk.math.Rounder;

public class Axes2D
extends Drawable2D
implements PrepaintComputable {
    public static final int STYLE_BOX = 0;
    public static final int STYLE_INTELLIGENT = 1;
    int style = 1;
    public final int AXES_DRAW_ALWAYS = 0;
    public final int AXES_DRAW_STRICT = 1;
    public final int AXES_DRAW_NEVER = 2;
    public final int AXES_STYLE_TICKS = 0;
    public final int AXES_STYLE_TICKS_AND_LABELS = 1;
    public final int AXES_STYLE_NOTICKS = 2;
    protected Font font;
    protected int area;
    private XAxis xaxis = new XAxis(this);
    private YAxis yaxis = new YAxis(this);
    private int visibilityXAxis;
    private int visibilityYAxis;
    protected int styleXAxis = 1;
    protected int styleYAxis = 1;
    private int fontSize = 10;
    private int numTicks = 10;
    private Punkt2D pointAxesIntersect;

    public void setAxesStyle(int n) {
        this.style = n;
    }

    public int getAxesStyle() {
        return this.style;
    }

    public void setVisibilityXAxis(int n) {
        this.visibilityXAxis = n;
    }

    public void setVisibilityYAxis(int n) {
        this.visibilityYAxis = n;
    }

    public void setStyleXAxis(int n) {
        this.styleXAxis = n;
    }

    public void setStyleYAxis(int n) {
        this.styleYAxis = n;
    }

    public void setNumTicks(int n) {
        this.numTicks = n;
    }

    private void colorEdge(Graphics2D graphics2D) {
        graphics2D.setColor(Options.componentsColor);
        Insets insets = this.scene2d.getInsets();
        int n = this.scene2d.getEdge();
        graphics2D.fillRect(1, 1, insets.left + n, this.panel.getHeight() - 1);
        graphics2D.fillRect(1, 1, this.panel.getWidth() - 1, insets.top + n);
        graphics2D.fillRect(1, this.panel.getHeight() - insets.top - n, this.panel.getWidth() - 1, insets.top + n);
        graphics2D.fillRect(this.panel.getWidth() - n - insets.right, 1, this.panel.getWidth(), this.panel.getHeight() - 1);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, this.panel.getWidth() - 1, this.panel.getHeight() - 1);
    }

    public void draw(BufferedImage bufferedImage, Graphics2D graphics2D) {
        if (this.style == 0) {
            this.colorEdge(graphics2D);
        }
        if (this.XAxisVisible()) {
            this.xaxis.draw(graphics2D, this.scene2d);
        }
        if (this.YAxisVisible()) {
            this.yaxis.draw(graphics2D, this.scene2d);
        }
        if (this.style == 0) {
            graphics2D.setColor(Color.black);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.5f));
            int n = this.scene2d.xToPixel(this.scene2d.getXmin());
            int n2 = this.scene2d.xToPixel(this.scene2d.getXmax());
            int n3 = this.scene2d.yToPixel(this.scene2d.getYmin());
            int n4 = this.scene2d.yToPixel(this.scene2d.getYmax());
            graphics2D.drawLine(n, n3, n2, n3);
            graphics2D.drawLine(n, n3, n, n4);
            graphics2D.drawLine(n2, n3, n2, n4);
            graphics2D.drawLine(n, n4, n2, n4);
            graphics2D.setStroke(stroke);
        }
    }

    private boolean XAxisVisible() {
        return this.visibilityXAxis != 2 && (this.visibilityXAxis != 1 || this.pointAxesIntersect.y == 0.0);
    }

    private boolean YAxisVisible() {
        return this.visibilityYAxis != 2 && (this.visibilityYAxis != 1 || this.pointAxesIntersect.x == 0.0);
    }

    public void prepaintcompute() {
        double d = this.scene2d.getXmax();
        double d2 = this.scene2d.getXmin();
        double d3 = this.scene2d.getYmax();
        double d4 = this.scene2d.getYmin();
        this.pointAxesIntersect = new Punkt2D();
        this.area = this.scene2d.getArea();
        Punkt2D punkt2D = new Punkt2D();
        Punkt2D punkt2D2 = new Punkt2D();
        Punkt2D punkt2D3 = new Punkt2D();
        Punkt2D punkt2D4 = new Punkt2D();
        int n = 0;
        int n2 = 0;
        if (this.style == 0) {
            this.area = 1;
        }
        switch (this.area) {
            case 1: {
                punkt2D.x = d2;
                punkt2D.y = d4;
                punkt2D2.x = d;
                punkt2D2.y = d4;
                punkt2D3.x = d2;
                punkt2D3.y = d4;
                punkt2D4.x = d2;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d2;
                this.pointAxesIntersect.y = d4;
                n = 3;
                n2 = 0;
                break;
            }
            case 6: {
                punkt2D.x = d2;
                punkt2D.y = 0.0;
                punkt2D2.x = d;
                punkt2D2.y = 0.0;
                punkt2D3.x = d2;
                punkt2D3.y = d4;
                punkt2D4.x = d2;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d2;
                this.pointAxesIntersect.y = 0.0;
                n = 3;
                n2 = 0;
                break;
            }
            case 4: {
                punkt2D.x = d2;
                punkt2D.y = d3;
                punkt2D2.x = d;
                punkt2D2.y = d3;
                punkt2D3.x = d2;
                punkt2D3.y = d4;
                punkt2D4.x = d2;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d2;
                this.pointAxesIntersect.y = d3;
                n = 3;
                n2 = 0;
                break;
            }
            case 2: {
                punkt2D.x = d2;
                punkt2D.y = d4;
                punkt2D2.x = d;
                punkt2D2.y = d4;
                punkt2D3.x = 0.0;
                punkt2D3.y = d4;
                punkt2D4.x = 0.0;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = d4;
                n = 3;
                n2 = 0;
                break;
            }
            case 8: {
                punkt2D.x = d2;
                punkt2D.y = 0.0;
                punkt2D2.x = d;
                punkt2D2.y = 0.0;
                punkt2D3.x = 0.0;
                punkt2D3.y = d4;
                punkt2D4.x = 0.0;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = 0.0;
                n = 3;
                n2 = 0;
                break;
            }
            case 7: {
                punkt2D.x = d2;
                punkt2D.y = 0.0;
                punkt2D2.x = d;
                punkt2D2.y = 0.0;
                punkt2D3.x = d;
                punkt2D3.y = d4;
                punkt2D4.x = d;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d;
                this.pointAxesIntersect.y = 0.0;
                n = 3;
                n2 = 1;
                break;
            }
            case 0: {
                punkt2D.x = d2;
                punkt2D.y = d4;
                punkt2D2.x = d;
                punkt2D2.y = d4;
                punkt2D3.x = d;
                punkt2D3.y = d4;
                punkt2D4.x = d;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d;
                this.pointAxesIntersect.y = d4;
                n = 3;
                n2 = 1;
                break;
            }
            case 3: {
                punkt2D.x = d2;
                punkt2D.y = d3;
                punkt2D2.x = d;
                punkt2D2.y = d3;
                punkt2D3.x = d;
                punkt2D3.y = d4;
                punkt2D4.x = d;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d;
                this.pointAxesIntersect.y = d3;
                n = 2;
                n2 = 1;
                break;
            }
            case 5: {
                punkt2D.x = d2;
                punkt2D.y = d3;
                punkt2D2.x = d;
                punkt2D2.y = d3;
                punkt2D3.x = 0.0;
                punkt2D3.y = d4;
                punkt2D4.x = 0.0;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = d3;
                n = 2;
                n2 = 0;
            }
        }
        if (!this.XAxisVisible() || !this.YAxisVisible()) {
            this.pointAxesIntersect = null;
        }
        if (this.XAxisVisible()) {
            this.xaxis.compute(punkt2D, punkt2D2, this.pointAxesIntersect, n, (Graphics2D)this.panel.getGraphics(), this.scene2d);
        }
        if (this.YAxisVisible()) {
            this.yaxis.compute(punkt2D3, punkt2D4, this.pointAxesIntersect, n2, (Graphics2D)this.panel.getGraphics(), this.scene2d);
        }
    }

    protected Vector computeTickPositions(double d, double d2, double d3) {
        Vector<TickPosition> vector = new Vector<TickPosition>();
        switch (this.style) {
            case 1: {
                if (d2 >= 0.0 && d <= 0.0 && this.area != 1) {
                    boolean bl;
                    vector.add(new TickPosition(0.0, true, 0));
                    double d4 = Math.abs(d2) >= Math.abs(d) ? Math.abs(d2) : Math.abs(d);
                    double d5 = Math.abs(Rounder.roundDownToLeadingDec(d4)) / (double)this.numTicks;
                    int n = 1;
                    double d6 = d5;
                    while (d6 <= d2) {
                        bl = n % 5 == 0;
                        vector.add(new TickPosition(d6, bl, 0));
                        d6 = d5 * (double)(++n);
                    }
                    d6 = -d5;
                    n = 1;
                    while (d6 >= d) {
                        bl = n % 5 == 0;
                        vector.add(new TickPosition(d6, bl, 0));
                        d6 = -d5 * (double)(++n);
                    }
                } else {
                    int n = 1;
                    if (this.area == 2 || this.area == 1 || this.area == 0 || this.area == 6) {
                        vector.add(new TickPosition(d, true, 1));
                        double d7 = Math.abs(Rounder.roundDownToLeadingDec(d2 - d)) / (double)this.numTicks;
                        double d8 = d + d7;
                        while (d8 <= d2) {
                            boolean bl = n % 5 == 0;
                            vector.add(new TickPosition(d8, bl, 0));
                            d8 = d + d7 * (double)(++n);
                        }
                    } else {
                        double d9 = Math.abs(Rounder.roundDownToLeadingDec(d - d2)) / (double)this.numTicks;
                        vector.add(new TickPosition(d2, true, 2));
                        double d10 = d2 - d9;
                        while (d10 >= d) {
                            boolean bl = n % 5 == 0;
                            vector.add(new TickPosition(d10, bl, 0));
                            d10 = d2 - d9 * (double)(++n);
                        }
                    }
                }
                if (vector.size() >= this.numTicks) break;
                vector.clear();
                vector.add(new TickPosition(d, true, 1));
                vector.add(new TickPosition(d2, true, 2));
                break;
            }
            case 0: {
                vector.add(new TickPosition(d, true, 1));
                double d11 = (d2 - d) / (double)this.numTicks;
                double d12 = d + d11;
                int n = 1;
                while (d12 < d2) {
                    boolean bl = n % 5 == 0;
                    vector.add(new TickPosition(d12, bl, 0));
                    d12 = d + d11 * (double)(++n);
                }
                vector.add(new TickPosition(d2, true, 2));
            }
        }
        return vector;
    }

    protected Vector createTicks(Vector vector, int n, double d, double d2) {
        Vector<Tick> vector2 = new Vector<Tick>();
        int n2 = 0;
        while (n2 < vector.size()) {
            TickPosition tickPosition = (TickPosition)vector.elementAt(n2);
            double d3 = n == 0 || n == 1 ? d2 : tickPosition.position;
            double d4 = n == 0 || n == 1 ? tickPosition.position : d2;
            Tick tick = null;
            if (tickPosition.bigTick) {
                boolean bl = true;
                int n3 = 0;
                if (this.pointAxesIntersect != null) {
                    if (this.area == 8 && d4 == this.pointAxesIntersect.y && d3 == this.pointAxesIntersect.x) {
                        bl = false;
                    }
                    if ((n == 0 || n == 1) && d4 == this.pointAxesIntersect.y) {
                        n3 = this.moveLabel(n);
                    }
                    if ((n == 2 || n == 3) && d3 == this.pointAxesIntersect.x) {
                        n3 = this.moveLabel(n);
                    }
                }
                if (bl) {
                    String string = null;
                    switch (tickPosition.type) {
                        case 0: {
                            string = String.valueOf(Rounder.getRoundValue(tickPosition.position, d));
                            break;
                        }
                        case 1: {
                            string = String.valueOf(Rounder.getLowerRoundValue(tickPosition.position, d));
                            break;
                        }
                        case 2: {
                            string = String.valueOf(Rounder.getUpperRoundValue(tickPosition.position, d));
                        }
                    }
                    tick = new Tick(n, d3, d4, tickPosition.bigTick, string, n3, this);
                }
            } else {
                tick = new Tick(n, d3, d4, tickPosition.bigTick, null, 0, this);
            }
            if (tick != null) {
                vector2.add(tick);
            }
            ++n2;
        }
        return vector2;
    }

    private int moveLabel(int n) {
        if (this.pointAxesIntersect != null && this.area == 6 && n == 3) {
            return 3;
        }
        if (this.pointAxesIntersect != null && this.area == 4 && n == 3) {
            return 3;
        }
        if (this.pointAxesIntersect != null && this.area == 2 && n == 0) {
            return 1;
        }
        if (this.pointAxesIntersect != null && this.area == 5 && n == 0) {
            return 2;
        }
        if (this.pointAxesIntersect != null && this.area == 7 && n == 3) {
            return 4;
        }
        return 0;
    }

    class TickPosition {
        double position;
        boolean bigTick;
        static final int NORMAL = 0;
        static final int MIN = 1;
        static final int MAX = 2;
        int type;

        TickPosition(double d, boolean bl, int n) {
            this.position = d;
            this.bigTick = bl;
            this.type = n;
        }
    }
}

