/*
 * Decompiled with CFR 0.152.
 */
package jaba.math;

import Jama.Matrix;

public class Vektor
extends Matrix {
    public Vektor(int n) {
        super(n, 1);
    }

    public Vektor(double[] dArray) {
        super(dArray.length, 1);
        int n = 0;
        while (n < dArray.length) {
            this.A[n][0] = dArray[n];
            ++n;
        }
    }

    public Vektor(Vektor vektor) {
        super(vektor);
    }

    public Vektor(Matrix matrix) {
        super(matrix.m, 1);
        int n = 0;
        while (n < matrix.m) {
            this.A[n][0] = matrix.A[n][0];
            ++n;
        }
    }

    public void set(int n, double d) {
        super.set(n, 0, d);
    }

    public void setVektor(int n, int n2, Vektor vektor) {
        int n3 = n;
        while (n3 <= n2) {
            super.set(n3, 0, vektor.get(n3 - n));
            ++n3;
        }
    }

    public void setVektor(Vektor vektor) {
        int n = 0;
        while (n < vektor.getRowDimension()) {
            super.set(n, 0, vektor.get(n));
            ++n;
        }
    }

    public int getLength() {
        return this.m;
    }

    public String toString() {
        String string = new String("(");
        int n = 0;
        while (n < this.m) {
            string = String.valueOf(string) + this.get(n);
            if (n < this.m - 1) {
                string = String.valueOf(string) + ",";
            }
            ++n;
        }
        string = String.valueOf(string) + ")";
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof Vektor) {
            Vektor vektor = (Vektor)object;
            if (vektor.m != this.m) {
                return false;
            }
            int n = 0;
            while (n < this.m) {
                if (vektor.get(n) != this.get(n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public double get(int n) {
        return super.get(n, 0);
    }

    public Vektor getVektor(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("index out of bounds");
        }
        Vektor vektor = new Vektor(n2 - n + 1);
        int n3 = n;
        while (n3 <= n2) {
            vektor.set(n3 - n, this.get(n3));
            ++n3;
        }
        return vektor;
    }

    public static Vektor concat(Vektor vektor, Vektor vektor2) {
        Vektor vektor3 = new Vektor(vektor.m + vektor.n);
        int n = 0;
        while (n < vektor.m) {
            vektor3.set(n, vektor.get(n));
            ++n;
        }
        n = vektor.m;
        while (n < vektor3.m) {
            vektor3.set(n, vektor2.get(n));
            ++n;
        }
        return vektor3;
    }

    public double dotprod(Vektor vektor) {
        if (vektor.m != this.m) {
            throw new IllegalArgumentException("Dim. does not match");
        }
        double d = 0.0;
        int n = 0;
        while (n < this.m) {
            d += vektor.get(n) * this.get(n);
            ++n;
        }
        return d;
    }

    public void setMatrixCol(Matrix matrix, int n) {
        if (matrix.m != this.m) {
            throw new IllegalArgumentException("Dim. does not match");
        }
        int n2 = 0;
        while (n2 < this.m) {
            this.set(n2, matrix.get(n2, n));
            ++n2;
        }
    }

    public void swap(int n, int n2) {
        if (n >= this.m || n2 >= this.m) {
            throw new IllegalArgumentException("index exceeds dimension");
        }
        double d = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, d);
    }
}

