/*
 * Decompiled with CFR 0.152.
 */
package jaba.math;

import jaba.math.Function;
import jaba.math.Interval;
import jaba.math.MathUtil;
import jaba.math.Settings;
import java.util.Vector;

public class ODESolver {
    Function f;
    ODEReport report = new ODEReport();
    public static final int INTEGRATE_BOTH = 0;
    public static final int INTEGRATE_FORWARD = 1;
    public static final int INTEGRATE_BACKWARD = 2;
    int integrationDirection = 0;
    int maxsteps = 2000;
    boolean denseoutput = true;
    int numberofsteps = 7;
    double[] initials;
    double TOL = 1.0E-7;
    double a;
    double b;
    double start = 0.0;
    double hmin = Settings.getMachinePrecision() * 100.0;
    double hstart = 0.1;
    double hdense = 0.001;
    int n = 0;
    boolean stepsizecontrol = true;
    private int denseoutputsteps = 3000;
    private boolean onlyendsolution = false;
    double[] y;
    double[] yerr;
    double estError;
    double[][] steps;
    double t;
    double h;
    double theta;

    public ODEReport getReport() {
        return this.report;
    }

    public boolean integrationSuccess() {
        boolean bl;
        boolean bl2;
        boolean bl3 = this.report.integratedforward ? !(this.report.toosmallstepforward || this.report.toomanystepsforward || this.report.singularityforward) : (bl2 = true);
        boolean bl4 = this.report.integratedbackward ? !(this.report.toosmallstepbackward || this.report.toomanystepsbackward || this.report.singularitybackward) : (bl = true);
        return bl2 && bl;
    }

    public double getTOL() {
        return this.TOL;
    }

    public double getInitialStepsize() {
        return this.hstart;
    }

    public void setInitialStepsize(double d) {
        this.hstart = d;
    }

    public boolean isStepSizeControlEnabled() {
        return this.stepsizecontrol;
    }

    public boolean isDenseOutputEnabled() {
        return this.denseoutput;
    }

    public int getMaxSteps() {
        return this.maxsteps;
    }

    public void setHMin(double d) {
        this.hmin = Math.abs(d);
    }

    public void enableDenseOutput(boolean bl) {
        this.denseoutput = bl;
    }

    public void enabelStepSizeControl(boolean bl) {
        this.stepsizecontrol = bl;
    }

    public ODESolver(Function function) {
        this.setDGL(function);
    }

    public ODESolver() {
    }

    public void setMaxSteps(int n) {
        this.maxsteps = n;
    }

    public void setIntegrationInvervall(Interval interval) {
        this.a = interval.a;
        this.b = interval.b;
    }

    public void setInitialCondition(double d, double[] dArray) {
        this.start = d;
        this.initials = dArray;
    }

    public void setTOL(double d) {
        this.TOL = d <= 0.0 ? 0.001 : d;
    }

    public void setDGL(Function function) {
        this.f = function;
        this.n = function.getNumberFunctions();
    }

    public void setHDense(double d) {
        this.hdense = Math.abs(d);
    }

    private double newStepSize() {
        double d = 6.0;
        double d2 = 0.2;
        int n = 5;
        if (this.stepsizecontrol) {
            return Math.abs(this.h) * Math.min(d, Math.max(d2, 0.9 * Math.pow(this.TOL / this.estError, 1.0 / (double)n)));
        }
        return Math.abs(this.h);
    }

    double calcerr(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.02;
        double d2 = 1.0;
        double d3 = 0.0;
        int n = 0;
        while (n < this.n) {
            double d4 = d + d2 * Math.max(Math.abs(dArray[n]), Math.abs(dArray2[n]));
            d3 += dArray3[n] / d4 * (dArray3[n] / d4);
            ++n;
        }
        d3 /= (double)this.n;
        d3 = Math.sqrt(d3);
        return d3;
    }

    public double[] solve(double d, double[] dArray) throws Exception {
        this.onlyendsolution = true;
        boolean bl = this.denseoutput;
        this.denseoutput = false;
        this.setInitialCondition(0.0, dArray);
        this.start = 0.0;
        if (d == 0.0) {
            return dArray;
        }
        if (d > 0.0) {
            this.b = d;
            this.a = 0.0;
        } else {
            this.a = d;
            d = 0.0;
        }
        Vector vector = this.solve(null);
        this.onlyendsolution = false;
        this.denseoutput = bl;
        return (double[])vector.elementAt(vector.size() - 1);
    }

    private void init() throws Exception {
        this.n = this.f.getNumberFunctions();
        if (this.f == null) {
            throw new Exception("No function defined");
        }
        if (this.initials == null) {
            throw new Exception("No initial values defined");
        }
        if (MathUtil.norm1(this.derivs(0.0, this.initials)) == 0.0) {
            throw new Exception("Initial value is steady state");
        }
        this.hdense = (this.b - this.a) / (double)this.denseoutputsteps;
        this.y = this.initials;
        this.yerr = new double[this.n];
        this.t = this.start;
        this.steps = new double[this.numberofsteps][0];
        this.report = new ODEReport();
        this.report.minstepsizebackward = Double.MAX_VALUE;
        this.report.maxstepsizebackward = Double.MIN_VALUE;
        this.report.minstepsizeforward = Double.MAX_VALUE;
        this.report.maxstepsizeforward = Double.MIN_VALUE;
        if (this.t < this.b) {
            this.report.integratedforward = true;
        }
        if (this.t > this.a) {
            this.report.integratedbackward = true;
        }
    }

    public Vector solve(Output output) throws Exception {
        double[] dArray;
        this.init();
        int n = 0;
        double[] dArray2 = null;
        this.h = Math.min(this.hstart, this.b - this.t);
        Vector<double[]> vector = new Vector<double[]>();
        Vector<double[]> vector2 = new Vector<double[]>();
        Vector<Object> vector3 = new Vector<Object>();
        boolean bl = false;
        if (this.integrationDirection == 0 || this.integrationDirection == 1) {
            this.report.timeforward = this.b;
        }
        while (this.t <= this.b) {
            if (this.h < this.hmin) {
                this.report.toosmallstepforward = true;
                this.report.timeforward = this.t;
                break;
            }
            if (n >= this.maxsteps) {
                this.report.toomanystepsforward = true;
                this.report.timeforward = this.t;
                break;
            }
            try {
                dArray2 = this.rkstep54();
            }
            catch (Exception exception) {
                this.report.singularityforward = true;
                this.report.timeforward = this.t;
                break;
            }
            if (!this.stepsizecontrol || this.estError <= this.TOL) {
                bl = true;
                if (Math.abs(this.h) < this.report.minstepsizeforward) {
                    this.report.minstepsizeforward = this.h;
                }
                if (Math.abs(this.h) > this.report.maxstepsizeforward) {
                    this.report.maxstepsizeforward = this.h;
                }
                if (this.denseoutput) {
                    double d = this.t + this.hdense;
                    while (d < this.t + this.h) {
                        this.theta = Math.abs((d - this.t) / this.h);
                        dArray = this.dense54();
                        if (this.t + this.h >= this.a) {
                            vector.add(dArray);
                        }
                        d += this.hdense;
                    }
                }
                if (!this.onlyendsolution && this.t >= this.a) {
                    vector.add(dArray2);
                }
                this.y = dArray2;
                this.t += this.h;
                if (Math.abs(this.b - this.t) <= this.hmin) break;
                this.h = Math.min(Math.abs(this.b - this.t), this.newStepSize());
            } else {
                bl = false;
                this.h = Math.min(Math.abs(this.b - this.t), this.newStepSize());
                ++this.report.stepsrepeatedforward;
            }
            ++n;
            if (output == null) continue;
            output.out(this.y, this.estError, this.h, bl);
        }
        this.report.valueforward = this.y;
        this.report.stepsforward = n;
        this.y = this.initials;
        this.t = this.start;
        n = 0;
        this.h = -Math.min(this.hstart, this.t - this.a);
        this.report.timebackward = this.a;
        if (this.integrationDirection == 0 || this.integrationDirection == 2) {
            while (this.t >= this.a) {
                if (Math.abs(this.h) < this.report.minstepsizebackward) {
                    this.report.minstepsizebackward = Math.abs(this.h);
                }
                if (Math.abs(this.h) > this.report.maxstepsizebackward) {
                    this.report.maxstepsizebackward = Math.abs(this.h);
                }
                if (Math.abs(this.h) < this.hmin) {
                    this.report.toosmallstepbackward = true;
                    this.report.timebackward = this.t;
                    break;
                }
                if (n >= this.maxsteps) {
                    this.report.toomanystepsbackward = true;
                    this.report.timebackward = this.t;
                    break;
                }
                try {
                    dArray2 = this.rkstep54();
                }
                catch (Exception exception) {
                    this.report.singularitybackward = true;
                    this.report.timebackward = this.t;
                    break;
                }
                if (!this.stepsizecontrol || this.estError <= this.TOL) {
                    bl = true;
                    if (this.denseoutput) {
                        double d = this.t - this.hdense;
                        while (d > this.t + this.h) {
                            this.theta = Math.abs((d - this.t) / Math.abs(this.h));
                            dArray = this.dense54();
                            vector2.add(dArray);
                            d -= this.hdense;
                        }
                    }
                    if (!this.onlyendsolution) {
                        vector2.add(dArray2);
                    }
                    this.y = dArray2;
                    this.t += this.h;
                    if (Math.abs(this.a - this.t) <= this.hmin) break;
                    this.h = -Math.min(Math.abs(this.a - this.t), this.newStepSize());
                } else {
                    bl = false;
                    this.h = -Math.min(Math.abs(this.a - this.t), this.newStepSize());
                    ++this.report.stepsrepeatedbackward;
                }
                ++n;
                if (output == null) continue;
                output.out(this.y, this.estError, this.h, bl);
            }
        }
        this.report.stepsbackward = n;
        boolean bl2 = this.report.integratedforward ? !(this.report.toosmallstepforward || this.report.toomanystepsforward || this.report.singularityforward) : (this.report.successforward = true);
        this.report.successbackward = this.report.integratedbackward ? !(this.report.toosmallstepbackward || this.report.toomanystepsbackward || this.report.singularitybackward) : true;
        this.report.valuebackward = this.y;
        if (!this.stepsizecontrol) {
            this.report.maxstepsizebackward = this.hstart;
            this.report.minstepsizebackward = this.hstart;
            this.report.maxstepsizeforward = this.hstart;
            this.report.minstepsizeforward = this.hstart;
        }
        if (this.onlyendsolution) {
            vector3.add(dArray2);
        } else {
            int n2 = vector2.size() - 1;
            while (n2 >= 0) {
                vector3.add(vector2.elementAt(n2));
                --n2;
            }
            if (this.a <= this.start && this.start <= this.b) {
                vector3.add(this.initials);
            }
            n2 = 0;
            while (n2 < vector.size()) {
                vector3.add(vector.elementAt(n2));
                ++n2;
            }
        }
        return vector3;
    }

    private double[] dense54() {
        double d = this.theta * (1.0 + this.theta * (-2.785416666666667 + this.theta * (2.886111111111111 + this.theta * -1.0095486111111112)));
        double d2 = 0.0;
        double d3 = 100.0 * this.theta * this.theta * (0.11363881401617251 + this.theta * (-0.1682659478885894 + this.theta * 0.06810422282120396)) / 3.0;
        double d4 = -5.0 * this.theta * this.theta * (0.675 + this.theta * (-1.8 + this.theta * 0.8645833333333334)) / 2.0;
        double d5 = 18225.0 * this.theta * this.theta * (-0.012 + this.theta * (0.058666666666666666 + this.theta * -0.06166666666666667)) / 848.0;
        double d6 = -22.0 * this.theta * this.theta * (-0.3 + this.theta * (0.9666666666666667 + this.theta * -0.7083333333333334)) / 7.0;
        double d7 = 0.0;
        double[] dArray = new double[this.n];
        double[] dArray2 = this.steps[0];
        double[] dArray3 = this.steps[1];
        double[] dArray4 = this.steps[2];
        double[] dArray5 = this.steps[3];
        double[] dArray6 = this.steps[4];
        double[] dArray7 = this.steps[5];
        double[] dArray8 = this.steps[6];
        int n = 0;
        while (n < this.n) {
            dArray[n] = this.y[n] + this.h * (d * dArray2[n] + d2 * dArray3[n] + d3 * dArray4[n] + d4 * dArray5[n] + d5 * dArray6[n] + d6 * dArray7[n] + d7 * dArray8[n]);
            ++n;
        }
        return dArray;
    }

    private double[] rkstep54() throws Exception {
        double[] dArray = new double[this.n];
        double[] dArray2 = new double[this.n];
        double d = 0.0;
        double d2 = 0.2;
        double d3 = 0.3;
        double d4 = 0.8;
        double d5 = 0.8888888888888888;
        double d6 = 1.0;
        double d7 = 1.0;
        double d8 = 0.2;
        double d9 = 0.075;
        double d10 = 0.225;
        double d11 = 0.9777777777777777;
        double d12 = -3.7333333333333334;
        double d13 = 3.5555555555555554;
        double d14 = 2.9525986892242035;
        double d15 = -11.595793324188385;
        double d16 = 9.822892851699436;
        double d17 = -0.2908093278463649;
        double d18 = 2.8462752525252526;
        double d19 = -10.757575757575758;
        double d20 = 8.906422717743473;
        double d21 = 0.2784090909090909;
        double d22 = -0.2735313036020583;
        double d23 = 0.09114583333333333;
        double d24 = 0.0;
        double d25 = 0.44923629829290207;
        double d26 = 0.6510416666666666;
        double d27 = -0.322376179245283;
        double d28 = 0.13095238095238096;
        double d29 = d23;
        double d30 = d24;
        double d31 = d25;
        double d32 = d26;
        double d33 = d27;
        double d34 = d28;
        double d35 = 0.0;
        double d36 = 0.0012326388888888888;
        double d37 = 0.0;
        double d38 = -0.0042527702905061394;
        double d39 = 0.03697916666666667;
        double d40 = -0.05086379716981132;
        double d41 = 0.0419047619047619;
        double d42 = -0.025;
        double[] dArray3 = this.derivs(this.t + d * this.h, this.y);
        int n = 0;
        while (n < this.n) {
            dArray[n] = this.y[n] + this.h * d8 * dArray3[n];
            ++n;
        }
        double[] dArray4 = this.derivs(this.t + d2 * this.h, dArray);
        n = 0;
        while (n < this.n) {
            dArray[n] = this.y[n] + this.h * (d9 * dArray3[n] + d10 * dArray4[n]);
            ++n;
        }
        double[] dArray5 = this.derivs(this.t + d3 * this.h, dArray);
        n = 0;
        while (n < this.n) {
            dArray[n] = this.y[n] + this.h * (d11 * dArray3[n] + d12 * dArray4[n] + d13 * dArray5[n]);
            ++n;
        }
        double[] dArray6 = this.derivs(this.t + d4 * this.h, dArray);
        n = 0;
        while (n < this.n) {
            dArray[n] = this.y[n] + this.h * (d14 * dArray3[n] + d15 * dArray4[n] + d16 * dArray5[n] + d17 * dArray6[n]);
            ++n;
        }
        double[] dArray7 = this.derivs(this.t + d5 * this.h, dArray);
        n = 0;
        while (n < this.n) {
            dArray[n] = this.y[n] + this.h * (d18 * dArray3[n] + d19 * dArray4[n] + d20 * dArray5[n] + d21 * dArray6[n] + d22 * dArray7[n]);
            ++n;
        }
        double[] dArray8 = this.derivs(this.t + d6 * this.h, dArray);
        n = 0;
        while (n < this.n) {
            dArray[n] = this.y[n] + this.h * (d23 * dArray3[n] + d24 * dArray4[n] + d25 * dArray5[n] + d26 * dArray6[n] + d27 * dArray7[n] + d28 * dArray8[n]);
            ++n;
        }
        double[] dArray9 = this.derivs(this.t + d7 * this.h, dArray);
        n = 0;
        while (n < this.n) {
            if (Double.isInfinite(dArray[n])) {
                throw new Exception("Overflow in ode-solver");
            }
            dArray2[n] = dArray[n];
            ++n;
        }
        this.steps[0] = dArray3;
        this.steps[1] = dArray4;
        this.steps[2] = dArray5;
        this.steps[3] = dArray6;
        this.steps[4] = dArray7;
        this.steps[5] = dArray8;
        this.steps[6] = dArray9;
        n = 0;
        while (n < this.n) {
            this.yerr[n] = this.h * (0.0012326388888888888 * dArray3[n] + 0.0 * dArray4[n] + -0.0042527702905061394 * dArray5[n] + 0.03697916666666667 * dArray6[n] + -0.05086379716981132 * dArray7[n] + 0.0419047619047619 * dArray8[n] + -0.025 * dArray9[n]);
            ++n;
        }
        this.estError = this.calcerr(this.y, dArray2, this.yerr);
        return dArray2;
    }

    protected double[] derivs(double d, double[] dArray) throws Exception {
        return this.f.getValue(dArray);
    }

    public class ODEReport {
        public int stepsforward;
        public int stepsbackward;
        public boolean toosmallstepforward = false;
        public boolean toosmallstepbackward = false;
        public boolean toomanystepsforward = false;
        public boolean toomanystepsbackward = false;
        public boolean integratedforward = false;
        public boolean integratedbackward = false;
        public boolean singularityforward = false;
        public boolean singularitybackward = false;
        public double timeforward;
        public double timebackward;
        public int stepsrepeatedforward;
        public int stepsrepeatedbackward;
        public boolean successforward = false;
        public boolean successbackward = false;
        public double maxstepsizeforward;
        public double minstepsizeforward;
        public double maxstepsizebackward;
        public double minstepsizebackward;
        public double[] valueforward;
        public double[] valuebackward;
    }

    public static abstract class Output {
        public abstract void out(double[] var1, double var2, double var4, boolean var6);
    }
}

