/*
 * Decompiled with CFR 0.152.
 */
package jaba.math;

import Jama.Matrix;
import jaba.math.Complex;
import jaba.math.Function;
import jaba.math.Nullspace;
import jaba.math.Vektor;

public class MathUtil {
    private MathUtil() {
    }

    public static double max(double[] dArray) {
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (dArray[n] > d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (dArray[n] < d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static double norm1(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += Math.abs(dArray[n]);
            ++n;
        }
        return d;
    }

    public static int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public static Complex getCriticalHopfEigenvalue(Complex[] complexArray) {
        int n = 0;
        double d = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < complexArray.length) {
            if (complexArray[n2].imag != 0.0 && !(complexArray[n2].imag < 0.0) && Math.abs(complexArray[n2].real) + 1.0 / Math.abs(complexArray[n2].imag) < d) {
                n = n2;
                d = complexArray[n2].real;
            }
            ++n2;
        }
        return complexArray[n];
    }

    public static Vektor[] getCriticalHopfEigenvector(Complex[] complexArray, Vektor[] vektorArray, Vektor[] vektorArray2) {
        int n = 0;
        double d = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < complexArray.length) {
            if (complexArray[n2].imag != 0.0 && !(complexArray[n2].imag < 0.0) && Math.abs(complexArray[n2].real) + 1.0 / Math.abs(complexArray[n2].imag) < d) {
                n = n2;
                d = complexArray[n2].real;
            }
            ++n2;
        }
        Vektor vektor = new Vektor(vektorArray[n]);
        Vektor vektor2 = new Vektor(vektorArray2[n]);
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < vektor.getLength()) {
            d2 += vektor.get(n3) * vektor.get(n3) + vektor2.get(n3) * vektor2.get(n3);
            ++n3;
        }
        vektor.timesEquals(1.0 / Math.sqrt(d2));
        vektor2.timesEquals(1.0 / Math.sqrt(d2));
        Vektor[] vektorArray3 = new Vektor[]{vektor, vektor2};
        return vektorArray3;
    }

    public static Vektor getTangent(Function function, Vektor vektor, boolean bl) {
        Matrix matrix = function.getJacobian(vektor);
        Vektor[] vektorArray = Nullspace.getNullSpace((Matrix)matrix, (int)0);
        int n = vektor.getLength();
        Vektor vektor2 = new Vektor(n);
        int n2 = bl ? 1 : -1;
        Vektor vektor3 = vektorArray[0];
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n - 1) {
            if (vektor3.get(n5) <= d) {
                d = vektor3.get(n5);
                n3 = n5;
            }
            if (vektor3.get(n5) >= d2) {
                d2 = vektor3.get(n5);
                n4 = n5;
            }
            ++n5;
        }
        if (n3 != n - 1) {
            vektor2.set(n - 1, n2);
        } else {
            vektor2.set(n4, n2);
        }
        return vektor2;
    }
}

