/*
 * Decompiled with CFR 0.152.
 */
package jaba.math;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import jaba.math.Complex;
import jaba.math.Settings;
import jaba.math.Vektor;

public abstract class Function {
    protected int n;
    protected int p;
    protected int m;

    public Function() {
    }

    public Function(int n, int n2, int n3) {
        this.m = n3;
        this.p = n2;
        this.n = n;
    }

    public int getParamDim() {
        return this.p;
    }

    public int getNumberVars() {
        return this.n + this.p;
    }

    public int getNumberFunctions() {
        return this.m;
    }

    public boolean getValue(Vektor vektor, Vektor vektor2) {
        double[] dArray = this.getValue(vektor.getRowPackedCopy());
        if (dArray == null) {
            return false;
        }
        vektor2.setVektor(new Vektor(dArray));
        return true;
    }

    public abstract double[] getValue(double[] var1);

    public Vektor getValue(Vektor vektor) {
        Vektor vektor2 = new Vektor(this.m);
        if (this.getValue(vektor, vektor2)) {
            return vektor2;
        }
        return null;
    }

    public boolean getJacobian(Vektor vektor, Matrix matrix) {
        if (vektor.getLength() != this.n + this.p) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        if (matrix.m != this.m || matrix.n != this.n + this.p) {
            throw new IllegalArgumentException("Matrix has wrong dim.");
        }
        Vektor vektor2 = new Vektor(vektor);
        double d = Math.pow(Settings.getMachinePrecision(), 0.3333333333333333);
        int n = 0;
        while (n < this.n + this.p) {
            double d2 = vektor2.get(n);
            vektor2.set(n, d2 + d);
            Vektor vektor3 = this.getValue(vektor2);
            vektor2.set(n, d2 - d);
            Vektor vektor4 = this.getValue(vektor2);
            vektor2.set(n, d2);
            Matrix matrix2 = vektor3.minus(vektor4);
            matrix2.timesEquals(1.0 / (2.0 * d));
            matrix.setMatrix(0, this.m - 1, n, n, matrix2);
            ++n;
        }
        return true;
    }

    public Matrix getJacobianState(Vektor vektor) {
        Matrix matrix = this.getJacobian(vektor);
        return matrix.getMatrix(0, this.m - 1, 0, this.n - 1);
    }

    public Matrix getJacobianParam(Vektor vektor) {
        Matrix matrix = this.getJacobian(vektor);
        return matrix.getMatrix(0, this.m - 1, this.n, this.n + this.p - 1);
    }

    public Matrix getJacobian(Vektor vektor) {
        if (vektor.getLength() != this.n + this.p) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        Matrix matrix = new Matrix(this.m, this.n + this.p);
        this.getJacobian(vektor, matrix);
        return matrix;
    }

    public double[][][] getDerivation2(Vektor vektor) {
        if (vektor.getLength() != this.n + this.p) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        double d = Math.sqrt(Math.sqrt(Settings.getMachinePrecision()));
        double[][][] dArray = new double[this.m][this.n + this.p][this.n + this.p];
        Vektor vektor2 = new Vektor(vektor);
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n + this.p) {
                int n3 = 0;
                while (n3 < this.n + this.p) {
                    Vektor vektor3;
                    Vektor vektor4;
                    Vektor vektor5;
                    if (n2 == n3) {
                        double d2 = vektor.get(n2);
                        vektor5 = this.getValue(vektor2);
                        vektor2.set(n2, d2 + d);
                        vektor4 = this.getValue(vektor2);
                        vektor2.set(n2, d2 - d);
                        vektor3 = this.getValue(vektor2);
                        vektor2.set(n2, d2);
                        dArray[n][n2][n3] = (vektor4.get(n) - 2.0 * vektor5.get(n) + vektor3.get(n)) / (d * d);
                    } else {
                        double d3 = vektor.get(n2);
                        double d4 = vektor.get(n3);
                        vektor2.set(n2, d3 + d);
                        vektor2.set(n3, d4 + d);
                        vektor4 = this.getValue(vektor2);
                        vektor2.set(n2, d3 + d);
                        vektor2.set(n3, d4 - d);
                        vektor3 = this.getValue(vektor2);
                        vektor2.set(n2, d3 - d);
                        vektor2.set(n3, d4 + d);
                        vektor5 = this.getValue(vektor2);
                        vektor2.set(n2, d3 - d);
                        vektor2.set(n3, d4 - d);
                        Vektor vektor6 = this.getValue(vektor2);
                        vektor2.set(n2, d3);
                        vektor2.set(n3, d4);
                        dArray[n][n2][n3] = (vektor4.get(n) - vektor3.get(n) - vektor5.get(n) + vektor6.get(n)) / (4.0 * d * d);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public Vektor getDerivation2(Vektor vektor, Vektor vektor2, Vektor vektor3) {
        if (this.n + this.p != vektor.getLength() || this.n + this.p != vektor2.getLength() || this.n + this.p != vektor3.getLength()) {
            throw new IllegalArgumentException("Dim. does not match");
        }
        double[][][] dArray = this.getDerivation2(vektor);
        Vektor vektor4 = new Vektor(this.m);
        double d = 0.0;
        int n = 0;
        while (n < this.m) {
            d = 0.0;
            int n2 = 0;
            while (n2 < this.n + this.p) {
                int n3 = 0;
                while (n3 < this.n + this.p) {
                    d += dArray[n][n2][n3] * vektor2.get(n2) * vektor3.get(n3);
                    ++n3;
                }
                ++n2;
            }
            vektor4.set(n, d);
            ++n;
        }
        return vektor4;
    }

    public Complex[] getEigenvalues(Vektor vektor) {
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(this.getJacobianState(vektor));
        return eigenvalueDecomposition.getEigenvals();
    }
}

