/*
 * Decompiled with CFR 0.152.
 */
package ds.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import uibk.draw2d.base.MathPanel2D;
import uibk.draw2d.base.Scene2D;
import uibk.geom.CoordinateRect2D;
import uibk.swing.JButtonNoFocus;

public class JPanelScale2D
extends JPanel
implements ActionListener {
    ButtonGroup groupAxesOpt = new ButtonGroup();
    JRadioButton jRadioAxesEqual;
    JRadioButton jRadioAxesIndependent;
    JButtonNoFocus jButtonBothZoomIn;
    JButtonNoFocus jButtonBothZoomOut;
    JButtonNoFocus jButtonXZoomIn;
    JButtonNoFocus jButtonXZoomOut;
    JButtonNoFocus jButtonYZoomIn;
    JButtonNoFocus jButtonYZoomOut;
    MathPanel2D mathpanel2d;
    JApplet applet;
    private String strtitle = "Scaling";
    private String strindependently = "Independently";
    private String strequal = "Together";
    double originalxmin;
    double originalxmax;
    double originalymin;
    double originalymax;
    public static final int SCALE_TOGETHER = 0;
    public static final int SCALE_INDEPENDENT = 1;
    int mode = 0;
    private double scalefactor = 1.2;

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        if (n == 0) {
            this.jButtonXZoomIn.setEnabled(false);
            this.jButtonXZoomOut.setEnabled(false);
            this.jButtonYZoomIn.setEnabled(false);
            this.jButtonYZoomOut.setEnabled(false);
            this.jButtonBothZoomIn.setEnabled(true);
            this.jButtonBothZoomOut.setEnabled(true);
            this.jRadioAxesEqual.setSelected(true);
            this.mode = n;
        }
        if (n == 1) {
            this.jButtonXZoomIn.setEnabled(true);
            this.jButtonXZoomOut.setEnabled(true);
            this.jButtonYZoomIn.setEnabled(true);
            this.jButtonYZoomOut.setEnabled(true);
            this.jButtonBothZoomIn.setEnabled(false);
            this.jButtonBothZoomOut.setEnabled(false);
            this.jRadioAxesIndependent.setSelected(true);
            this.mode = n;
        }
    }

    public void setScaleFactor(double d) {
        this.scalefactor = d;
    }

    protected CoordinateRect2D calcRescaledLimits(double d) {
        CoordinateRect2D coordinateRect2D = this.calcRescaledLimitsX(d);
        CoordinateRect2D coordinateRect2D2 = this.calcRescaledLimitsY(d);
        return new CoordinateRect2D(coordinateRect2D.xmin, coordinateRect2D.xmax, coordinateRect2D2.ymin, coordinateRect2D2.ymax);
    }

    protected CoordinateRect2D calcRescaledLimitsX(double d) {
        Scene2D scene2D = this.mathpanel2d.getScene2d();
        double d2 = scene2D.getXmin();
        double d3 = scene2D.getXmax();
        double d4 = scene2D.getYmin();
        double d5 = scene2D.getYmax();
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        int n = scene2D.getArea();
        if (n == 1 || n == 6 || n == 4) {
            d7 = d2 + scene2D.getXRange() * d;
        }
        if (n == 2 || n == 8 || n == 5) {
            d7 = scene2D.getXmax() * d;
            d6 = scene2D.getXmin() * d;
        }
        if (n == 0 || n == 7 || n == 3) {
            d6 = d3 - scene2D.getXRange() * d;
        }
        return new CoordinateRect2D(d6, d7, d8, d9);
    }

    protected CoordinateRect2D calcRescaledLimitsY(double d) {
        Scene2D scene2D = this.mathpanel2d.getScene2d();
        double d2 = scene2D.getXmin();
        double d3 = scene2D.getXmax();
        double d4 = scene2D.getYmin();
        double d5 = scene2D.getYmax();
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        int n = scene2D.getArea();
        if (n == 1 || n == 2 || n == 0) {
            d9 = d4 + scene2D.getYRange() * d;
        }
        if (n == 7 || n == 8 || n == 6) {
            d9 = scene2D.getYmax() * d;
            d8 = scene2D.getYmin() * d;
        }
        if (n == 4 || n == 5 || n == 3) {
            d8 = d5 - scene2D.getYRange() * d;
        }
        return new CoordinateRect2D(d6, d7, d8, d9);
    }

    void checkUpperLimitsAndSet(CoordinateRect2D coordinateRect2D) {
        if (coordinateRect2D.xmax < this.originalxmax || coordinateRect2D.xmin > this.originalxmin || coordinateRect2D.ymax < this.originalymax || coordinateRect2D.ymin > this.originalymin) {
            this.mathpanel2d.getScene2d().setLimits(this.originalxmin, this.originalxmax, this.originalymin, this.originalymax);
        } else {
            this.mathpanel2d.getScene2d().setLimits(coordinateRect2D);
        }
    }

    void rescale(double d) {
        CoordinateRect2D coordinateRect2D = this.calcRescaledLimits(d);
        if (coordinateRect2D.xmax < this.originalxmax || coordinateRect2D.xmin > this.originalxmin || coordinateRect2D.ymax < this.originalymax || coordinateRect2D.ymin > this.originalymin) {
            this.mathpanel2d.getScene2d().setLimits(this.originalxmin, this.originalxmax, this.originalymin, this.originalymax);
            this.mathpanel2d.getScene2d().equalizeCoords();
        } else {
            this.mathpanel2d.getScene2d().setLimits(coordinateRect2D);
        }
    }

    void rescaleX(double d) {
        CoordinateRect2D coordinateRect2D = this.calcRescaledLimitsX(d);
        if (coordinateRect2D.xmax < this.originalxmax || coordinateRect2D.xmin > this.originalxmin) {
            coordinateRect2D.xmin = this.originalxmin;
            coordinateRect2D.xmax = this.originalxmax;
            this.mathpanel2d.getScene2d().setLimits(coordinateRect2D);
        } else {
            this.mathpanel2d.getScene2d().setLimits(coordinateRect2D);
        }
    }

    void rescaleY(double d) {
        CoordinateRect2D coordinateRect2D = this.calcRescaledLimitsY(d);
        if (coordinateRect2D.ymax < this.originalymax || coordinateRect2D.ymin > this.originalymin) {
            coordinateRect2D.ymin = this.originalymin;
            coordinateRect2D.ymax = this.originalymax;
            this.mathpanel2d.getScene2d().setLimits(coordinateRect2D);
        } else {
            this.mathpanel2d.getScene2d().setLimits(coordinateRect2D);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.jButtonXZoomIn.setEnabled(false);
            this.jButtonXZoomOut.setEnabled(false);
            this.jButtonYZoomIn.setEnabled(false);
            this.jButtonYZoomOut.setEnabled(false);
            this.jButtonBothZoomIn.setEnabled(false);
            this.jButtonBothZoomOut.setEnabled(false);
            this.jRadioAxesIndependent.setEnabled(false);
            this.jRadioAxesEqual.setEnabled(false);
        } else {
            this.jRadioAxesIndependent.setEnabled(true);
            this.jRadioAxesEqual.setEnabled(true);
            this.setMode(this.mode);
        }
    }

    public void updateCoords(CoordinateRect2D coordinateRect2D) {
        this.originalxmin = coordinateRect2D.xmin;
        this.originalxmax = coordinateRect2D.xmax;
        this.originalymin = coordinateRect2D.ymin;
        this.originalymax = coordinateRect2D.ymax;
        this.jRadioAxesEqual.setSelected(true);
        this.jRadioAxesIndependent.setSelected(false);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.jRadioAxesEqual != null) {
            this.jRadioAxesEqual.setBackground(color);
        }
        if (this.jRadioAxesIndependent != null) {
            this.jRadioAxesIndependent.setBackground(color);
        }
        if (this.jButtonBothZoomIn != null) {
            this.jButtonBothZoomIn.setBackground(color);
        }
        if (this.jButtonBothZoomOut != null) {
            this.jButtonBothZoomOut.setBackground(color);
        }
        if (this.jButtonXZoomIn != null) {
            this.jButtonXZoomIn.setBackground(color);
        }
        if (this.jButtonXZoomOut != null) {
            this.jButtonXZoomOut.setBackground(color);
        }
        if (this.jButtonYZoomIn != null) {
            this.jButtonYZoomIn.setBackground(color);
        }
        if (this.jButtonYZoomOut != null) {
            this.jButtonYZoomOut.setBackground(color);
        }
    }

    public JPanelScale2D(JApplet jApplet, MathPanel2D mathPanel2D) {
        this.mathpanel2d = mathPanel2D;
        this.applet = jApplet;
        this.initComponents();
    }

    void initComponents() {
        this.originalxmin = this.mathpanel2d.getScene2d().getXmin();
        this.originalymin = this.mathpanel2d.getScene2d().getYmin();
        this.originalxmax = this.mathpanel2d.getScene2d().getXmax();
        this.originalxmax = this.mathpanel2d.getScene2d().getXmax();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.strtitle);
        titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1));
        this.setBorder(titledBorder);
        this.setLayout(new GridBagLayout());
        this.jRadioAxesIndependent = new JRadioButton(this.strindependently, false);
        this.jRadioAxesEqual = new JRadioButton(this.strequal, true);
        this.jRadioAxesEqual.setActionCommand("axes_equal");
        this.jRadioAxesIndependent.setActionCommand("axes_independent");
        this.jRadioAxesEqual.addActionListener(this);
        this.jRadioAxesIndependent.addActionListener(this);
        this.groupAxesOpt.add(this.jRadioAxesEqual);
        this.groupAxesOpt.add(this.jRadioAxesIndependent);
        this.jRadioAxesEqual.setSelected(true);
        URL uRL = this.getClass().getResource("res/plus.gif");
        URL uRL2 = this.getClass().getResource("res/minus.gif");
        this.jButtonBothZoomIn = new JButtonNoFocus(new ImageIcon(uRL));
        this.jButtonBothZoomOut = new JButtonNoFocus(new ImageIcon(uRL2));
        this.jButtonBothZoomIn.setActionCommand("bothzoomin");
        this.jButtonBothZoomOut.setActionCommand("bothzoomout");
        this.jButtonXZoomIn = new JButtonNoFocus(new ImageIcon(uRL));
        this.jButtonXZoomOut = new JButtonNoFocus(new ImageIcon(uRL2));
        this.jButtonXZoomIn.setActionCommand("xzoomin");
        this.jButtonXZoomOut.setActionCommand("xzoomout");
        this.jButtonYZoomIn = new JButtonNoFocus(new ImageIcon(uRL));
        this.jButtonYZoomOut = new JButtonNoFocus(new ImageIcon(uRL2));
        this.jButtonYZoomIn.setActionCommand("yzoomin");
        this.jButtonYZoomOut.setActionCommand("yzoomout");
        this.jButtonBothZoomIn.setBorder(null);
        this.jButtonBothZoomOut.setBorder(null);
        this.jButtonXZoomIn.setBorder(null);
        this.jButtonXZoomOut.setBorder(null);
        this.jButtonYZoomIn.setBorder(null);
        this.jButtonYZoomOut.setBorder(null);
        this.jButtonBothZoomIn.addActionListener(this);
        this.jButtonBothZoomOut.addActionListener(this);
        this.jButtonXZoomIn.addActionListener(this);
        this.jButtonXZoomOut.addActionListener(this);
        this.jButtonYZoomIn.addActionListener(this);
        this.jButtonYZoomOut.addActionListener(this);
        this.setMode(0);
        this.add((Component)this.jRadioAxesEqual, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jButtonBothZoomOut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jButtonBothZoomIn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.jButtonYZoomIn, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
        this.add((Component)this.jRadioAxesIndependent, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jButtonXZoomOut, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jButtonXZoomIn, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.jButtonYZoomOut, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("bothzoomout")) {
            this.rescale(this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (actionEvent.getActionCommand().equals("xzoomout")) {
            this.rescaleX(this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (actionEvent.getActionCommand().equals("yzoomout")) {
            this.rescaleY(this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (actionEvent.getActionCommand().equals("bothzoomin")) {
            this.rescale(1.0 / this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (actionEvent.getActionCommand().equals("xzoomin")) {
            this.rescaleX(1.0 / this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (actionEvent.getActionCommand().equals("yzoomin")) {
            this.rescaleY(1.0 / this.scalefactor);
            this.mathpanel2d.repaint();
        }
        if (actionEvent.getActionCommand().equals("axes_equal")) {
            this.mathpanel2d.getScene2d().setLimits(this.originalxmin, this.originalxmax, this.originalymin, this.originalymax);
            this.mathpanel2d.getScene2d().equalizeCoords();
            this.setMode(0);
            this.mathpanel2d.repaint();
        }
        if (actionEvent.getActionCommand().equals("axes_independent")) {
            this.setMode(1);
            this.mathpanel2d.getScene2d().setLimits(this.originalxmin, this.originalxmax, this.originalymin, this.originalymax);
            this.mathpanel2d.repaint();
        }
    }
}

