/*
 * Decompiled with CFR 0.152.
 */
package ds.swing;

import ds.lang.Options;
import ds.parsing.UtilParser;
import jaba.math.ODESolver;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JPanelODESolverOptions
extends JPanel
implements ActionListener {
    JTextField jTxtEps;
    JTextField jTxtH;
    JTextField jTxtMaxIterations;
    JCheckBox jCheckDenseOutput;
    JCheckBox jCheckStepControl;
    ODESolver odesolver;
    JLabel report;
    private int minsteps = 1;
    private int maxsteps = 50000;

    public JPanelODESolverOptions(JLabel jLabel, ODESolver oDESolver) {
        this.report = jLabel;
        this.odesolver = oDESolver;
        this.initComponents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("applychanges")) {
            double d;
            int n = 0;
            try {
                n = Integer.parseInt(this.jTxtMaxIterations.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.report.setText("<html><font color=red>Entered max. number of steps is not a natural number<font>");
                return;
            }
            if (n < this.minsteps || n > this.maxsteps) {
                this.report.setText("<html><font color=red>Entered max. number of steps must be between " + this.minsteps + " and " + this.maxsteps + "+<font>");
                return;
            }
            this.odesolver.enableDenseOutput(this.jCheckDenseOutput.isSelected());
            this.odesolver.enabelStepSizeControl(this.jCheckStepControl.isSelected());
            if (this.jCheckStepControl.isSelected()) {
                d = 0.0;
                try {
                    d = UtilParser.parseConstantExpr(this.jTxtEps.getText());
                }
                catch (Exception exception) {
                    this.report.setText("<html><font color=red>Entered accuracy is not a positive real number<font>");
                    return;
                }
                if (d <= 0.0) {
                    this.report.setText("<html><font color=red>Entered accuracy is not a positive real number<font>");
                    return;
                }
                this.odesolver.setTOL(d);
            }
            d = 0.0;
            try {
                d = UtilParser.parseConstantExpr(this.jTxtH.getText());
            }
            catch (Exception exception) {
                this.report.setText("<html><font color=red>Entered stepsize is not a positive real number<font>");
                return;
            }
            if (d <= 0.0) {
                this.report.setText("<html><font color=red>Entered stepsize is not a positive real number<font>");
                return;
            }
            this.odesolver.setInitialStepsize(d);
            this.odesolver.setMaxSteps(n);
            this.report.setText("<html><font color=green>Options set<font>");
        }
        if (actionEvent.getActionCommand().equals("checkstep")) {
            this.jTxtEps.setEnabled(this.jCheckStepControl.isSelected());
        }
    }

    void initGeneralPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Options.componentsColor);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("General options");
        titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridBagLayout());
        this.jTxtMaxIterations = new JTextField(String.valueOf(this.odesolver.getMaxSteps()));
        this.jTxtMaxIterations.setPreferredSize(new Dimension(80, 20));
        this.jTxtMaxIterations.setMaximumSize(new Dimension(80, 20));
        this.jTxtMaxIterations.setMinimumSize(new Dimension(80, 20));
        this.jCheckDenseOutput = new JCheckBox("Dense-Output");
        this.jCheckDenseOutput.setSelected(this.odesolver.isDenseOutputEnabled());
        this.jCheckDenseOutput.setBackground(Options.componentsColor);
        jPanel.add((Component)new JLabel("Max. steps:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.jTxtMaxIterations, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.jCheckDenseOutput, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(jPanel);
    }

    void initStepsizePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Options.componentsColor);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Step size options");
        titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridBagLayout());
        this.jCheckStepControl = new JCheckBox("step-size control");
        this.jCheckStepControl.setSelected(this.odesolver.isStepSizeControlEnabled());
        this.jCheckStepControl.setBackground(Options.componentsColor);
        this.jCheckStepControl.setActionCommand("checkstep");
        this.jCheckStepControl.addActionListener(this);
        this.jTxtEps = new JTextField(String.valueOf(this.odesolver.getTOL()));
        this.jTxtEps.setPreferredSize(new Dimension(80, 20));
        this.jTxtEps.setMaximumSize(new Dimension(80, 20));
        this.jTxtEps.setMinimumSize(new Dimension(80, 20));
        this.jTxtH = new JTextField(String.valueOf(this.odesolver.getInitialStepsize()));
        this.jTxtH.setPreferredSize(new Dimension(80, 20));
        this.jTxtH.setMaximumSize(new Dimension(80, 20));
        this.jTxtH.setMinimumSize(new Dimension(80, 20));
        jPanel.add((Component)new JLabel("(Initial) stepsize:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.jTxtH, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.jCheckStepControl, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Local error"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 0, 0), 0, 0));
        jPanel.add((Component)this.jTxtEps, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(jPanel);
    }

    void initApplyButton() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Options.componentsColor);
        JButton jButton = new JButton(" set ");
        jButton.setBackground(Options.componentsColor);
        jButton.setActionCommand("applychanges");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.setBackground(Options.componentsColor);
        this.add(jPanel);
    }

    void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.initGeneralPanel();
        this.initStepsizePanel();
        this.initApplyButton();
    }
}

