/*
 * Decompiled with CFR 0.152.
 */
package ds.parsing;

import bacon.parser.Expr;
import bacon.parser.Parser;
import bacon.parser.Variable;
import ds.math.ParsedFunction;
import ds.math.VectorField2D;
import jaba.math.Interval;
import jaba.math.Vektor;
import java.util.StringTokenizer;
import uibk.geom.CoordinateRect2D;

public class UtilParser {
    static Parser parser = new Parser();

    public static void parseVectorfield(VectorField2D vectorField2D, String string, String string2, String string3, String string4) throws Exception {
        parser.clearVariables();
        Variable[] variableArray = new Variable[]{new Variable(string), new Variable(string2)};
        parser.addVariable(variableArray[0]);
        parser.addVariable(variableArray[1]);
        Expr[] exprArray = new Expr[2];
        if (string3 == null || string3.equals("")) {
            throw new Exception("1. component of the vectorfield is not defined");
        }
        if (string4 == null || string4.equals("")) {
            throw new Exception("2. component of the vectorfield is not defined");
        }
        try {
            exprArray[0] = parser.parseString(string3);
        }
        catch (Exception exception) {
            throw new Exception("Error in 1. component " + string3 + ": " + exception.getMessage());
        }
        try {
            exprArray[1] = parser.parseString(string4);
        }
        catch (Exception exception) {
            throw new Exception("Error in 2. component " + string4 + ": " + exception.getMessage());
        }
        ParsedFunction parsedFunction = new ParsedFunction(variableArray, exprArray);
        vectorField2D.setFunction(parsedFunction);
    }

    public static void parseFunction(ParsedFunction parsedFunction, String string, String string2, String string3) throws Exception {
        String[] stringArray = UtilParser.split(string, ",");
        String[] stringArray2 = UtilParser.split(string2, ",");
        String[] stringArray3 = UtilParser.split(string3, "\n");
        UtilParser.parseFunction(parsedFunction, stringArray, stringArray2, stringArray3);
    }

    public static void parseFunction(ParsedFunction parsedFunction, String[] stringArray, String[] stringArray2, String[] stringArray3) throws Exception {
        Expr[] exprArray;
        parser.clearVariables();
        int n = stringArray.length;
        int n2 = stringArray2.length;
        Variable[] variableArray = new Variable[n];
        int n3 = 0;
        while (n3 < n) {
            Variable variable;
            variableArray[n3] = variable = new Variable(stringArray[n3]);
            parser.addVariable(variable);
            ++n3;
        }
        Variable[] variableArray2 = new Variable[n2];
        int n4 = 0;
        while (n4 < n2) {
            variableArray2[n4] = exprArray = new Variable(stringArray2[n4]);
            parser.addVariable((Variable)exprArray);
            ++n4;
        }
        n4 = stringArray3.length;
        exprArray = new Expr[n4];
        int n5 = 0;
        while (n5 < n4) {
            if (stringArray3[n5] == null || stringArray3[n5].equals("")) {
                throw new Exception(String.valueOf(n5 + 1) + ". component of function not definied");
            }
            exprArray[n5] = parser.parseString(stringArray3[n5]);
            ++n5;
        }
        parsedFunction.setFunction(exprArray);
        parsedFunction.setStateVariables(variableArray);
        parsedFunction.setVariables(variableArray2);
    }

    public static Vektor parseVektor(String string) throws Exception {
        double[] dArray = UtilParser.parseBracketInitalValues(string);
        return new Vektor(dArray);
    }

    public static double parseConstantExpr(String string) throws Exception {
        Expr expr = parser.parseString(string);
        return expr.value();
    }

    public static Interval parseIntervall(String string, String string2, boolean bl) throws Exception {
        double d;
        double d2;
        if (string2 == null) {
            string2 = "";
        }
        if (string == null || string.equals("")) {
            throw new Exception(String.valueOf(string2) + ": no interval defined");
        }
        if (!(string = string.trim()).startsWith("[")) {
            throw new Exception(String.valueOf(string2) + ": interval has to begin with \"[\" ");
        }
        if (!string.endsWith("]")) {
            throw new Exception(String.valueOf(string2) + ": interval has to end with \"[\" ");
        }
        int n = string.indexOf(",");
        if (n < 0) {
            throw new Exception(String.valueOf(string2) + ": interval must be of the form  [start,end]");
        }
        try {
            d2 = UtilParser.parseConstantExpr(string.substring(1, n));
        }
        catch (Exception exception) {
            throw new Exception(String.valueOf(string2) + ": interval lower bound is no real number");
        }
        try {
            d = UtilParser.parseConstantExpr(string.substring(n + 1, string.length() - 1));
        }
        catch (Exception exception) {
            throw new Exception(String.valueOf(string2) + ": interval upper bound is no real number");
        }
        if (bl) {
            if (d <= d2) {
                throw new Exception(String.valueOf(string2) + ": interval upper bound must be greater than interval lower bound");
            }
        } else if (d < d2) {
            throw new Exception(String.valueOf(string2) + ": interval upper bound must be greater-equal than interval lower bound");
        }
        Interval interval = new Interval(d2, d);
        return interval;
    }

    public static double[] parseInitalValues(String string) throws Exception {
        if ((string = string.trim()).charAt(0) == ',' || string.charAt(string.length() - 1) == ',' || string.indexOf(",,") >= 0) {
            throw new Exception("Error in initial values. The initial values must be entered like 3,2,1,.. ");
        }
        String[] stringArray = UtilParser.split(string, ",");
        if (string == null || stringArray.length == 0) {
            return null;
        }
        double[] dArray = new double[stringArray.length];
        int n = 0;
        while (n < dArray.length) {
            try {
                dArray[n] = UtilParser.parseConstantExpr(stringArray[n]);
            }
            catch (Exception exception) {
                throw new Exception("Error in initial values. The initial values must be entered like 3,2,1,.. ");
            }
            ++n;
        }
        return dArray;
    }

    public static double[] parseBracketInitalValues(String string) throws Exception {
        if (string == null || string.equals("")) {
            throw new Exception("No initial value specified");
        }
        if (string.charAt(0) != '(' || string.charAt(string.length() - 1) != ')') {
            try {
                double[] dArray = new double[]{UtilParser.parseConstantExpr(string)};
                return dArray;
            }
            catch (Exception exception) {
                throw new Exception("Initial values error");
            }
        }
        string = string.substring(1, string.length() - 1);
        return UtilParser.parseInitalValues(string);
    }

    public static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static double parseValue(String string, String string2, Double d, Double d2, Boolean bl) throws Exception {
        double d3 = 0.0;
        if (string == null || string.equals("")) {
            throw new Exception("You have not entered a " + string2);
        }
        try {
            d3 = UtilParser.parseConstantExpr(string);
        }
        catch (Exception exception) {
            throw new Exception("Entered " + string2 + " is not a real number");
        }
        if (bl != null && bl.booleanValue() && d3 <= 0.0) {
            throw new Exception("Entered " + string2 + " must be positive");
        }
        if (bl != null && !bl.booleanValue() && d3 >= 0.0) {
            throw new Exception("Entered " + string2 + " must be negative");
        }
        if (d2 != null && d3 > d2) {
            throw new Exception("Entered " + string2 + " must be less or equal than " + d2);
        }
        if (d != null && d3 < d) {
            throw new Exception("Entered " + string2 + " must be greater or equal than " + d);
        }
        return d3;
    }

    public static CoordinateRect2D parseRectArea(String string, String string2, String string3, String string4) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (string == null || string.equals("")) {
            throw new Exception("xmin is not defined");
        }
        if (string2 == null || string2.equals("")) {
            throw new Exception("xmax is not defined");
        }
        if (string3 == null || string3.equals("")) {
            throw new Exception("ymin is not defined");
        }
        if (string4 == null || string4.equals("")) {
            throw new Exception("ymax is not defined");
        }
        try {
            d = UtilParser.parseConstantExpr(string);
        }
        catch (Exception exception) {
            throw new Exception("Error in xmin:" + exception.getMessage());
        }
        try {
            d2 = UtilParser.parseConstantExpr(string2);
        }
        catch (Exception exception) {
            throw new Exception("Error in xmax:" + exception.getMessage());
        }
        try {
            d3 = UtilParser.parseConstantExpr(string3);
        }
        catch (Exception exception) {
            throw new Exception("Error in ymin:" + exception.getMessage());
        }
        try {
            d4 = UtilParser.parseConstantExpr(string4);
        }
        catch (Exception exception) {
            throw new Exception("Error in ymax:" + exception.getMessage());
        }
        if (d2 <= d) {
            throw new Exception("xmax must be greater than xmin");
        }
        if (d4 <= d3) {
            throw new Exception("ymax must be greater than ymin");
        }
        return new CoordinateRect2D(d, d2, d3, d4);
    }
}

