/*
 * Decompiled with CFR 0.152.
 */
package ds.math;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import bacon.parser.Expr;
import bacon.parser.Variable;
import jaba.math.Complex;
import jaba.math.Function;
import jaba.math.Settings;
import jaba.math.Vektor;
import java.util.Hashtable;

public class ParsedFunction
extends Function {
    Hashtable parameters = new Hashtable();
    Variable[] statevariables;
    Expr[] functions;
    String[] paramnames;
    protected int n;
    protected int activeparams;
    protected int p;
    protected int m;

    public ParsedFunction() {
    }

    public int getParamDim() {
        return this.activeparams;
    }

    public void setParameterValue(String string, double d) {
        Parameter parameter = (Parameter)this.parameters.get(string);
        if (parameter == null) {
            throw new IllegalArgumentException("No such Parameter");
        }
        parameter.parameter.setValue(d);
    }

    public double getParameterValue(String string) {
        Parameter parameter = (Parameter)this.parameters.get(string);
        if (parameter == null) {
            throw new IllegalArgumentException("No such Parameter");
        }
        return parameter.parameter.value();
    }

    public void setEnabledParameter(String string, boolean bl) {
        Parameter parameter = (Parameter)this.parameters.get(string);
        if (parameter == null) {
            throw new IllegalArgumentException("No such Parameter");
        }
        if (parameter.active != bl) {
            parameter.active = bl;
            this.activeparams = !bl ? --this.activeparams : ++this.activeparams;
        }
    }

    public ParsedFunction(Variable[] variableArray, Expr[] exprArray) {
        this.setFunction(exprArray);
        this.setVariables(variableArray);
    }

    public void setFunction(Expr[] exprArray) {
        this.functions = exprArray;
        this.m = exprArray.length;
    }

    public void setVariables(Variable[] variableArray) {
        this.p = variableArray.length;
        this.paramnames = new String[this.p];
        int n = 0;
        while (n < this.p) {
            this.paramnames[n] = variableArray[n].toString();
            this.parameters.put(variableArray[n].toString(), new Parameter(variableArray[n], true));
            ++n;
        }
        this.activeparams = this.p;
    }

    public void setStateVariables(Variable[] variableArray) {
        this.statevariables = variableArray;
        this.n = variableArray.length;
    }

    public int getNumberVars() {
        return this.n + this.activeparams;
    }

    public int getNumberFunctions() {
        return this.m;
    }

    public boolean getValue(Vektor vektor, Vektor vektor2) {
        if (vektor.getLength() != this.n + this.activeparams) {
            throw new IllegalArgumentException("Dim does not match");
        }
        if (vektor2.getLength() != this.m) {
            throw new IllegalArgumentException("Dim does not match");
        }
        int n = 0;
        while (n < this.n) {
            this.statevariables[n].setValue(vektor.get(n));
            ++n;
        }
        if (this.activeparams > 0) {
            n = this.n;
            int n2 = 0;
            while (n2 < this.p) {
                Parameter parameter = (Parameter)this.parameters.get(this.paramnames[n2]);
                if (parameter.active) {
                    parameter.parameter.setValue(vektor.get(n));
                    ++n;
                }
                ++n2;
            }
        }
        n = 0;
        while (n < this.m) {
            vektor2.set(n, this.functions[n].value());
            ++n;
        }
        return true;
    }

    public double[] getValue(double[] dArray) {
        if (dArray.length != this.n + this.activeparams) {
            throw new IllegalArgumentException("Dim does not match");
        }
        double[] dArray2 = new double[this.m];
        int n = 0;
        while (n < this.n) {
            this.statevariables[n].setValue(dArray[n]);
            ++n;
        }
        if (this.activeparams > 0) {
            n = this.n;
            int n2 = 0;
            while (n2 < this.p) {
                Parameter parameter = (Parameter)this.parameters.get(this.paramnames[n2]);
                if (parameter.active) {
                    parameter.parameter.setValue(dArray[n]);
                    ++n;
                }
                ++n2;
            }
        }
        n = 0;
        while (n < this.m) {
            dArray2[n] = this.functions[n].value();
            ++n;
        }
        return dArray2;
    }

    public Vektor getValue(Vektor vektor) {
        Vektor vektor2 = new Vektor(this.m);
        if (this.getValue(vektor, vektor2)) {
            return vektor2;
        }
        return null;
    }

    public boolean getJacobian(Vektor vektor, Matrix matrix) {
        if (vektor.getLength() != this.n + this.activeparams) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        if (matrix.m != this.m || matrix.n != this.n + this.activeparams) {
            throw new IllegalArgumentException("Matrix has wrong dim.");
        }
        Vektor vektor2 = new Vektor(vektor);
        double d = Math.pow(Settings.getMachinePrecision(), 0.3333333333333333);
        int n = 0;
        while (n < this.n + this.activeparams) {
            double d2 = vektor2.get(n);
            vektor2.set(n, d2 + d);
            Vektor vektor3 = this.getValue(vektor2);
            vektor2.set(n, d2 - d);
            Vektor vektor4 = this.getValue(vektor2);
            vektor2.set(n, d2);
            Matrix matrix2 = vektor3.minus(vektor4);
            matrix2.timesEquals(1.0 / (2.0 * d));
            matrix.setMatrix(0, this.m - 1, n, n, matrix2);
            ++n;
        }
        return true;
    }

    public Matrix getJacobianState(Vektor vektor) {
        Matrix matrix = this.getJacobian(vektor);
        return matrix.getMatrix(0, this.m - 1, 0, this.n - 1);
    }

    public Matrix getJacobianParam(Vektor vektor) {
        Matrix matrix = this.getJacobian(vektor);
        return matrix.getMatrix(0, this.m - 1, this.n, this.n + this.activeparams - 1);
    }

    public Matrix getJacobian(Vektor vektor) {
        if (vektor.getLength() != this.n + this.activeparams) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        Matrix matrix = new Matrix(this.m, this.n + this.activeparams);
        this.getJacobian(vektor, matrix);
        return matrix;
    }

    public double[][][] getDerivation2(Vektor vektor) {
        if (vektor.getLength() != this.n + this.activeparams) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        double d = Math.sqrt(Math.sqrt(Settings.getMachinePrecision()));
        double[][][] dArray = new double[this.m][this.n + this.activeparams][this.n + this.activeparams];
        Vektor vektor2 = new Vektor(vektor);
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n + this.activeparams) {
                int n3 = 0;
                while (n3 < this.n + this.activeparams) {
                    Vektor vektor3;
                    Vektor vektor4;
                    Vektor vektor5;
                    if (n2 == n3) {
                        double d2 = vektor.get(n2);
                        vektor5 = this.getValue(vektor2);
                        vektor2.set(n2, d2 + d);
                        vektor4 = this.getValue(vektor2);
                        vektor2.set(n2, d2 - d);
                        vektor3 = this.getValue(vektor2);
                        vektor2.set(n2, d2);
                        dArray[n][n2][n3] = (vektor4.get(n) - 2.0 * vektor5.get(n) + vektor3.get(n)) / (d * d);
                    } else {
                        double d3 = vektor.get(n2);
                        double d4 = vektor.get(n3);
                        vektor2.set(n2, d3 + d);
                        vektor2.set(n3, d4 + d);
                        vektor4 = this.getValue(vektor2);
                        vektor2.set(n2, d3 + d);
                        vektor2.set(n3, d4 - d);
                        vektor3 = this.getValue(vektor2);
                        vektor2.set(n2, d3 - d);
                        vektor2.set(n3, d4 + d);
                        vektor5 = this.getValue(vektor2);
                        vektor2.set(n2, d3 - d);
                        vektor2.set(n3, d4 - d);
                        Vektor vektor6 = this.getValue(vektor2);
                        vektor2.set(n2, d3);
                        vektor2.set(n3, d4);
                        dArray[n][n2][n3] = (vektor4.get(n) - vektor3.get(n) - vektor5.get(n) + vektor6.get(n)) / (4.0 * d * d);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public Vektor getDerivation2(Vektor vektor, Vektor vektor2, Vektor vektor3) {
        if (this.n + this.activeparams != vektor.getLength() || this.n + this.activeparams != vektor2.getLength() || this.n + this.activeparams != vektor3.getLength()) {
            throw new IllegalArgumentException("Dim. does not match");
        }
        double[][][] dArray = this.getDerivation2(vektor);
        Vektor vektor4 = new Vektor(this.m);
        double d = 0.0;
        int n = 0;
        while (n < this.m) {
            d = 0.0;
            int n2 = 0;
            while (n2 < this.n + this.activeparams) {
                int n3 = 0;
                while (n3 < this.n + this.activeparams) {
                    d += dArray[n][n2][n3] * vektor2.get(n2) * vektor3.get(n3);
                    ++n3;
                }
                ++n2;
            }
            vektor4.set(n, d);
            ++n;
        }
        return vektor4;
    }

    public String toString() {
        String string = new String();
        int n = 0;
        while (n < this.m) {
            string = String.valueOf(string) + this.functions.toString() + "\n";
            ++n;
        }
        return string;
    }

    public Complex[] getEigenvalues(Vektor vektor) {
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(this.getJacobianState(vektor));
        return eigenvalueDecomposition.getEigenvals();
    }

    class Parameter {
        Variable parameter;
        boolean active;

        Parameter(Variable variable, boolean bl) {
            this.parameter = variable;
            this.active = bl;
        }
    }
}

