/*
 * Decompiled with CFR 0.152.
 */
package ds.draw2d;

import ds.math.VectorField2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.draw2d.base.Drawable2D;
import uibk.draw2d.objects.MathArrow2D;
import uibk.geom.CoordinateRect2D;
import uibk.geom.Punkt2D;
import uibk.lang.PrepaintComputable;
import uibk.util.Grid2D;

public class GraphVectorField2D
extends Drawable2D
implements PrepaintComputable {
    int gridx;
    int gridy;
    String strGridX = "10";
    String strGridY = "10";
    VectorField2D vectorfield2d;
    Vector arrows = new Vector();
    public static final int ARROWS_SAME_LENGTH = 0;
    public static final int ARROWS_SCALED_LENGTH = 1;
    private int mode = 0;
    double vectorfield_xmin = -1.0;
    double vectorfield_xmax = 1.0;
    double vectorfield_ymin = -1.0;
    double vectorfield_ymax = -1.0;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    CoordinateRect2D limits;

    public GraphVectorField2D(VectorField2D vectorField2D) {
        this.vectorfield2d = vectorField2D;
        this.vectorfield_xmin = -1.0;
        this.vectorfield_xmax = 1.0;
        this.vectorfield_ymin = -1.0;
        this.vectorfield_ymax = 1.0;
        this.xmin = this.vectorfield_xmin;
        this.xmax = this.vectorfield_xmax;
        this.ymin = this.vectorfield_ymin;
        this.ymax = this.vectorfield_ymax;
        this.color = Color.red;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setGrid(String string, String string2) throws Exception {
        this.strGridX = string;
        this.strGridY = string2;
        try {
            this.gridx = Integer.valueOf(string);
        }
        catch (Exception exception) {
            throw new Exception("GridX ist keine nat\u00fcrliche Zahl");
        }
        try {
            this.gridy = Integer.valueOf(string2);
        }
        catch (Exception exception) {
            throw new Exception("GridY ist keine nat\u00fcrliche Zahl");
        }
    }

    public void setColor(Color color) {
        this.color = color;
        int n = 0;
        while (n < this.arrows.size()) {
            ((MathArrow2D)this.arrows.elementAt(n)).setColor(color);
            ++n;
        }
    }

    public void setLimits(String string, String string2, String string3, String string4) throws Exception {
        try {
            this.vectorfield_xmin = Double.valueOf(string);
        }
        catch (Exception exception) {
            throw new Exception("xmin is no real number");
        }
        try {
            this.vectorfield_xmax = Double.valueOf(string2);
        }
        catch (Exception exception) {
            throw new Exception("xmax is no real number");
        }
        try {
            this.vectorfield_ymin = Double.valueOf(string3);
        }
        catch (Exception exception) {
            throw new Exception("ymin is no real number");
        }
        try {
            this.vectorfield_ymax = Double.valueOf(string4);
        }
        catch (Exception exception) {
            throw new Exception("ymax is no real number");
        }
        this.xmin = this.vectorfield_xmin;
        this.xmax = this.vectorfield_xmax;
        this.ymin = this.vectorfield_xmin;
        this.ymax = this.vectorfield_xmax;
    }

    protected void addArrow(Punkt2D punkt2D, Punkt2D punkt2D2, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = (this.vectorfield_xmax - this.vectorfield_xmin) / (double)(this.gridx + this.gridx / 10);
        double d7 = (this.vectorfield_ymax - this.vectorfield_ymin) / (double)(this.gridy + this.gridy / 10);
        double d8 = Math.min(d6, d7);
        double d9 = Math.sqrt(punkt2D2.x * punkt2D2.x + punkt2D2.y * punkt2D2.y);
        Punkt2D punkt2D3 = new Punkt2D(punkt2D2.x / d9, punkt2D2.y / d9);
        if (this.mode == 0) {
            d5 = punkt2D.x - punkt2D3.x / 2.0 * d8;
            d4 = punkt2D.y - punkt2D3.y / 2.0 * d8;
            d3 = punkt2D.x + punkt2D3.x / 2.0 * d8;
            d2 = punkt2D.y + punkt2D3.y / 2.0 * d8;
        } else {
            d5 = punkt2D.x - punkt2D3.x / 2.0 * d9 / d * d8;
            d4 = punkt2D.y - punkt2D3.y / 2.0 * d9 / d * d8;
            d3 = punkt2D.x + punkt2D3.x / 2.0 * d9 / d * d8;
            d2 = punkt2D.y + punkt2D3.y / 2.0 * d9 / d * d8;
        }
        if (Double.isNaN(d5) || Double.isInfinite(d5) || Double.isNaN(d4) || Double.isInfinite(d4) || Double.isNaN(d3) || Double.isInfinite(d3) || Double.isNaN(d2) || Double.isInfinite(d2) || d5 == d3 && d4 == d2) {
            return;
        }
        MathArrow2D mathArrow2D = new MathArrow2D(new Punkt2D(d5, d4), new Punkt2D(d3, d2));
        mathArrow2D.setColor(this.color);
        mathArrow2D.setMathPanel2d(this.panel);
        if (mathArrow2D.getHead().x < this.xmin) {
            this.xmin = mathArrow2D.getHead().x;
        }
        if (mathArrow2D.getHead().x > this.xmax) {
            this.xmax = mathArrow2D.getHead().x;
        }
        if (mathArrow2D.getHead().y < this.ymin) {
            this.ymin = mathArrow2D.getHead().y;
        }
        if (mathArrow2D.getHead().y > this.ymax) {
            this.ymax = mathArrow2D.getHead().y;
        }
        if (mathArrow2D.getBase().x < this.xmin) {
            this.xmin = mathArrow2D.getBase().x;
        }
        if (mathArrow2D.getBase().x > this.xmax) {
            this.xmax = mathArrow2D.getBase().x;
        }
        if (mathArrow2D.getBase().y < this.ymin) {
            this.ymin = mathArrow2D.getBase().y;
        }
        if (mathArrow2D.getBase().y > this.ymax) {
            this.ymax = mathArrow2D.getBase().y;
        }
        this.arrows.add(mathArrow2D);
    }

    public void prepaintcompute() throws Exception {
        int n = 0;
        while (n < this.arrows.size()) {
            try {
                ((MathArrow2D)this.arrows.elementAt(n)).prepaintcompute();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public void compute() throws Exception {
        Punkt2D punkt2D;
        int n;
        this.xmin = this.vectorfield_xmin;
        this.xmax = this.vectorfield_xmax;
        this.ymin = this.vectorfield_ymin;
        this.ymax = this.vectorfield_ymax;
        if (this.xmin >= this.xmax) {
            throw new Exception("Error: xmin must be less than xmax");
        }
        if (this.ymin >= this.ymax) {
            throw new Exception("Error: ymin must be less than ymax");
        }
        this.arrows.clear();
        Punkt2D[][] punkt2DArray = Grid2D.createGrid2D(this.vectorfield_xmin, this.vectorfield_xmax, this.vectorfield_ymin, this.vectorfield_ymax, this.gridx, this.gridy);
        if (punkt2DArray == null) {
            throw new Exception("Could not create Grid");
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < punkt2DArray.length) {
            n = 0;
            while (n < punkt2DArray.length) {
                punkt2D = punkt2DArray[n2][n];
                Punkt2D punkt2D2 = this.vectorfield2d.velocityVectorAt(punkt2D);
                double d2 = punkt2D2.quadnorm();
                if (d2 > d) {
                    d = d2;
                }
                ++n;
            }
            ++n2;
        }
        d = Math.sqrt(d);
        n2 = 0;
        while (n2 < punkt2DArray.length) {
            n = 0;
            while (n < punkt2DArray.length) {
                punkt2D = punkt2DArray[n2][n];
                this.addArrow(punkt2D, this.vectorfield2d.velocityVectorAt(punkt2D), d);
                ++n;
            }
            ++n2;
        }
        this.scene2d.setLimits(this.xmin, this.xmax, this.ymin, this.ymax);
        this.scene2d.coordsChanged();
    }

    public void draw(BufferedImage bufferedImage, Graphics2D graphics2D) {
        int n = 0;
        while (n < this.arrows.size()) {
            MathArrow2D mathArrow2D = (MathArrow2D)this.arrows.elementAt(n);
            mathArrow2D.draw(bufferedImage, graphics2D);
            ++n;
        }
    }
}

