/*
 * Decompiled with CFR 0.152.
 */
package ds.applets.periodic2d;

import ds.applets.periodic2d.AppletPeriodic2D;
import ds.lang.Options;
import ds.parsing.UtilParser;
import ds.text.LCOutputReport;
import jaba.limitcylce.LimitCycleLocator;
import jaba.math.Function;
import jaba.math.Interval;
import jaba.math.Vektor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import uibk.draw2d.objects.Graph2D;
import uibk.geom.Punkt2D;

class JPanelSearchLC
extends JPanel
implements ActionListener {
    JTextField jTxTPeriod;
    JTextField jTxtY;
    JTextField jTxtEps;
    JButton jButtonCalc;
    JSlider jSliderGridPoints = new JSlider();
    JLabel jLabelGrid;
    ButtonGroup groupVectorfieldOpt;
    AppletPeriodic2D main;
    Vektor y;
    double period;
    double eps;

    private boolean setFunction() {
        try {
            String[] stringArray = new String[]{this.main.panelvectorfield.jTxtKomponenteX.getText(), this.main.panelvectorfield.jTxtKomponenteY.getText()};
            UtilParser.parseFunction(this.main.f, this.main.vars, this.main.params, stringArray);
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError("Error in function: " + exception.getMessage());
            return false;
        }
        return true;
    }

    private boolean getPeriod() {
        if (this.jTxTPeriod.getText() == null || this.jTxTPeriod.getText().equals("")) {
            this.main.mathpanel2d.reportError("No initial period entered");
            return false;
        }
        try {
            this.period = UtilParser.parseConstantExpr(this.jTxTPeriod.getText());
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError("Error in initial period: " + exception.getMessage());
            return false;
        }
        return true;
    }

    private boolean getEps() {
        if (this.jTxTPeriod.getText() == null || this.jTxTPeriod.getText().equals("")) {
            this.main.mathpanel2d.reportError("No accuracy entered");
            return false;
        }
        try {
            this.eps = UtilParser.parseConstantExpr(this.jTxtEps.getText());
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError("Error in accuracy" + exception.getMessage());
            return false;
        }
        return true;
    }

    private boolean getInitialY() {
        try {
            double[] dArray = UtilParser.parseBracketInitalValues(this.jTxtY.getText());
            this.y = new Vektor(dArray);
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError("Fehler bei Y: " + exception.getMessage());
            return false;
        }
        return true;
    }

    private boolean parsefunction() {
        String[] stringArray = new String[]{this.main.panelvectorfield.jTxtKomponenteX.getText(), this.main.panelvectorfield.jTxtKomponenteY.getText()};
        String[] stringArray2 = new String[]{"x", "y"};
        try {
            UtilParser.parseFunction(this.main.f, this.main.vars, this.main.params, stringArray);
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError("Fehler beim Vektorfeld: " + exception.getMessage());
            return false;
        }
        return true;
    }

    private void drawOrbit(Vektor vektor, double d) {
        this.main.odesolver.setDGL(this.main.f);
        this.main.odesolver.setIntegrationInvervall(new Interval(0.0, d));
        this.main.odesolver.setInitialCondition(0.0, vektor.getRowPackedCopy());
        Vector vector = null;
        try {
            vector = this.main.odesolver.solve(null);
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError("Could not draw the periodic orbit");
            return;
        }
        Graph2D graph2D = new Graph2D();
        int n = 0;
        while (n < vector.size()) {
            double[] dArray = (double[])vector.elementAt(n);
            graph2D.addPoint(new Punkt2D(dArray[0], dArray[1]));
            ++n;
        }
        graph2D.recalcLimits();
        this.main.mathpanel2d.getScene2d().setLimits(graph2D.getLimits());
        this.main.mathpanel2d.getScene2d().roundCoords(20, 1);
        this.main.graphflow.clear();
        this.main.graphvectorfield.setVisible(false);
        this.main.panelaxes.updateCoords(graph2D.getLimits());
        this.main.panelaxes.setEnabled(true);
        this.main.calcSolFromClick = false;
        this.main.graphflow.addGraph(graph2D);
        this.main.mathpanel2d.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("computelimitcycle")) {
            boolean bl = false;
            if (this.setFunction() && this.parsefunction() && this.getInitialY() && this.getPeriod() && this.getEps()) {
                this.main.limitcyclelocator.setTOL(this.eps);
                this.main.limitcyclelocator.setFunction((Function)this.main.f);
                try {
                    bl = this.main.limitcyclelocator.compute(this.y, this.period, null);
                }
                catch (Exception exception) {
                    this.main.mathpanel2d.reportError(exception.getMessage());
                    String string = LCOutputReport.getHTMLReport((LimitCycleLocator.LCReport)this.main.limitcyclelocator.getReport());
                    this.main.outputpanel.setOutput(string);
                    return;
                }
                if (bl) {
                    this.main.mathpanel2d.report("Periodic orbit: point: " + this.main.limitcyclelocator.getPoint() + ", period: " + this.main.limitcyclelocator.getPeriod());
                    this.drawOrbit(this.main.limitcyclelocator.getPoint(), this.main.limitcyclelocator.getPeriod());
                } else {
                    this.main.mathpanel2d.report("<html><font color=red>Could not compute periodic orbit</font>");
                }
                String string = LCOutputReport.getHTMLReport((LimitCycleLocator.LCReport)this.main.limitcyclelocator.getReport());
                this.main.outputpanel.setOutput(string);
            }
        }
    }

    public JPanelSearchLC(AppletPeriodic2D appletPeriodic2D) {
        this.main = appletPeriodic2D;
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(Options.componentsColor);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Compute limit cycle");
        titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1));
        this.setBorder(titledBorder);
        this.setLayout(new GridBagLayout());
        this.jTxTPeriod = new JTextField();
        this.jTxtY = new JTextField();
        this.jTxtEps = new JTextField("1E-8");
        this.jTxTPeriod.setPreferredSize(new Dimension(40, 20));
        this.jTxtY.setPreferredSize(new Dimension(80, 20));
        this.jTxTPeriod.setMinimumSize(new Dimension(40, 20));
        this.jTxtY.setMinimumSize(new Dimension(80, 20));
        this.jTxtEps.setMinimumSize(new Dimension(80, 20));
        this.jTxtEps.setPreferredSize(new Dimension(80, 20));
        this.jButtonCalc = new JButton("Compute");
        this.jButtonCalc.setActionCommand("computelimitcycle");
        this.jButtonCalc.addActionListener(this);
        this.jButtonCalc.setBackground(Options.componentsColor);
        this.setBackground(Options.componentsColor);
        this.jSliderGridPoints.setBackground(Options.componentsColor);
        this.jSliderGridPoints.setMinimum(2);
        this.jSliderGridPoints.setMaximum(40);
        this.jSliderGridPoints.setValue(25);
        this.add((Component)new JLabel("Period guess"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jTxTPeriod, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("Point guess"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTxtY, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("Accuracy:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTxtEps, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.jButtonCalc, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(25, 0, 0, 0), 0, 0));
    }
}

