/*
 * Decompiled with CFR 0.152.
 */
package ds.applets.periodic2d;

import ds.applets.periodic2d.AppletPeriodic2D;
import ds.lang.Options;
import ds.parsing.UtilParser;
import ds.text.ODEOutputReport;
import jaba.math.Interval;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import uibk.draw2d.objects.Graph2D;
import uibk.geom.Punkt2D;

class JPanelDefineIVP
extends JPanel
implements ActionListener {
    AppletPeriodic2D main;
    JTextField jTxtInitialCondtion;
    JTextField jTxtIntervall;
    JButton jButtonCalc;
    JComboBox JComboBoxExamples;
    JCheckBox jCheckAdd;
    JCheckBox jCheckNoAdd;
    ButtonGroup groupOpt = new ButtonGroup();
    final int GRAPH_ADDTOVECTORFIELD = 0;
    final int GRAPH_SINGLE = 1;
    int mode = 1;
    double[] initials;
    Interval interval;

    private boolean setInitials() {
        try {
            this.initials = UtilParser.parseBracketInitalValues(this.jTxtInitialCondtion.getText());
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError(exception.getMessage());
            return false;
        }
        if (this.initials.length != 2) {
            this.main.mathpanel2d.reportError("Dimension of initial vector must be 2");
            return false;
        }
        return true;
    }

    private boolean setInterval() {
        try {
            this.interval = UtilParser.parseIntervall(this.jTxtIntervall.getText(), "Integration interval", true);
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError(exception.getMessage());
            return false;
        }
        return true;
    }

    private boolean setFunction() {
        try {
            String[] stringArray = new String[]{this.main.panelvectorfield.jTxtKomponenteX.getText(), this.main.panelvectorfield.jTxtKomponenteY.getText()};
            UtilParser.parseFunction(this.main.f, this.main.vars, this.main.params, stringArray);
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError("Error in function: " + exception.getMessage());
            return false;
        }
        return true;
    }

    private void addGraph(Vector vector) {
        if (vector == null) {
            return;
        }
        Vector<Punkt2D> vector2 = new Vector<Punkt2D>();
        Graph2D graph2D = new Graph2D();
        if (vector.size() > 1) {
            int n = 0;
            while (n < vector.size()) {
                double[] dArray = (double[])vector.elementAt(n);
                vector2.add(new Punkt2D(dArray[0], dArray[1]));
                ++n;
            }
            graph2D.setPoints(vector2);
            graph2D.setColor(Color.blue);
            graph2D.setVisible(true);
            if (this.mode == 0) {
                this.main.graphflow.addGraph(graph2D);
                this.main.graphvectorfield.setVisible(true);
            } else {
                this.main.graphflow.clear();
                this.main.graphflow.addGraph(graph2D);
                this.main.mathpanel2d.getScene2d().setLimits(graph2D.getLimits());
                this.main.mathpanel2d.getScene2d().roundCoords(20, 1);
                this.main.graphvectorfield.setVisible(false);
                this.main.panelaxes.setEnabled(true);
                this.main.panelaxes.updateCoords(this.main.mathpanel2d.getScene2d().getCoordinates());
                this.main.panelaxes.setMode(1);
                this.main.calcSolFromClick = false;
            }
        }
    }

    void solveDGL() {
        if (this.mode == 0 && !this.main.graphvectorfield.getVisible()) {
            this.main.mathpanel2d.reportError("Cannot add graph to vectorfield, because no vectorfield has been drawn");
            return;
        }
        Vector vector = null;
        if (this.setFunction() && this.setInitials() && this.setInterval()) {
            this.main.odesolver.setDGL(this.main.f);
            this.main.odesolver.setInitialCondition(0.0, this.initials);
            this.main.odesolver.setIntegrationInvervall(this.interval);
            try {
                vector = this.main.odesolver.solve(null);
            }
            catch (Exception exception) {
                this.main.mathpanel2d.reportError(exception.getMessage());
                return;
            }
            this.addGraph(vector);
            this.main.mathpanel2d.repaint();
            if (this.main.odesolver.integrationSuccess()) {
                this.main.mathpanel2d.reportSuccess("Integration successful");
            } else {
                this.main.mathpanel2d.reportError("Integration not successful (see Output for more info)");
            }
            String string = ODEOutputReport.getHTMLReport(this.main.odesolver.getReport());
            this.main.outputpanel.setOutput(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("solve_autonnom_dgl")) {
            this.solveDGL();
        }
        if (actionEvent.getActionCommand().equals("addtovectorfield")) {
            this.mode = 0;
        }
        if (actionEvent.getActionCommand().equals("dontaddtovectorfield")) {
            this.mode = this.GRAPH_SINGLE;
        }
    }

    public JPanelDefineIVP(AppletPeriodic2D appletPeriodic2D) {
        this.main = appletPeriodic2D;
        this.initComponents();
    }

    void initPanelSolve() {
        JPanel jPanel = new JPanel();
        this.setBackground(Options.componentsColor);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Initial value problem");
        titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Options.componentsColor);
        this.setLayout(new BoxLayout(this, 1));
        this.jTxtInitialCondtion = new JTextField();
        this.jTxtIntervall = new JTextField();
        this.jTxtInitialCondtion.setPreferredSize(new Dimension(80, 20));
        this.jTxtInitialCondtion.setMaximumSize(new Dimension(80, 20));
        this.jTxtIntervall.setPreferredSize(new Dimension(80, 20));
        this.jTxtIntervall.setMaximumSize(new Dimension(80, 20));
        this.jButtonCalc = new JButton("Solve");
        this.jButtonCalc.setActionCommand("solve_autonnom_dgl");
        this.jButtonCalc.addActionListener(this);
        this.jButtonCalc.setBackground(Options.componentsColor);
        this.setBackground(Options.componentsColor);
        jPanel.add((Component)new JLabel("(x(0),y(0))="), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.jTxtInitialCondtion, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Interval:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.jTxtIntervall, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.jButtonCalc, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(jPanel);
    }

    void initPanelOptions() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Drawing Option");
        titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Options.componentsColor);
        this.jCheckAdd = new JCheckBox("add to vector field");
        this.jCheckNoAdd = new JCheckBox("draw alone");
        this.jCheckNoAdd.setActionCommand("dontaddtovectorfield");
        this.jCheckNoAdd.addActionListener(this);
        this.jCheckAdd.setActionCommand("addtovectorfield");
        this.jCheckAdd.addActionListener(this);
        this.groupOpt.add(this.jCheckAdd);
        this.groupOpt.add(this.jCheckNoAdd);
        this.jCheckAdd.setBackground(Options.componentsColor);
        this.jCheckNoAdd.setBackground(Options.componentsColor);
        this.jCheckNoAdd.setSelected(true);
        jPanel.add((Component)this.jCheckAdd, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.jCheckNoAdd, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(jPanel);
    }

    void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.initPanelSolve();
        this.initPanelOptions();
    }
}

