/*
 * Decompiled with CFR 0.152.
 */
package ds.applets.periodic2d;

import ds.applets.periodic2d.JPanelDefineIVP;
import ds.applets.periodic2d.JPanelSearchLC;
import ds.applets.periodic2d.JPanelVectorField;
import ds.draw2d.GraphVectorField2D;
import ds.lang.Options;
import ds.math.ParsedFunction;
import ds.math.VectorField2D;
import ds.parsing.UtilParser;
import ds.swing.JNavigationBar;
import ds.swing.JOutputPanel;
import ds.swing.JPanelAxes2DStyle;
import ds.swing.JPanelLoadExample;
import ds.swing.JPanelODESolverOptions;
import ds.swing.JPanelScale2D;
import ds.text.ODEOutputReport;
import jaba.limitcylce.LimitCycleLocator;
import jaba.math.Interval;
import jaba.math.ODESolver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.text.JTextComponent;
import uibk.draw2d.axes2d.Axes2D;
import uibk.draw2d.base.MathPanel2D;
import uibk.draw2d.objects.GraphSplitter2D;
import uibk.draw2d.objects.MultiGraph2D;
import uibk.swing.JAppletFrame;

public class AppletPeriodic2D
extends JApplet {
    boolean calcSolFromClick = false;
    protected boolean isStandalone = false;
    protected MathPanel2D mathpanel2d = new MathPanel2D();
    VectorField2D vectorfield2d;
    MultiGraph2D graphflow;
    GraphVectorField2D graphvectorfield;
    JOutputPanel outputpanel;
    ParsedFunction f = new ParsedFunction();
    JLabel reports;
    protected boolean addlimitcyclelocator = true;
    JPanelSearchLC panelsearch;
    JPanelVectorField panelvectorfield;
    JPanelDefineIVP panelsolvedglAutonom;
    JPanelScale2D panelaxes;
    Axes2D axes2d;
    LimitCycleLocator limitcyclelocator;
    final String[] vars = new String[]{"x", "y"};
    final String[] params = new String[0];
    ODESolver odesolver = new ODESolver();
    int width = 255;

    public void init() {
        if (this.addlimitcyclelocator) {
            this.limitcyclelocator = new LimitCycleLocator();
            this.limitcyclelocator.setVariationalTOL(1.0E-8);
        }
        Options.setLookAndFeel();
        this.initComponents();
    }

    private void initComponents() {
        this.reports = new JLabel("Ready");
        this.axes2d = new Axes2D();
        this.vectorfield2d = new VectorField2D();
        this.graphvectorfield = new GraphVectorField2D(this.vectorfield2d);
        this.graphflow = new MultiGraph2D();
        this.graphvectorfield.setVisible(false);
        this.mathpanel2d.setReportingLabel(this.reports);
        this.mathpanel2d.addMouseListener(new MyMouseListener());
        this.mathpanel2d.addMouseMotionListener(new MyMouseMotionListener());
        this.mathpanel2d.add(this.axes2d);
        this.mathpanel2d.add(this.graphvectorfield);
        this.mathpanel2d.add(this.graphflow);
        this.outputpanel = new JOutputPanel();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(241, 241, 229));
        jPanel.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel.setLayout(new BorderLayout(5, 5));
        this.reports.setBorder(BorderFactory.createLoweredBevelBorder());
        JNavigationBar jNavigationBar = new JNavigationBar(this);
        jNavigationBar.setReportingLabel(this.reports);
        if (this.isStandalone) {
            jNavigationBar.enableInternetButtons(false);
        }
        JPanelCommand jPanelCommand = new JPanelCommand(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.green);
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)this.mathpanel2d, "Center");
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel2.setMinimumSize(new Dimension(100, 2000));
        jPanelCommand.setMinimumSize(new Dimension(250, 2000));
        JSplitPane jSplitPane = new JSplitPane(1, jPanel2, jPanelCommand);
        jSplitPane.setBorder(null);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setBackground(Options.backgroundColor);
        jSplitPane.setDividerLocation(400);
        jPanel.add((Component)jNavigationBar, "North");
        jPanel.add((Component)jSplitPane, "Center");
        jPanel.add((Component)this.reports, "South");
        this.getContentPane().add(jPanel);
    }

    public String getAppletInfo() {
        return "Periodic Orbits 2D";
    }

    public static void main(String[] stringArray) {
        AppletPeriodic2D appletPeriodic2D = new AppletPeriodic2D();
        appletPeriodic2D.isStandalone = true;
        JAppletFrame jAppletFrame = new JAppletFrame(appletPeriodic2D, 700, 650);
        jAppletFrame.setTitle("Periodic Orbits 2D");
    }

    class MyMouseMotionListener
    extends MouseMotionAdapter {
        MyMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (AppletPeriodic2D.this.calcSolFromClick && AppletPeriodic2D.this.mathpanel2d.isPointInCoordsArea(mouseEvent.getPoint())) {
                String string = "(" + AppletPeriodic2D.this.mathpanel2d.getScene2d().pixelToX(mouseEvent.getX()) + "," + AppletPeriodic2D.this.mathpanel2d.getScene2d().pixelToY(mouseEvent.getY()) + ")";
                AppletPeriodic2D.this.mathpanel2d.report(string);
            }
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && AppletPeriodic2D.this.calcSolFromClick && AppletPeriodic2D.this.mathpanel2d.isPointInCoordsArea(mouseEvent.getPoint())) {
                Vector vector = null;
                Vector vector2 = new Vector();
                String[] stringArray = new String[]{AppletPeriodic2D.this.panelvectorfield.jTxtKomponenteX.getText(), AppletPeriodic2D.this.panelvectorfield.jTxtKomponenteY.getText()};
                try {
                    UtilParser.parseFunction(AppletPeriodic2D.this.f, AppletPeriodic2D.this.vars, AppletPeriodic2D.this.params, stringArray);
                }
                catch (Exception exception) {
                    AppletPeriodic2D.this.mathpanel2d.reportError(exception.getMessage());
                }
                AppletPeriodic2D.this.odesolver.setDGL(AppletPeriodic2D.this.f);
                double d = Math.max(AppletPeriodic2D.this.mathpanel2d.getScene2d().getXRange(), AppletPeriodic2D.this.mathpanel2d.getScene2d().getYRange()) * 10.0;
                AppletPeriodic2D.this.odesolver.setIntegrationInvervall(new Interval(-d, d));
                double[] dArray = new double[]{AppletPeriodic2D.this.mathpanel2d.getScene2d().pixelToX(mouseEvent.getX()), AppletPeriodic2D.this.mathpanel2d.getScene2d().pixelToY(mouseEvent.getY())};
                AppletPeriodic2D.this.odesolver.setInitialCondition(0.0, dArray);
                try {
                    vector = AppletPeriodic2D.this.odesolver.solve(null);
                }
                catch (Exception exception) {
                    AppletPeriodic2D.this.mathpanel2d.reportError(exception.getMessage());
                    return;
                }
                GraphSplitter2D.splitgraphs(vector, AppletPeriodic2D.this.graphflow, AppletPeriodic2D.this.mathpanel2d.getScene2d().getCoordinates());
                AppletPeriodic2D.this.panelaxes.setEnabled(false);
                AppletPeriodic2D.this.graphvectorfield.setColor(new Color(255, 0, 0, 100));
                AppletPeriodic2D.this.mathpanel2d.report("Orbit drawn");
                AppletPeriodic2D.this.mathpanel2d.repaint();
                String string = ODEOutputReport.getHTMLReport(AppletPeriodic2D.this.odesolver.getReport());
                AppletPeriodic2D.this.outputpanel.setOutput(string);
            }
        }
    }

    class JPanelCommand
    extends JPanel {
        public JPanelCommand(AppletPeriodic2D appletPeriodic2D2) {
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            JPanel jPanel4 = new JPanel();
            JPanel jPanel5 = new JPanel();
            JPanel jPanel6 = new JPanel();
            jPanel.setBackground(Options.componentsColor);
            jPanel2.setBackground(Options.componentsColor);
            jPanel3.setBackground(Options.componentsColor);
            jPanel4.setBackground(Options.componentsColor);
            jPanel5.setBackground(Options.componentsColor);
            jPanel6.setBackground(Options.componentsColor);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            jPanel5.setLayout(new BoxLayout(jPanel5, 1));
            jPanel6.setLayout(new BoxLayout(jPanel6, 1));
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setBackground(Options.componentsColor);
            this.setPreferredSize(new Dimension(AppletPeriodic2D.this.width, 2000));
            this.setLayout(new BoxLayout(this, 1));
            AppletPeriodic2D.this.panelvectorfield = new JPanelVectorField(appletPeriodic2D2);
            AppletPeriodic2D.this.panelvectorfield.setMaximumSize(new Dimension(2000, 440));
            AppletPeriodic2D.this.panelsolvedglAutonom = new JPanelDefineIVP(appletPeriodic2D2);
            AppletPeriodic2D.this.panelsolvedglAutonom.setMaximumSize(new Dimension(2000, 240));
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.setPreferredSize(new Dimension(AppletPeriodic2D.this.width, 2000));
            jTabbedPane.setBackground(Options.componentsColor);
            AppletPeriodic2D.this.panelaxes = new JPanelScale2D(appletPeriodic2D2, AppletPeriodic2D.this.mathpanel2d);
            AppletPeriodic2D.this.panelaxes.setBackground(Options.componentsColor);
            AppletPeriodic2D.this.panelaxes.setEnabled(false);
            AppletPeriodic2D.this.panelaxes.setMaximumSize(new Dimension(2000, 240));
            JPanelODESolverOptions jPanelODESolverOptions = new JPanelODESolverOptions(AppletPeriodic2D.this.reports, AppletPeriodic2D.this.odesolver);
            jPanelODESolverOptions.setMaximumSize(new Dimension(2000, 220));
            JPanelAxes2DStyle jPanelAxes2DStyle = new JPanelAxes2DStyle(AppletPeriodic2D.this.axes2d, AppletPeriodic2D.this.mathpanel2d);
            AppletPeriodic2D.this.panelsearch = new JPanelSearchLC(appletPeriodic2D2);
            AppletPeriodic2D.this.panelsearch.setMaximumSize(new Dimension(2000, 200));
            if (AppletPeriodic2D.this.addlimitcyclelocator) {
                jPanel6.add(AppletPeriodic2D.this.panelsearch);
                jTabbedPane.addTab("Limit cylce", null, jPanel6, "Einstellungen zum L\u00f6sungsverfahren");
            }
            String[] stringArray = new String[]{"Van der Pol 1", "Example 2", "Brusselator", "Van der Pol 2"};
            JTextComponent[] jTextComponentArray = new JTextField[]{AppletPeriodic2D.this.panelvectorfield.jTxtKomponenteX, AppletPeriodic2D.this.panelvectorfield.jTxtKomponenteY, AppletPeriodic2D.this.panelvectorfield.jTxtXmin, AppletPeriodic2D.this.panelvectorfield.jTxtXmax, AppletPeriodic2D.this.panelvectorfield.jTxtYmin, AppletPeriodic2D.this.panelvectorfield.jTxtYmax, AppletPeriodic2D.this.panelsolvedglAutonom.jTxtInitialCondtion, AppletPeriodic2D.this.panelsolvedglAutonom.jTxtIntervall, AppletPeriodic2D.this.panelsearch.jTxTPeriod, AppletPeriodic2D.this.panelsearch.jTxtY};
            String[][] stringArray2 = new String[][]{{"2x - y - x^3", "x", "-5", "5", "-5", "5", "(2,2)", "[0,50]", "7", "(2,0)"}, {"3*(x+y-x^3/3-1)", "-(x-0.7+0.8y)/3", "-5", "5", "-5", "5", "(0,0)", "[0,10]", "10", "(0,0)"}, {"1+x(x*y-4)", "x*(3-x*y)", "-5", "5", "-5", "5", "(3,3)", "[0,7.3]", "7.3", "(3,3)"}, {"y", "(1-x*x)*y-x", "-4", "4", "-4", "4", "(0,1.5)", "[0,7]", "7", "(0,1.5)"}};
            MyLoadExample myLoadExample = new MyLoadExample("Examples", "Example", stringArray, jTextComponentArray, stringArray2);
            jPanel.add(myLoadExample);
            jPanel.add(AppletPeriodic2D.this.panelvectorfield);
            jPanel2.add(AppletPeriodic2D.this.panelsolvedglAutonom);
            jPanel3.add(AppletPeriodic2D.this.outputpanel);
            jPanel4.add(AppletPeriodic2D.this.panelaxes);
            jPanel4.add(jPanelAxes2DStyle);
            jPanel5.add(jPanelODESolverOptions);
            jTabbedPane.addTab("Vector field", null, jPanel, "Define the vector field");
            jTabbedPane.addTab("Define IVP", null, jPanel2, "Solve an initial value problem");
            jTabbedPane.addTab("Output", null, jPanel3, "Output");
            jTabbedPane.addTab("Axes", null, jPanel4, "Change look and scaling of the axes");
            jTabbedPane.addTab("Options", null, jPanel5, "Options of the ode solver");
            if (AppletPeriodic2D.this.addlimitcyclelocator) {
                jPanel6.add(AppletPeriodic2D.this.panelsearch);
                jTabbedPane.addTab("Limit cylce", null, jPanel6, "Compute a limit cycle");
            }
            this.add(jTabbedPane);
        }
    }

    class MyLoadExample
    extends JPanelLoadExample {
        public MyLoadExample(String string, String string2, String[] stringArray, JTextComponent[] jTextComponentArray, String[][] stringArray2) {
            super(string, string2, stringArray, jTextComponentArray, stringArray2);
        }

        protected void loadexample(String[] stringArray) {
            super.loadexample(stringArray);
            AppletPeriodic2D.this.mathpanel2d.getScene2d().setLimits(-1.0, 1.0, -1.0, 1.0);
            AppletPeriodic2D.this.graphvectorfield.setVisible(false);
            AppletPeriodic2D.this.graphflow.clear();
        }
    }
}

