/*
 * Decompiled with CFR 0.152.
 */
package bacon.parser;

import bacon.parser.Parser;
import bacon.parser.Scanner;
import bacon.parser.Token;

public class SyntaxException
extends Exception {
    public static final int INCOMPLETE = 0;
    public static final int BAD_FACTOR = 1;
    public static final int PREMATURE_EOF = 2;
    public static final int EXPECTED = 3;
    public static final int UNKNOWN_VARIABLE = 4;
    private Parser parser;
    private Scanner scanner;
    private int reason;
    private String expected;
    private String fixedInput = "";

    public SyntaxException(String string, Parser parser, int n, String string2) {
        super(string);
        this.reason = n;
        this.parser = parser;
        this.scanner = parser.tokens;
        this.expected = string2;
    }

    public String explain() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("I don't understand your formula ");
        this.quotify(stringBuffer, this.scanner.getInput());
        stringBuffer.append(".\n\n");
        this.explainWhere(stringBuffer);
        this.explainWhy(stringBuffer);
        this.explainWhat(stringBuffer);
        return stringBuffer.toString();
    }

    private void explainWhere(StringBuffer stringBuffer) {
        if (this.scanner.isEmpty()) {
            stringBuffer.append("It's empty!\n");
        } else if (this.scanner.atStart()) {
            stringBuffer.append("It starts with ");
            this.quotify(stringBuffer, this.theToken());
            if (this.isLegalToken()) {
                stringBuffer.append(", which can never be the start of a formula.\n");
            } else {
                stringBuffer.append(", which is a meaningless symbol to me.\n");
            }
        } else {
            stringBuffer.append("I got as far as ");
            this.quotify(stringBuffer, this.asFarAs());
            stringBuffer.append(" and then ");
            if (this.scanner.atEnd()) {
                stringBuffer.append("reached the end unexpectedly.\n");
            } else {
                stringBuffer.append("saw ");
                this.quotify(stringBuffer, this.theToken());
                if (this.isLegalToken()) {
                    stringBuffer.append(".\n");
                } else {
                    stringBuffer.append(", which is a meaningless symbol to me.\n");
                }
            }
        }
    }

    private void explainWhy(StringBuffer stringBuffer) {
        switch (this.reason) {
            case 0: {
                if (!this.isLegalToken()) break;
                stringBuffer.append("The first part makes sense, but I don't see how the rest connects to it.\n");
                break;
            }
            case 1: 
            case 2: {
                stringBuffer.append("I expected a value");
                if (!this.scanner.atStart()) {
                    stringBuffer.append(" to follow");
                }
                stringBuffer.append(", instead.\n");
                break;
            }
            case 3: {
                stringBuffer.append("I expected ");
                this.quotify(stringBuffer, this.expected);
                stringBuffer.append(" at that point, instead.\n");
                break;
            }
            case 4: {
                stringBuffer.append("That variable has no value.\n");
                break;
            }
            default: {
                throw new Error("Can't happen");
            }
        }
    }

    private void explainWhat(StringBuffer stringBuffer) {
        this.fixedInput = this.tryToFix();
        if (this.fixedInput != null) {
            stringBuffer.append("An example of a formula I can parse is ");
            this.quotify(stringBuffer, this.fixedInput);
            stringBuffer.append(".\n");
        }
    }

    private String tryToFix() {
        return this.parser.tryCorrections() ? this.scanner.toString() : null;
    }

    private void quotify(StringBuffer stringBuffer, String string) {
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
    }

    private String asFarAs() {
        Token token = this.scanner.getCurrentToken();
        int n = token.location - token.leadingWhitespace;
        return this.scanner.getInput().substring(0, n);
    }

    private String theToken() {
        return this.scanner.getCurrentToken().sval;
    }

    private boolean isLegalToken() {
        Token token = this.scanner.getCurrentToken();
        return token.ttype != -2 && token.ttype != -1;
    }
}

