/*
 * Decompiled with CFR 0.152.
 */
package bacon.parser;

import bacon.parser.Token;
import bacon.parser.Variable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Scanner {
    private String s;
    private String operatorChars;
    private Hashtable variables;
    Vector tokens = new Vector();
    int index = -1;

    public Scanner(String string, String string2, Hashtable hashtable) {
        this.s = string;
        this.variables = hashtable;
        this.operatorChars = String.valueOf(string2) + "()";
        int n = 0;
        while ((n = this.scanToken(n)) < this.s.length()) {
        }
        this.addAsterisk();
    }

    private boolean isVariable(Token token) {
        boolean bl = false;
        if (this.variables.size() > 0) {
            String string = null;
            Enumeration enumeration = this.variables.elements();
            while (enumeration.hasMoreElements()) {
                string = ((Variable)enumeration.nextElement()).toString();
                if (!token.sval.equals(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void addAsterisk() {
        int n = 0;
        while (n < this.tokens.size() - 1) {
            Token token = (Token)this.tokens.elementAt(n);
            Token token2 = (Token)this.tokens.elementAt(n + 1);
            if (token.ttype == -3 && (token2.ttype == 40 || token2.ttype == -4)) {
                this.tokens.add(n + 1, new Token(42, 0.0, "*", 0, 1));
            }
            if (token.ttype == 41 && (token2.ttype == 40 || token2.ttype == -4 || token2.ttype == -3)) {
                this.tokens.add(n + 1, new Token(42, 0.0, "*", 0, 1));
            }
            if (this.isVariable(token) && token2.ttype == 40) {
                this.tokens.add(n + 1, new Token(42, 0.0, "*", 0, 1));
            }
            ++n;
        }
    }

    public String getInput() {
        return this.s;
    }

    public String getOperatorChars() {
        return this.operatorChars;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n2 < this.tokens.size()) {
            int n3;
            Token token = (Token)this.tokens.elementAt(n2);
            int n4 = n3 = n != 0 ? n : token.leadingWhitespace;
            if (n2 == 0) {
                n3 = 0;
            } else if (n3 == 0 && !this.joinable((Token)this.tokens.elementAt(n2 - 1), token)) {
                n3 = 1;
            }
            int n5 = n3;
            while (n5 > 0) {
                stringBuffer.append(" ");
                --n5;
            }
            stringBuffer.append(token.sval);
            n = token.trailingWhitespace;
            ++n2;
        }
        return stringBuffer.toString();
    }

    private boolean joinable(Token token, Token token2) {
        return !this.isAlphanumeric(token) || !this.isAlphanumeric(token2);
    }

    private boolean isAlphanumeric(Token token) {
        return token.ttype == -4 || token.ttype == -3;
    }

    public boolean isEmpty() {
        return this.tokens.size() == 0;
    }

    public boolean atStart() {
        return this.index <= 0;
    }

    public boolean atEnd() {
        return this.tokens.size() <= this.index;
    }

    public Token nextToken() {
        ++this.index;
        return this.getCurrentToken();
    }

    public Token getCurrentToken() {
        if (this.atEnd()) {
            return new Token(-2, 0.0, this.s, this.s.length(), this.s.length());
        }
        return (Token)this.tokens.elementAt(this.index);
    }

    private int scanToken(int n) {
        while (n < this.s.length() && Character.isWhitespace(this.s.charAt(n))) {
            ++n;
        }
        if (n == this.s.length()) {
            return n;
        }
        if (this.operatorChars.indexOf(this.s.charAt(n)) >= 0) {
            if (n + 1 < this.s.length()) {
                String string = this.s.substring(n, n + 2);
                int n2 = 0;
                if (string.equals("<=")) {
                    n2 = -5;
                } else if (string.equals(">=")) {
                    n2 = -7;
                } else if (string.equals("<>")) {
                    n2 = -6;
                }
                if (n2 != 0) {
                    this.tokens.addElement(new Token(n2, 0.0, this.s, n, n + 2));
                    return n + 2;
                }
            }
            this.tokens.addElement(new Token(this.s.charAt(n), 0.0, this.s, n, n + 1));
            return n + 1;
        }
        if (Character.isLetter(this.s.charAt(n))) {
            return this.scanSymbol(n);
        }
        if (Character.isDigit(this.s.charAt(n)) || '.' == this.s.charAt(n)) {
            return this.scanNumber(n);
        }
        this.tokens.addElement(this.makeErrorToken("Unknown lexeme", n, n + 1));
        return n + 1;
    }

    private int scanSymbol(int n) {
        if (this.variables.size() > 0) {
            Variable variable = null;
            Enumeration enumeration = this.variables.elements();
            while (enumeration.hasMoreElements()) {
                variable = (Variable)enumeration.nextElement();
                String string = variable.toString();
                if (n + string.length() > this.s.length() || !this.s.substring(n, n + string.length()).equals(string)) continue;
                boolean bl = true;
                int n2 = 0;
                while (n2 < this.tokens.size()) {
                    if (((Token)this.tokens.elementAt((int)n2)).sval.equals(this.s)) {
                        bl = false;
                    }
                    ++n2;
                }
                if (n + string.length() < this.s.length() && (Character.isLetter(this.s.charAt(n + string.length())) || Character.isDigit(this.s.charAt(n + string.length())))) {
                    bl = false;
                }
                if (!bl) continue;
                this.tokens.addElement(new Token(-4, 0.0, this.s, n, n + string.length()));
                return n + string.length();
            }
        }
        int n3 = n;
        while (n < this.s.length() && (Character.isLetter(this.s.charAt(n)) || Character.isDigit(this.s.charAt(n)))) {
            ++n;
        }
        this.tokens.addElement(new Token(-4, 0.0, this.s, n3, n));
        return n;
    }

    private int scanNumber(int n) {
        double d;
        int n2 = n;
        while (n < this.s.length()) {
            if ('.' != this.s.charAt(n) && !Character.isDigit(this.s.charAt(n)) && this.s.charAt(n) != 'E' && !this.s.substring(n - 1, n + 1).equals("E-")) break;
            ++n;
        }
        String string = this.s.substring(n2, n);
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.tokens.addElement(this.makeErrorToken("Not a number", n2, n));
            return n;
        }
        this.tokens.addElement(new Token(-3, d, this.s, n2, n));
        return n;
    }

    private Token makeErrorToken(String string, int n, int n2) {
        return new Token(-1, 0.0, this.s, n, n2);
    }
}

