/*
 * Decompiled with CFR 0.152.
 */
package bacon.parser;

import bacon.parser.Expr;
import bacon.parser.Scanner;
import bacon.parser.SyntaxException;
import bacon.parser.Token;
import bacon.parser.Variable;
import java.util.Hashtable;
import java.util.Vector;

public class Parser {
    private Hashtable variables = new Hashtable();
    Scanner tokens = null;
    private Token token = null;
    private static final String[] procs1 = new String[]{"abs", "acos", "asin", "atan", "ceil", "cos", "exp", "floor", "log", "round", "sin", "sqrt", "tan"};
    private static final int[] rators1 = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113};
    private static final String[] procs2 = new String[]{"atan2", "max", "min"};
    private static final int[] rators2 = new int[]{5, 6, 7};

    public Parser() {
        Variable variable = new Variable("pi");
        variable.setValue(Math.PI);
        this.addVariable(variable);
    }

    public synchronized void addVariable(Variable variable) {
        Variable variable2 = (Variable)this.variables.get(variable.name);
        if (variable2 == null) {
            this.variables.put(variable.name, variable);
        }
    }

    public Expr parseString(String string) throws SyntaxException {
        String string2 = "*/+-^<>=,";
        this.tokens = new Scanner(string, string2, this.variables);
        return this.reparse();
    }

    private Expr reparse() throws SyntaxException {
        this.tokens.index = -1;
        this.nextToken();
        Expr expr = this.parseExpr(0);
        if (this.token.ttype != -2) {
            throw this.error("Incomplete expression", 0, null);
        }
        return expr;
    }

    private void nextToken() {
        this.token = this.tokens.nextToken();
    }

    private Expr parseExpr(int n) throws SyntaxException {
        Expr expr = this.parseFactor();
        block13: while (true) {
            int n2;
            int n3;
            int n4;
            switch (this.token.ttype) {
                case 60: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 8;
                    break;
                }
                case -5: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 9;
                    break;
                }
                case 61: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 10;
                    break;
                }
                case -6: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 11;
                    break;
                }
                case -7: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 12;
                    break;
                }
                case 62: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 13;
                    break;
                }
                case 43: {
                    n4 = 30;
                    n3 = 31;
                    n2 = 0;
                    break;
                }
                case 45: {
                    n4 = 30;
                    n3 = 31;
                    n2 = 1;
                    break;
                }
                case 47: {
                    n4 = 40;
                    n3 = 41;
                    n2 = 3;
                    break;
                }
                case 42: {
                    n4 = 40;
                    n3 = 41;
                    n2 = 2;
                    break;
                }
                case 94: {
                    n4 = 50;
                    n3 = 50;
                    n2 = 4;
                    break;
                }
                default: {
                    if (this.token.ttype == -4 && this.token.sval.equals("and")) {
                        n4 = 5;
                        n3 = 6;
                        n2 = 14;
                        break;
                    }
                    if (this.token.ttype != -4 || !this.token.sval.equals("or")) break block13;
                    n4 = 10;
                    n3 = 11;
                    n2 = 15;
                    break;
                }
            }
            if (n4 < n) break;
            this.nextToken();
            expr = Expr.makeApp2(n2, expr, this.parseExpr(n3));
        }
        return expr;
    }

    private Expr parseFactor() throws SyntaxException {
        switch (this.token.ttype) {
            case -3: {
                Expr expr = Expr.makeLiteral(this.token.nval);
                this.nextToken();
                return expr;
            }
            case -4: {
                int n = 0;
                while (n < procs1.length) {
                    if (procs1[n].equals(this.token.sval)) {
                        this.nextToken();
                        this.expect(40);
                        Expr expr = this.parseExpr(0);
                        this.expect(41);
                        return Expr.makeApp1(rators1[n], expr);
                    }
                    ++n;
                }
                n = 0;
                while (n < procs2.length) {
                    if (procs2[n].equals(this.token.sval)) {
                        this.nextToken();
                        this.expect(40);
                        Expr expr = this.parseExpr(0);
                        this.expect(44);
                        Expr expr2 = this.parseExpr(0);
                        this.expect(41);
                        return Expr.makeApp2(rators2[n], expr, expr2);
                    }
                    ++n;
                }
                if (this.token.sval.equals("if")) {
                    this.nextToken();
                    this.expect(40);
                    Expr expr = this.parseExpr(0);
                    this.expect(44);
                    Expr expr3 = this.parseExpr(0);
                    this.expect(44);
                    Expr expr4 = this.parseExpr(0);
                    this.expect(41);
                    return Expr.makeIfThenElse(expr, expr3, expr4);
                }
                Expr expr = (Expr)this.variables.get(this.token.sval);
                if (this.variables == null || this.variables.get(this.token.sval) == null) {
                    throw this.error("Unknown variable: " + this.token.sval, 4, null);
                }
                this.nextToken();
                return expr;
            }
            case 40: {
                this.nextToken();
                Expr expr = this.parseExpr(0);
                this.expect(41);
                return expr;
            }
            case 45: {
                this.nextToken();
                return Expr.makeApp1(109, this.parseExpr(35));
            }
            case -2: {
                throw this.error("Factor expected", 2, null);
            }
        }
        throw this.error("Factor expected", 1, null);
    }

    private SyntaxException error(String string, int n, String string2) {
        return new SyntaxException(string, this, n, string2);
    }

    private void expect(int n) throws SyntaxException {
        if (this.token.ttype != n) {
            throw this.error("'" + (char)n + "' expected", 3, "" + (char)n);
        }
        this.nextToken();
    }

    boolean tryCorrections() {
        return this.tryInsertions() || this.tryDeletions() || this.trySubstitutions();
    }

    private boolean tryInsertions() {
        Vector vector = this.tokens.tokens;
        int n = this.tokens.index;
        while (n >= 0) {
            Token[] tokenArray;
            Token token;
            if (n < vector.size()) {
                token = (Token)vector.elementAt(n);
            } else {
                tokenArray = this.tokens.getInput();
                token = new Token(-2, 0.0, (String)tokenArray, tokenArray.length(), tokenArray.length());
            }
            tokenArray = this.possibleInsertions(token);
            int n2 = 0;
            while (n2 < tokenArray.length) {
                vector.insertElementAt(tokenArray[n2], n);
                try {
                    this.reparse();
                    return true;
                }
                catch (SyntaxException syntaxException) {
                    vector.removeElementAt(n);
                    ++n2;
                }
            }
            --n;
        }
        return false;
    }

    private boolean tryDeletions() {
        Vector vector = this.tokens.tokens;
        int n = this.tokens.index;
        while (n >= 0) {
            if (vector.size() > n) {
                Object e = vector.elementAt(n);
                vector.removeElementAt(n);
                try {
                    this.reparse();
                    return true;
                }
                catch (SyntaxException syntaxException) {
                    vector.insertElementAt(e, n);
                }
            }
            --n;
        }
        return false;
    }

    private boolean trySubstitutions() {
        Vector vector = this.tokens.tokens;
        int n = this.tokens.index;
        while (n >= 0) {
            if (vector.size() > n) {
                Token token = (Token)vector.elementAt(n);
                Token[] tokenArray = this.possibleSubstitutions(token);
                int n2 = 0;
                while (n2 < tokenArray.length) {
                    vector.setElementAt(tokenArray[n2], n);
                    try {
                        this.reparse();
                        return true;
                    }
                    catch (SyntaxException syntaxException) {
                        ++n2;
                    }
                }
                vector.setElementAt(token, n);
            }
            --n;
        }
        return false;
    }

    private Token[] possibleInsertions(Token token) {
        String string = this.tokens.getOperatorChars();
        Token[] tokenArray = new Token[string.length() + 6 + procs1.length + procs2.length];
        int n = 0;
        Token token2 = new Token(-3, 1.0, "1", token);
        tokenArray[n++] = token2;
        int n2 = 0;
        while (n2 < string.length()) {
            tokenArray[n++] = new Token(string.charAt(n2), 0.0, "" + string.charAt(n2), token);
            ++n2;
        }
        tokenArray[n++] = new Token(-4, 0.0, "x", token);
        n2 = 0;
        while (n2 < procs1.length) {
            tokenArray[n++] = new Token(-4, 0.0, procs1[n2], token);
            ++n2;
        }
        n2 = 0;
        while (n2 < procs2.length) {
            tokenArray[n++] = new Token(-4, 0.0, procs2[n2], token);
            ++n2;
        }
        tokenArray[n++] = new Token(-5, 0.0, "<=", token);
        tokenArray[n++] = new Token(-6, 0.0, "<>", token);
        tokenArray[n++] = new Token(-7, 0.0, ">=", token);
        tokenArray[n++] = new Token(-4, 0.0, "if", token);
        return tokenArray;
    }

    public void clearVariables() {
        if (this.variables != null) {
            this.variables.clear();
        }
        Variable variable = new Variable("pi");
        variable.setValue(Math.PI);
        this.addVariable(variable);
    }

    private Token[] possibleSubstitutions(Token token) {
        return this.possibleInsertions(token);
    }
}

