/*
 * Decompiled with CFR 0.152.
 */
package bacon.parser;

import bacon.parser.BinaryExpr;
import bacon.parser.ConditionalExpr;
import bacon.parser.LiteralExpr;
import bacon.parser.UnaryExpr;

public abstract class Expr {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int POW = 4;
    public static final int ATAN2 = 5;
    public static final int MAX = 6;
    public static final int MIN = 7;
    public static final int LT = 8;
    public static final int LE = 9;
    public static final int EQ = 10;
    public static final int NE = 11;
    public static final int GE = 12;
    public static final int GT = 13;
    public static final int AND = 14;
    public static final int OR = 15;
    public static final int ABS = 100;
    public static final int ACOS = 101;
    public static final int ASIN = 102;
    public static final int ATAN = 103;
    public static final int CEIL = 104;
    public static final int COS = 105;
    public static final int EXP = 106;
    public static final int FLOOR = 107;
    public static final int LOG = 108;
    public static final int NEG = 109;
    public static final int ROUND = 110;
    public static final int SIN = 111;
    public static final int SQRT = 112;
    public static final int TAN = 113;

    public abstract double value();

    public static Expr makeLiteral(double d) {
        return new LiteralExpr(d);
    }

    public static Expr makeApp1(int n, Expr expr) {
        UnaryExpr unaryExpr = new UnaryExpr(n, expr);
        return expr instanceof LiteralExpr ? new LiteralExpr(((Expr)unaryExpr).value()) : unaryExpr;
    }

    public static Expr makeApp2(int n, Expr expr, Expr expr2) {
        BinaryExpr binaryExpr = new BinaryExpr(n, expr, expr2);
        return expr instanceof LiteralExpr && expr2 instanceof LiteralExpr ? new LiteralExpr(((Expr)binaryExpr).value()) : binaryExpr;
    }

    public static Expr makeIfThenElse(Expr expr, Expr expr2, Expr expr3) {
        ConditionalExpr conditionalExpr = new ConditionalExpr(expr, expr2, expr3);
        if (expr instanceof LiteralExpr && expr2 instanceof LiteralExpr && expr3 instanceof LiteralExpr) {
            return new LiteralExpr(((Expr)conditionalExpr).value());
        }
        return conditionalExpr;
    }
}

