/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.parser.realparser;

import java.util.Hashtable;
import uibk.mtk.lang.Messages;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Scanner;
import uibk.mtk.parser.realparser.SyntaxException;
import uibk.mtk.parser.realparser.Token;
import uibk.mtk.parser.realparser.Variable;

public class Parser {
    private static final String BUNDLE_NAME = "uibk.mtk.parser.realparser.messages";
    private Hashtable variables = new Hashtable();
    Scanner tokenscanner = null;
    private Token token = null;
    String input;
    private String operatorChars = "*/+-^<>=,()!";
    private static final String[] PROCS1 = new String[]{"abs", "acos", "asin", "atan", "ceil", "cos", "exp", "floor", "log", "round", "sin", "sqrt", "tan", "faktorielle", "sign"};
    private static final int[] RATORS1 = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115};
    private static final String[] PROCS2 = new String[]{"atan2", "max", "min"};
    private static final int[] RATORS2 = new int[]{5, 6, 7};

    public Parser() {
        this.addStandardVariables();
    }

    public void clearVariables() {
        if (this.variables != null) {
            this.variables.clear();
            this.addStandardVariables();
        }
    }

    private void addStandardVariables() {
        Variable pi = new Variable("pi");
        pi.setValue(Math.PI);
        this.addVariable(pi);
    }

    public synchronized void addVariable(Variable var) {
        Variable result = (Variable)this.variables.get(var.name);
        if (result == null) {
            this.variables.put(var.name, var);
        }
    }

    private String trim(String input) {
        String str = "";
        int n = input.length();
        int i = 0;
        while (i < n) {
            if (!Character.isWhitespace(input.charAt(i))) {
                str = String.valueOf(str) + input.charAt(i);
            }
            ++i;
        }
        return str;
    }

    public Expr parseString(String in) throws SyntaxException {
        this.input = this.trim(in);
        this.tokenscanner = new Scanner(this.input, this.operatorChars, this.variables);
        return this.reparse();
    }

    private Expr reparse() throws SyntaxException {
        this.tokenscanner.index = -1;
        this.nextToken();
        Expr expr = this.parseExpr(0);
        expr.formula = this.input;
        if (this.token.ttype != -2) {
            throw this.error(Messages.getString(BUNDLE_NAME, "Parser.0"), 0, null);
        }
        return expr;
    }

    private void nextToken() {
        this.token = this.tokenscanner.nextToken();
    }

    private Expr parseExpr(int precedence) throws SyntaxException {
        Expr expr = this.parseFactor();
        if (this.token.ttype == 33) {
            expr = Expr.makePost(114, expr);
            this.nextToken();
        }
        block13: while (true) {
            int rator;
            int r;
            int l;
            switch (this.token.ttype) {
                case 60: {
                    l = 20;
                    r = 21;
                    rator = 8;
                    break;
                }
                case -5: {
                    l = 20;
                    r = 21;
                    rator = 9;
                    break;
                }
                case 61: {
                    l = 20;
                    r = 21;
                    rator = 10;
                    break;
                }
                case -6: {
                    l = 20;
                    r = 21;
                    rator = 11;
                    break;
                }
                case -7: {
                    l = 20;
                    r = 21;
                    rator = 12;
                    break;
                }
                case 62: {
                    l = 20;
                    r = 21;
                    rator = 13;
                    break;
                }
                case 43: {
                    l = 30;
                    r = 31;
                    rator = 0;
                    break;
                }
                case 45: {
                    l = 30;
                    r = 31;
                    rator = 1;
                    break;
                }
                case 47: {
                    l = 40;
                    r = 41;
                    rator = 3;
                    break;
                }
                case 42: {
                    l = 40;
                    r = 41;
                    rator = 2;
                    break;
                }
                case 94: {
                    l = 50;
                    r = 50;
                    rator = 4;
                    break;
                }
                default: {
                    if (this.token.ttype == -4 && this.token.sval.equals("and")) {
                        l = 5;
                        r = 6;
                        rator = 14;
                        break;
                    }
                    if (this.token.ttype != -4 || !this.token.sval.equals("or")) break block13;
                    l = 10;
                    r = 11;
                    rator = 15;
                    break;
                }
            }
            if (l < precedence) break;
            this.nextToken();
            expr = Expr.makeApp2(rator, expr, this.parseExpr(r));
        }
        return expr;
    }

    private Expr parseFactor() throws SyntaxException {
        switch (this.token.ttype) {
            case -3: {
                Expr lit = Expr.makeLiteral(this.token.nval);
                this.nextToken();
                return lit;
            }
            case -4: {
                int i = 0;
                while (i < PROCS1.length) {
                    if (PROCS1[i].equals(this.token.sval)) {
                        this.nextToken();
                        this.expect(40);
                        Expr rand = this.parseExpr(0);
                        this.expect(41);
                        return Expr.makeApp1(RATORS1[i], rand);
                    }
                    ++i;
                }
                i = 0;
                while (i < PROCS2.length) {
                    if (PROCS2[i].equals(this.token.sval)) {
                        this.nextToken();
                        this.expect(40);
                        Expr rand1 = this.parseExpr(0);
                        this.expect(44);
                        Expr rand2 = this.parseExpr(0);
                        this.expect(41);
                        return Expr.makeApp2(RATORS2[i], rand1, rand2);
                    }
                    ++i;
                }
                if (this.token.sval.equals("if")) {
                    this.nextToken();
                    this.expect(40);
                    Expr test = this.parseExpr(0);
                    this.expect(44);
                    Expr consequent = this.parseExpr(0);
                    this.expect(44);
                    Expr alternative = this.parseExpr(0);
                    this.expect(41);
                    return Expr.makeIfThenElse(test, consequent, alternative);
                }
                Expr var = (Expr)this.variables.get(this.token.sval);
                if (this.variables == null || this.variables.get(this.token.sval) == null) {
                    throw this.error(String.valueOf(Messages.getString(BUNDLE_NAME, "Parser.25")) + ": " + this.token.sval, 4, null);
                }
                this.nextToken();
                return var;
            }
            case 40: {
                this.nextToken();
                Expr enclosed = this.parseExpr(0);
                this.expect(41);
                return enclosed;
            }
            case 45: {
                this.nextToken();
                return Expr.makeApp1(109, this.parseExpr(35));
            }
            case -2: {
                throw this.error(Messages.getString(BUNDLE_NAME, "Parser.26"), 2, null);
            }
        }
        throw this.error(Messages.getString(BUNDLE_NAME, "Parser.27"), 1, null);
    }

    private SyntaxException error(String complaint, int reason, String expected) {
        return new SyntaxException(complaint, reason, expected);
    }

    private void expect(int ttype) throws SyntaxException {
        if (this.token.ttype != ttype) {
            throw this.error("'" + (char)ttype + "' " + Messages.getString(BUNDLE_NAME, "Parser.1"), 3, "" + (char)ttype);
        }
        this.nextToken();
    }
}

