/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.lang;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.geom.geom2d.Punkt2D;

public class RepaintThread
implements Runnable {
    private Thread t1 = null;
    private int delay = 100;
    private MathPanel2D mathPanel2D;
    private BufferedImage framebuffer;
    private Vector vGraph2D = new Vector();
    private Graphics2D g2;
    private int[] anzOld = new int[]{1, 1, 1, 1, 1, 1};

    public RepaintThread(MathPanel2D mathPanel2D) {
        this.mathPanel2D = mathPanel2D;
    }

    public void run() {
        while (true) {
            this.paint(this.mathPanel2D.getGraphics());
            if (this.t1.isInterrupted()) break;
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                this.t1.interrupt();
            }
        }
    }

    public void start() {
        if (this.t1 == null) {
            this.t1 = new Thread(this);
        } else if (!this.t1.isAlive()) {
            this.t1 = new Thread(this);
        }
        if (!this.t1.isAlive()) {
            this.t1.start();
        }
    }

    public void stop() {
        if (this.t1 != null && !this.isStop()) {
            try {
                this.t1.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isStop() {
        if (this.t1 != null) {
            return !this.t1.isAlive();
        }
        return true;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void addGraph(Graph2D graph2D) {
        this.vGraph2D.add(graph2D);
    }

    private void preparebuffer() {
        int w = this.mathPanel2D.getWidth();
        int h = this.mathPanel2D.getHeight();
        if (this.framebuffer != null && (this.framebuffer.getWidth() != w || this.framebuffer.getHeight() != h)) {
            this.mathPanel2D.requestRecompute(true);
        }
        if (this.framebuffer == null || w != this.framebuffer.getWidth() || h != this.framebuffer.getHeight()) {
            this.framebuffer = (BufferedImage)this.mathPanel2D.createImage(w, h);
        }
    }

    public void paint(Graphics g) {
        if (g != null) {
            int w = this.mathPanel2D.getWidth();
            int h = this.mathPanel2D.getHeight();
            if (this.mathPanel2D.repaintrequested || this.g2 == null || this.framebuffer == null || w != this.framebuffer.getWidth() || h != this.framebuffer.getHeight()) {
                if (this.mathPanel2D.getWidth() < 100 || this.mathPanel2D.getHeight() < 100) {
                    return;
                }
                this.preparebuffer();
                this.g2 = this.framebuffer.createGraphics();
                this.g2.setColor(Color.white);
                this.g2.fillRect(0, 0, this.framebuffer.getWidth(), this.framebuffer.getHeight());
                boolean[] vis = new boolean[this.vGraph2D.size()];
                int i = 0;
                while (i < this.vGraph2D.size()) {
                    this.anzOld[i] = 1;
                    vis[i] = false;
                    if (((Graph2D)this.vGraph2D.get(i)).isVisible()) {
                        vis[i] = true;
                        ((Graph2D)this.vGraph2D.get(i)).setVisible(false);
                    }
                    ++i;
                }
                this.mathPanel2D.drawDrawables(this.framebuffer, this.g2);
                i = 0;
                while (i < this.vGraph2D.size()) {
                    if (vis[i]) {
                        ((Graph2D)this.vGraph2D.get(i)).setVisible(true);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.vGraph2D.size()) {
                    this.drawGraphPoint((Graph2D)this.vGraph2D.get(i), i, this.g2);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.vGraph2D.size()) {
                    this.drawGraphPoint((Graph2D)this.vGraph2D.get(i), i, this.g2);
                    ++i;
                }
            }
            if (this.framebuffer != null) {
                boolean visible = true;
                Container mP = this.mathPanel2D;
                while (mP != null) {
                    if (!mP.isVisible()) {
                        visible = false;
                    }
                    mP = mP.getParent();
                }
                if (visible) {
                    g.drawImage(this.framebuffer, 0, 0, null);
                }
            }
        }
    }

    private void drawGraphPoint(Graph2D graph2D, int j, Graphics2D g2) {
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(graph2D.getStroke());
        g2.setColor(graph2D.getColor());
        Scene2D scene2d = this.mathPanel2D.getScene2d();
        Vector points = graph2D.getPoints();
        if (points != null && points.size() > 1 && graph2D.isVisible()) {
            int anzNew = points.size() - 10;
            int i = this.anzOld[j] - 1;
            while (i < points.size() - 10) {
                if (i >= 0) {
                    Punkt2D end = (Punkt2D)points.elementAt(i + 1);
                    Punkt2D start = (Punkt2D)points.elementAt(i);
                    if (start != null && end != null) {
                        int startx = scene2d.xToPixel(start.x);
                        int starty = scene2d.yToPixel(start.y);
                        int endx = scene2d.xToPixel(end.x);
                        int endy = scene2d.yToPixel(end.y);
                        g2.drawLine(startx, starty, endx, endy);
                        this.anzOld[j] = anzNew;
                    }
                }
                ++i;
            }
        }
        g2.setStroke(oldStroke);
    }
}

