/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.ToolTipable;

public class PhysicBase2D
extends Drawable2D
implements ToolTipable {
    private double x = 0.0;
    private double y = 0.0;
    private int sizeX = 5;
    private int sizeY = this.sizeX / 3;
    private boolean tooltipenabled = false;
    private String toolTip = null;
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    private int orientation = 2;

    public PhysicBase2D() {
    }

    public PhysicBase2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setCoordinates(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setToolTipText(String tooltip) {
        this.toolTip = tooltip;
    }

    public void setCoordinates(Punkt2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public boolean isToolTipEnabled() {
        return this.tooltipenabled;
    }

    public void enableToolTip(boolean b) {
        this.tooltipenabled = b;
    }

    public void setSize(int size) {
        this.sizeX = size;
        this.sizeY = size / 3;
    }

    public boolean tooltipcontains(int xm, int ym) {
        int yp;
        int xp = this.scene2d.xToPixel(this.x);
        return (xm - xp) * (xm - xp) + (ym - (yp = this.scene2d.yToPixel(this.y))) * (ym - yp) <= this.sizeX * this.sizeY;
    }

    public Punkt2D getPunkt2D() {
        return new Punkt2D(this.x, this.y);
    }

    public String getToolTipText(MouseEvent ev) {
        if (this.toolTip == null) {
            String str = "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + ")";
            return str;
        }
        return this.toolTip;
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        int tmpSizeX = this.sizeX;
        int tmpSizeY = this.sizeY;
        g2.setColor(this.color);
        g2.setStroke(new BasicStroke(this.sizeX >= 0 ? this.sizeX / 20 : -this.sizeX / 20));
        g2.fillOval(this.scene2d.xToPixel(this.x) - this.sizeX / 10, this.scene2d.yToPixel(this.y) - this.sizeX / 10, 2 * this.sizeX / 10 + 1, 2 * this.sizeX / 10 + 1);
        switch (this.orientation) {
            case 0: {
                tmpSizeY = -tmpSizeY;
            }
            case 2: {
                g2.drawLine(this.scene2d.xToPixel(this.x) - tmpSizeX / 2, this.scene2d.yToPixel(this.y), this.scene2d.xToPixel(this.x) + tmpSizeX / 2, this.scene2d.yToPixel(this.y));
                g2.setStroke(new BasicStroke(tmpSizeX >= 0 ? tmpSizeX / 30 : -tmpSizeX / 30));
                int abstandx = tmpSizeX / 5;
                int i = 0;
                while (i < 6) {
                    g2.drawLine(this.scene2d.xToPixel(this.x) - tmpSizeX / 2 + i * abstandx, this.scene2d.yToPixel(this.y), this.scene2d.xToPixel(this.x) - tmpSizeX / 2 + i * abstandx + tmpSizeX / 5, this.scene2d.yToPixel(this.y) - tmpSizeY);
                    ++i;
                }
                break;
            }
            case 1: {
                tmpSizeX = this.sizeY;
                tmpSizeY = this.sizeX;
                tmpSizeX = -tmpSizeX;
            }
            case 3: {
                if (this.orientation != 1) {
                    tmpSizeX = this.sizeY;
                    tmpSizeY = this.sizeX;
                }
                g2.drawLine(this.scene2d.xToPixel(this.x), this.scene2d.yToPixel(this.y) - tmpSizeY / 2, this.scene2d.xToPixel(this.x), this.scene2d.yToPixel(this.y) + tmpSizeY / 2);
                g2.setStroke(new BasicStroke((float)tmpSizeY / 30.0f));
                int abstandy = tmpSizeY / 5;
                int i = 0;
                while (i < 6) {
                    g2.drawLine(this.scene2d.xToPixel(this.x), this.scene2d.yToPixel(this.y) - tmpSizeY / 2 + i * abstandy, this.scene2d.xToPixel(this.x) - tmpSizeX, this.scene2d.yToPixel(this.y) - tmpSizeY / 2 + i * abstandy + tmpSizeY / 5);
                    ++i;
                }
                break;
            }
        }
    }

    public void setOrientation(int o) {
        this.orientation = o;
    }
}

