/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.axes2d;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Vector;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.axes2d.Axis;
import uibk.mtk.draw2d.axes2d.Tick;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.geom.geom2d.Punkt2D;

class YAxis
extends Axis {
    YAxis(Axes2D axes) {
        super(axes);
    }

    void compute(Punkt2D start, Punkt2D end, Punkt2D axisIntersection, int tickAndLabelPos, Graphics2D g2, Scene2D coords2d) {
        if (this.style != 2) {
            Vector tickPositions = this.axes.computeTickPositions(start.y, end.y);
            if (tickPositions != null && tickPositions.size() > 0) {
                this.ticks = this.axes.createTicks(tickPositions, tickAndLabelPos, coords2d.getYPixelScale() / 10.0, start.x, this.axes.formaty);
            }
            if (this.ticks != null) {
                int i = 0;
                while (i < this.ticks.size()) {
                    ((Tick)this.ticks.elementAt(i)).compute(g2, coords2d);
                    ++i;
                }
            }
        }
        int startX = coords2d.xToPixel(start.x);
        int startY = coords2d.yToPixel(start.y);
        int endX = coords2d.xToPixel(end.x);
        int endY = coords2d.yToPixel(end.y);
        if (axisIntersection != null && Math.abs(start.y - axisIntersection.y) > Math.abs(end.y - axisIntersection.y)) {
            this.startPix.x = endX;
            this.startPix.y = endY;
            this.endPix.x = startX;
            this.endPix.y = startY;
            coords2d.requestSpaceBottom(this.endPix.y + Axis.ARROWLENGTH);
            if (this.axes.area == 21 || this.axes.area == 9 || this.axes.area == 6) {
                this.startPix.y -= Axis.ARROWLENGTH;
                coords2d.requestSpaceTop(this.startPix.y);
            }
        } else {
            this.startPix.x = startX;
            this.startPix.y = startY;
            this.endPix.x = endX;
            this.endPix.y = endY;
            coords2d.requestSpaceTop(this.endPix.y - Axis.ARROWLENGTH);
            if (this.axes.area == 21 || this.axes.area == 9 || this.axes.area == 6) {
                this.startPix.y += Axis.ARROWLENGTH;
                coords2d.requestSpaceBottom(this.startPix.y);
            }
        }
        FontMetrics metrics = g2.getFontMetrics();
        int height = metrics.getHeight();
        int length = metrics.stringWidth(this.caption);
        this.captionpos.y = this.endPix.y + height / 4;
        this.captionpos.x = tickAndLabelPos == 0 ? this.endPix.x + 4 : this.endPix.x - length - 4;
        coords2d.requestSpaceRight(this.startPix.x + Axis.OFFSETWINGS);
        coords2d.requestSpaceLeft(this.startPix.x - Axis.OFFSETWINGS);
    }

    void draw(Graphics2D g2, Scene2D coords2d) {
        g2.setColor(this.axes.coloryaxes);
        if (this.axes.style == 1) {
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(this.axes.strokeyaxes);
            if (this.startPix.y > this.endPix.y) {
                this.drawArrow(g2, this.endPix.x, this.endPix.y, 2);
            } else {
                this.drawArrow(g2, this.endPix.x, this.endPix.y, 3);
            }
            g2.drawLine(this.startPix.x, this.startPix.y, this.endPix.x, this.endPix.y);
            g2.setStroke(oldStroke);
        }
        if (this.ticks != null && this.style != 2) {
            boolean drawLabels = this.style == 1;
            int i = 0;
            while (i < this.ticks.size()) {
                ((Tick)this.ticks.elementAt(i)).draw(g2, coords2d, drawLabels);
                ++i;
            }
        }
        if (this.style == 1 && this.caption != null && !this.caption.equals("") && this.axes.style != 0) {
            g2.drawString(this.caption, this.captionpos.x, this.captionpos.y);
        }
    }
}

