/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.pendulum;

import java.awt.BasicStroke;
import java.util.Vector;
import uibk.applets.pendulum.AppletPendulum;
import uibk.applets.pendulum.InteractionControl;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.draw2d.objects.MathLine2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.Animation;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.Function;

public class Pendel
extends Animation {
    private AppletPendulum main;
    private int konfig = 1;
    public double[] position;
    public int anzPendel = 1;
    private double runTime = 0.0;
    private double aufloes = 0.01;
    Vector sol = null;

    public Pendel(AppletPendulum main, InteractionControl control, int konfig) {
        this.main = main;
        this.konfig = konfig;
    }

    public void setAufloesung(double a) {
        this.aufloes = a;
        this.main.pendel.setDelay((int)(a * 1000.0));
        this.main.diagramm.setDelay((int)(a * 2000.0));
    }

    protected void compute() {
        double y;
        double x;
        Scene2D scene2d = this.main.mathpanel2D.getScene2d();
        double xmin = scene2d.getXmin();
        double xmax = scene2d.getXmax();
        int size = Math.abs((scene2d.xToPixel(xmax) - scene2d.xToPixel(xmin)) / 15);
        int i = 0;
        while (i < this.anzPendel) {
            int sizeMasse = (int)(this.main.panelPendel[i].masse * Math.pow(size * 10, 0.2));
            if (sizeMasse < size) {
                sizeMasse = size;
            } else if (sizeMasse > size * 3) {
                sizeMasse = size * 3;
            }
            this.main.masse[i].setRadius(sizeMasse / 4);
            ++i;
        }
        double time = this.getTime();
        boolean run = true;
        do {
            double tmpTime = this.aufloes;
            if (time > this.aufloes) {
                time -= this.aufloes;
            } else {
                tmpTime = time;
                run = false;
            }
            this.runTime += tmpTime;
            this.position = this.solveDGL(this.position, tmpTime);
            x = 0.0;
            y = 0.0;
            int i2 = 0;
            while (i2 < this.anzPendel) {
                Punkt2D basis = new Punkt2D(this.main.basis[i2].getPunkt2D());
                if (this.konfig == 2 && i2 > 0) {
                    basis.setLocation(this.main.masse[i2 - 1].getPunkt2D());
                } else if (this.konfig == 3 && i2 > 0) {
                    x = 0.0;
                    y = 0.0;
                }
                this.main.basis[i2].setSize(size);
                this.main.masse[i2].setCoordinates(x += this.main.panelPendel[i2].laenge * Math.sin(this.position[i2]) + this.main.basis[i2].getX(), y += -this.main.panelPendel[i2].laenge * Math.cos(this.position[i2]) + this.main.basis[i2].getY());
                this.main.schnur[i2].setStroke(new BasicStroke((float)size / 30.0f));
                this.main.schnur[i2].setP1(basis);
                this.main.schnur[i2].setP2(this.main.masse[i2].getPunkt2D());
                double v = this.geschwSet(basis.x, basis.y, x, y, i2);
                this.main.geschwV[i2].setStroke(new BasicStroke((float)size / 20.0f));
                double a = this.beschlSet(basis.x, basis.y, x, y, i2);
                this.main.beschlV[i2].setStroke(new BasicStroke((float)size / 20.0f));
                this.main.diagramm.addPunkt(this.runTime, this.position[i2], x, y, v, a, i2);
                ++i2;
            }
        } while (run);
        if (this.konfig == 3) {
            Punkt2D[] p = new Punkt2D[2];
            int i3 = 0;
            while (i3 < 2) {
                x = this.main.masse[i3].getX() - this.main.basis[i3].getX();
                y = this.main.masse[i3].getY() - this.main.basis[i3].getY();
                double r = this.main.panelFeder.federPos;
                double norm = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
                x = this.main.basis[i3].getX() + r * x / norm;
                y = this.main.basis[i3].getY() + r * y / norm;
                p[i3] = new Punkt2D(x, y);
                ++i3;
            }
            this.main.feder.setCoordinates(p[0], p[1]);
            this.main.feder.setSize(size / 5, size / 30, 10);
        }
        this.main.mathpanel2D.repaint();
    }

    private double[] solveDGL(double[] initials, double time) {
        Interval interval = new Interval(0.0, time);
        this.main.odeSolver.setInitialCondition(0.0, initials);
        this.main.odeSolver.setIntegrationInvervall(interval);
        try {
            this.sol = this.main.odeSolver.solve(null);
        }
        catch (Exception ex) {
            this.main.mathpanel2D.reportError(ex);
            return initials;
        }
        if (this.sol.size() == 0) {
            return initials;
        }
        return (double[])this.sol.lastElement();
    }

    private double geschwSet(double x1, double y1, double x2, double y2, int i) {
        int j = 1;
        if (this.anzPendel == 2) {
            j = 2;
        }
        MathLine2D line = this.norVekotr(x1, y1, x2, y2, this.position[j + i]);
        this.main.geschwV[i].setBase(line.getP1());
        this.main.geschwV[i].setHead(line.getP2());
        return this.position[j + i];
    }

    private double beschlSet(double x1, double y1, double x2, double y2, int i) {
        int j = 1;
        if (this.anzPendel == 2) {
            j = 2;
        }
        Function f = this.main.odeSolver.getDGL();
        double[] tss = f.getValue(this.position);
        MathLine2D line = this.norVekotr(x1, y1, x2, y2, tss[j + i]);
        this.main.beschlV[i].setBase(line.getP1());
        this.main.beschlV[i].setHead(line.getP2());
        return tss[j + i];
    }

    private MathLine2D norVekotr(double x1, double y1, double x2, double y2, double laenge) {
        MathLine2D line = new MathLine2D(x2, y2, x2, y2);
        line.setP2(new Punkt2D(-(y2 - y1) / Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) * laenge + x2, (x2 - x1) / Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) * laenge + y2));
        return line;
    }
}

