/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.pendulum;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.border.TitledBorder;
import uibk.applets.pendulum.AppletPendulum;
import uibk.applets.pendulum.InteractionControl;
import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.swing.base.DoubleTextField;
import uibk.mtk.swing.base.Label;
import uibk.mtk.swing.base.MPanel;

public class PanelPendel
extends MPanel {
    private final AppletPendulum main;
    private final InteractionControl control;
    protected DoubleTextField textLaenge;
    protected DoubleTextField textMasse;
    protected DoubleTextField textAmplitude;
    protected DoubleTextField textGeschw;
    protected double laenge = 0.0;
    protected double masse = 0.0;
    protected double amplitude = 0.0;
    protected double geschw = 0.0;
    private String titel;

    public PanelPendel(AppletPendulum main, InteractionControl control, String titel) {
        this.main = main;
        this.control = control;
        this.titel = titel;
        this.initComponents();
    }

    private MPanel createPanelDef() {
        MPanel panelDefPendel = new MPanel();
        panelDefPendel.setLayout(new GridBagLayout());
        TitledBorder b = BorderFactory.createTitledBorder(this.titel);
        b.setTitleFont(b.getTitleFont().deriveFont(1));
        panelDefPendel.setBorder(b);
        panelDefPendel.setMaximumSize(new Dimension(1000, 190));
        Label labelLaenge = new Label(Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.10"));
        Label labelMasse = new Label(Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.12"));
        Label labelAmplitude = new Label(Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.13"));
        Label labelGeschw = new Label(Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.14"));
        labelLaenge.setPreferredSize(new Dimension(120, 20));
        labelMasse.setPreferredSize(new Dimension(120, 20));
        labelAmplitude.setPreferredSize(new Dimension(120, 20));
        labelGeschw.setPreferredSize(new Dimension(120, 20));
        this.textLaenge = new DoubleTextField(6, null, null, null, Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.20"));
        this.textLaenge.setText("-1");
        this.textLaenge.setActionCommand("laenge");
        this.textLaenge.addActionListener(this.control);
        this.textLaenge.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.21"));
        this.textMasse = new DoubleTextField(6, null, null, null, Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.24"));
        this.textMasse.setText("-1");
        this.textMasse.setActionCommand("masse");
        this.textMasse.addActionListener(this.control);
        this.textMasse.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.25"));
        this.textAmplitude = new DoubleTextField(6, null, null, null, Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.26"));
        this.textAmplitude.setText("0");
        this.textAmplitude.setActionCommand("laenge");
        this.textAmplitude.addActionListener(this.control);
        this.textAmplitude.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.27"));
        this.textGeschw = new DoubleTextField(6, new Double(-10.0), new Double(10.0), null, Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.28"));
        this.textGeschw.setText("0");
        this.textGeschw.setActionCommand("geschw");
        this.textGeschw.addActionListener(this.control);
        this.textGeschw.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.29"));
        panelDefPendel.add((Component)labelLaenge, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)this.textLaenge, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)labelMasse, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)this.textMasse, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)labelAmplitude, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)this.textAmplitude, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)labelGeschw, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)this.textGeschw, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        return panelDefPendel;
    }

    void initComponents() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createPanelDef());
    }

    void leseDaten() throws InputException {
        if (!this.getLaenge()) {
            throw new InputException();
        }
        if (!this.getAmplitude()) {
            throw new InputException();
        }
        if (!this.getMasse()) {
            throw new InputException();
        }
        if (!this.getGeschw()) {
            throw new InputException();
        }
    }

    private boolean getLaenge() {
        try {
            String strfunc = this.textLaenge.getText();
            this.laenge = Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.20"), null, null, Boolean.TRUE);
            return true;
        }
        catch (Exception e) {
            this.main.mathpanel2D.reportError(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.1"), e);
            return false;
        }
    }

    public boolean getMasse() {
        try {
            String strfunc = this.textMasse.getText();
            this.masse = Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.24"), null, null, Boolean.TRUE);
            return true;
        }
        catch (Exception e) {
            this.main.mathpanel2D.reportError(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.1"), e);
            return false;
        }
    }

    private boolean getAmplitude() {
        try {
            String strfunc = this.textAmplitude.getText();
            this.amplitude = Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.pendulum.messages", "PanelPendel.26"), new Double(-1.0), new Double(1.0), null);
            return true;
        }
        catch (Exception e) {
            this.main.mathpanel2D.reportError(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.1"), e);
            return false;
        }
    }

    private boolean getGeschw() {
        try {
            this.geschw = this.textGeschw.getValue();
            return true;
        }
        catch (Exception e) {
            this.main.mathpanel2D.reportError(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.1"), e);
            return false;
        }
    }
}

