/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.pendulum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import uibk.applets.pendulum.AppletPendulum;
import uibk.applets.pendulum.InteractionControl;
import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.swing.appletbase.PanelLoadExample;
import uibk.mtk.swing.base.CheckBox;
import uibk.mtk.swing.base.DoubleTextField;
import uibk.mtk.swing.base.Label;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.RadioButton;
import uibk.mtk.swing.base.TextField;

public class PanelMain
extends MPanel {
    private final AppletPendulum main;
    private InteractionControl control;
    protected DoubleTextField textFallBeschleun;
    protected DoubleTextField textDaempfung;
    protected double fallBeschleun = 0.0;
    protected double daempfung = 0.0;
    protected CheckBox geschw;
    protected CheckBox beschl;
    protected RadioButton _1Pendel;
    protected RadioButton _2Pendel;
    protected RadioButton seriell;
    protected RadioButton parallel;
    private JSlider slider;

    private MPanel createPanelDef() {
        MPanel panelDefPendel = new MPanel();
        panelDefPendel.setLayout(new GridBagLayout());
        TitledBorder b = BorderFactory.createTitledBorder(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.0"));
        b.setTitleFont(b.getTitleFont().deriveFont(1));
        panelDefPendel.setBorder(b);
        panelDefPendel.setMaximumSize(new Dimension(1000, 190));
        Label labelBeschleun = new Label(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.11"));
        labelBeschleun.setPreferredSize(new Dimension(120, 20));
        Label labelDaempfung = new Label(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.12"));
        labelDaempfung.setPreferredSize(new Dimension(120, 20));
        this.textFallBeschleun = new DoubleTextField(6, null, null, null, Messages.getString("uibk.applets.pendulum.messages", "PanelMain.22"));
        this.textFallBeschleun.setText("-1");
        this.textFallBeschleun.setActionCommand("beschleun");
        this.textFallBeschleun.addActionListener(this.control);
        this.textFallBeschleun.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.23"));
        this.textDaempfung = new DoubleTextField(6, null, null, null, Messages.getString("uibk.applets.pendulum.messages", "PanelMain.24"));
        this.textDaempfung.setText("0");
        this.textDaempfung.setActionCommand("beschleun");
        this.textDaempfung.addActionListener(this.control);
        this.textDaempfung.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.25"));
        panelDefPendel.add((Component)labelBeschleun, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)this.textFallBeschleun, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)labelDaempfung, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        panelDefPendel.add((Component)this.textDaempfung, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        return panelDefPendel;
    }

    private MPanel createPanelLoad() {
        String[] options = new String[]{Messages.getString("uibk.applets.pendulum.messages", "PanelMain.60"), Messages.getString("uibk.applets.pendulum.messages", "PanelMain.61"), Messages.getString("uibk.applets.pendulum.messages", "PanelMain.62"), Messages.getString("uibk.applets.pendulum.messages", "PanelMain.63"), Messages.getString("uibk.applets.pendulum.messages", "PanelMain.64")};
        JTextComponent[] textfields = new TextField[]{this.textFallBeschleun, this.textDaempfung, this.main.panelPendel[0].textLaenge, this.main.panelPendel[0].textMasse, this.main.panelPendel[0].textAmplitude, this.main.panelPendel[0].textGeschw, this.main.panelPendel[1].textLaenge, this.main.panelPendel[1].textMasse, this.main.panelPendel[1].textAmplitude, this.main.panelFeder.textFederK, this.main.panelFeder.textFederPos};
        String[][] values = new String[][]{{"9.81", "0", "5", "10", "0.3", "0", "-1", "-1", "-1", "-1", "-1"}, {"9.81", "0.1", "10", "25", "0.7", "0", "-1", "-1", "-1", "-1", "-1"}, {"9.81", "0", "15", "20", "-0.91", "0.25", "-1", "-1", "-1", "-1", "-1"}, {"9.81", "0", "10", "20", "-0.8", "0", "5", "5", "-0.5", "-1", "-1"}, {"9.81", "0", "10", "20", "0", "0", "10", "15", "-0.3", "1.5", "10"}};
        PanelLoadExample.LoadAction action = new PanelLoadExample.LoadAction(){

            public void execute(String item) {
                if (item.equals(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.60"))) {
                    PanelMain.this.control._1Pendel();
                }
                if (item.equals(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.61"))) {
                    PanelMain.this.control._1Pendel();
                }
                if (item.equals(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.62"))) {
                    PanelMain.this.control._1Pendel();
                }
                if (item.equals(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.63"))) {
                    PanelMain.this.control.seriell();
                    PanelMain.this.control._2Pendel();
                }
                if (item.equals(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.64"))) {
                    PanelMain.this.control.parallel();
                    PanelMain.this.control._2Pendel();
                }
            }
        };
        PanelLoadExample.LoadAction[] actions = new PanelLoadExample.LoadAction[]{action, action, action, action, action};
        return new PanelLoadExample(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.32"), Messages.getString("uibk.applets.pendulum.messages", "PanelMain.33"), options, textfields, values, actions);
    }

    private MPanel createPanelDarstellung() {
        MPanel panelDarstellungPendel = new MPanel();
        panelDarstellungPendel.setLayout(new GridBagLayout());
        TitledBorder b = BorderFactory.createTitledBorder(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.34"));
        b.setTitleFont(b.getTitleFont().deriveFont(1));
        panelDarstellungPendel.setBorder(b);
        panelDarstellungPendel.setMaximumSize(new Dimension(1000, 190));
        this._1Pendel = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.35"));
        this._1Pendel.setSelected(true);
        this._1Pendel.setActionCommand("_1Pendel");
        this._1Pendel.addActionListener(this.control);
        this._2Pendel = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.36"));
        this._2Pendel.setSelected(false);
        this._2Pendel.setActionCommand("_2Pendel");
        this._2Pendel.addActionListener(this.control);
        this.seriell = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.37"));
        this.seriell.setSelected(true);
        this.seriell.setActionCommand("seriell");
        this.seriell.addActionListener(this.control);
        this.seriell.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.38"));
        this.seriell.setEnabled(false);
        this.parallel = new RadioButton(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.39"));
        this.parallel.setSelected(false);
        this.parallel.setActionCommand("parallel");
        this.parallel.addActionListener(this.control);
        this.parallel.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.40"));
        this.parallel.setEnabled(false);
        panelDarstellungPendel.add((Component)this._1Pendel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelDarstellungPendel.add((Component)this._2Pendel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelDarstellungPendel.add((Component)this.seriell, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelDarstellungPendel.add((Component)this.parallel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        return panelDarstellungPendel;
    }

    private MPanel createPanelOption() {
        MPanel panelOptionPendel = new MPanel();
        panelOptionPendel.setLayout(new GridBagLayout());
        TitledBorder b = BorderFactory.createTitledBorder(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.41"));
        b.setTitleFont(b.getTitleFont().deriveFont(1));
        panelOptionPendel.setBorder(b);
        panelOptionPendel.setMaximumSize(new Dimension(1000, 190));
        this.geschw = new CheckBox(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.43"));
        this.geschw.setSelected(false);
        this.geschw.setActionCommand("geschw");
        this.geschw.addActionListener(this.control);
        this.geschw.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.44"));
        this.geschw.setBackground(this.main.GESCHWFA);
        this.beschl = new CheckBox(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.45"));
        this.beschl.setSelected(false);
        this.beschl.setActionCommand("beschl");
        this.beschl.addActionListener(this.control);
        this.beschl.setToolTipText(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.46"));
        this.beschl.setBackground(this.main.BESCHLFA);
        panelOptionPendel.add((Component)this.geschw, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelOptionPendel.add((Component)this.beschl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        return panelOptionPendel;
    }

    private MPanel createPanelZeitVer() {
        MPanel panelZeitVerz = new MPanel();
        panelZeitVerz.setLayout(new BorderLayout());
        TitledBorder b = BorderFactory.createTitledBorder(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.70"));
        b.setTitleFont(b.getTitleFont().deriveFont(1));
        panelZeitVerz.setBorder(b);
        panelZeitVerz.setMaximumSize(new Dimension(1000, 100));
        this.slider = new JSlider();
        this.slider.setMinimum(1);
        this.slider.setValue(1);
        this.slider.setMaximum(10);
        this.slider.setEnabled(false);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                if (((PanelMain)PanelMain.this).main.pendel != null) {
                    ((PanelMain)PanelMain.this).main.pendel.setSlowDownTime(n);
                }
            }
        });
        Label min = new Label(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.71"));
        Label max = new Label(Messages.getString("uibk.applets.pendulum.messages", "PanelMain.72"));
        panelZeitVerz.add((Component)this.slider, "Center");
        panelZeitVerz.add((Component)min, "West");
        panelZeitVerz.add((Component)max, "East");
        return panelZeitVerz;
    }

    void initComponents() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createPanelDef());
        this.add(this.createPanelLoad());
        this.add(this.createPanelDarstellung());
        this.add(this.createPanelOption());
        this.add(this.createPanelZeitVer());
        this.add(Box.createVerticalGlue());
    }

    public PanelMain(AppletPendulum main, InteractionControl control) {
        this.main = main;
        this.control = control;
        this.initComponents();
    }

    public void leseDaten() throws InputException {
        if (!this.getBeschleun()) {
            throw new InputException();
        }
        if (!this.getDaempfung()) {
            throw new InputException();
        }
        this.slider.setEnabled(true);
        int n = this.main.panelMain.slider.getValue();
        this.main.pendel.setSlowDownTime(n);
    }

    private boolean getBeschleun() {
        try {
            String strfunc = this.textFallBeschleun.getText();
            this.fallBeschleun = Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.pendulum.messages", "PanelMain.22"), null, null, Boolean.TRUE);
            return true;
        }
        catch (Exception e) {
            this.main.mathpanel2D.reportError(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.1"), e);
            return false;
        }
    }

    private boolean getDaempfung() {
        try {
            String strfunc = this.textDaempfung.getText();
            this.daempfung = Misc.parseDoubleValue(strfunc, Messages.getString("uibk.applets.pendulum.messages", "PanelMain.24"), new Double(0.0), null, null);
            return true;
        }
        catch (Exception e) {
            this.main.mathpanel2D.reportError(Messages.getString("uibk.applets.pendulum.messages", "InteractionControl.1"), e);
            return false;
        }
    }
}

