/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.appletbase;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.border.CompoundBorder;
import uibk.mtk.lang.MathPanel;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.Options;
import uibk.mtk.lang.StandardOptions;
import uibk.mtk.swing.appletbase.AppletFrame;
import uibk.mtk.swing.appletbase.NavigationBar;
import uibk.mtk.swing.appletbase.ReportingLabel;
import uibk.mtk.swing.base.MPanel;

public class AppletBase
extends JApplet {
    protected boolean isStandalone = false;
    private static final int DIVIDERSIZE = 8;
    protected ReportingLabel labelreports = new ReportingLabel(Messages.getString("uibk.mtk.swing.appletbase.messages", "AppletBase.1"));
    protected JSplitPane splitpanel;
    protected NavigationBar panelnav;
    protected MPanel panelmain = new MPanel();
    private MPanel panelcontrol = new MPanel();
    protected MPanel base;
    Options options;
    private static float FRAME_SCALE_FACTOR = 0.75f;
    private static int FRAME_X_MIN = 650;
    private static int FRAME_Y_MIN = 550;
    private static final String BUNDLE_NAME = "uibk.mtk.swing.appletbase.messages";

    public AppletBase() {
        this.options = new StandardOptions();
    }

    public AppletBase(Options opt) {
        this.options = opt == null ? new StandardOptions() : opt;
    }

    public void init() {
        this.options.setLookAndFeel();
        this.initComponents();
        this.setOneTouchExpandable(true);
    }

    protected void initComponents() {
        this.base = new MPanel();
        this.base.setBackground(this.options.getBackgroundColor());
        this.base.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.labelreports.setBorder(BorderFactory.createLoweredBevelBorder());
        Font font = this.labelreports.getFont();
        this.labelreports.setFont(font.deriveFont(1));
        this.panelnav = new NavigationBar(this);
        this.panelnav.setReportingLabel(this.labelreports);
        if (this.isStandalone) {
            this.panelnav.enableInternetButtons(false);
        }
        this.panelmain = new MPanel();
        this.panelmain.setLayout(new BorderLayout(0, 0));
        this.panelmain.setBorder(BorderFactory.createLineBorder(Color.black));
        this.panelmain.setBackground(this.options.getBackgroundColor());
        this.panelcontrol = new MPanel();
        this.panelcontrol.setLayout(new BorderLayout(0, 0));
        this.panelcontrol.setBackground(this.options.getBackgroundColor());
        this.panelcontrol.setPreferredSize(new Dimension(140, 1000));
        this.splitpanel = new JSplitPane(1, this.panelmain, this.panelcontrol);
        this.splitpanel.setResizeWeight(0.8);
        this.splitpanel.setDividerSize(8);
        this.splitpanel.setContinuousLayout(false);
        this.splitpanel.setBackground(this.options.getBackgroundColor());
        this.splitpanel.setBorder(BorderFactory.createEmptyBorder());
        this.base.setLayout(new BorderLayout(5, 5));
        this.base.add((Component)this.panelnav, "North");
        this.base.add((Component)this.splitpanel, "Center");
        this.base.add((Component)this.labelreports, "South");
        this.getContentPane().add((Component)this.base, "Center");
    }

    public void setOneTouchExpandable(boolean enable) {
        this.splitpanel.setOneTouchExpandable(enable);
    }

    public void setDividerSize(int size) {
        this.splitpanel.setDividerSize(size);
    }

    public void setResizeWeight(double w) {
        this.splitpanel.setResizeWeight(w);
    }

    public String getAppletInfo() {
        return Messages.getString(BUNDLE_NAME, "AppletBase.0");
    }

    public void setMainPanel(JComponent panel) {
        this.panelmain.removeAll();
        this.panelmain.add(panel);
        this.setInfosMathPanel(panel);
    }

    private void setInfosMathPanel(JComponent component) {
        if (component instanceof MathPanel) {
            MathPanel mp = (MathPanel)component;
            mp.setReporter(this.labelreports);
            mp.setOptions(this.options);
        }
        Component[] comp = component.getComponents();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] instanceof JComponent) {
                this.setInfosMathPanel((JComponent)comp[i]);
            }
            ++i;
        }
    }

    protected void setControlPanel(JComponent panel) {
        this.panelcontrol.removeAll();
        this.panelcontrol.add(panel);
    }

    public void setDividerLocation(int l) {
        this.splitpanel.setDividerLocation(l);
    }

    public void setDividerLocation(double d) {
        this.splitpanel.setDividerLocation(d);
    }

    public Options getOptions() {
        return this.options;
    }

    public static void runmain(AppletBase applet, String title, float facx) {
        applet.isStandalone = true;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        float ratio = 1.0f * (float)screenSize.height / (float)screenSize.width;
        int w = (int)((float)screenSize.width * facx);
        int h = (int)((float)w * ratio);
        if (w < FRAME_X_MIN || h < FRAME_Y_MIN) {
            w = FRAME_X_MIN;
            h = FRAME_Y_MIN;
        }
        AppletFrame frame = new AppletFrame(applet, w, h, w, h);
        frame.setTitle(title);
    }

    public static void runmain(AppletBase applet, String title, float facx, float facy) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        applet.isStandalone = true;
        int w = (int)((float)screenSize.width * facx);
        int h = (int)((float)screenSize.height * facy);
        AppletFrame frame = new AppletFrame(applet, w, h, w, h);
        frame.setTitle(title);
    }

    public static void runmain(AppletBase applet, String title) {
        AppletBase.runmain(applet, title, FRAME_SCALE_FACTOR);
    }

    public void DoubleBufferedMainPanel(boolean b) {
        this.base.setDoubleBuffered(b);
    }
}

