/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.parsing;

import java.util.StringTokenizer;
import java.util.Vector;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Parser;

public final class Misc {
    private static final String BUNDLE_NAME = "uibk.mtk.math.parsing.messages";
    private static Parser parser = new Parser();

    private Misc() {
    }

    public static synchronized double parseConstantExpr(String expr) throws InputException {
        Expr e = parser.parseString(expr);
        return e.value();
    }

    public static synchronized Interval parseIntervall(String strInterval, String name, boolean trueinterval) throws InputException {
        double end;
        double start;
        if (name == null) {
            name = "";
        }
        if (strInterval == null || strInterval.equals("")) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.2"));
        }
        String str = strInterval.trim();
        if (!str.startsWith("[")) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.4"));
        }
        if (!str.endsWith("]")) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.6"));
        }
        int pos = str.indexOf(",");
        if (pos < 0) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.8"));
        }
        try {
            start = Misc.parseConstantExpr(str.substring(1, pos));
        }
        catch (InputException ex) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.9"));
        }
        try {
            end = Misc.parseConstantExpr(str.substring(pos + 1, strInterval.length() - 1));
        }
        catch (InputException ex) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.10"));
        }
        if (trueinterval) {
            if (end <= start) {
                throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.11"));
            }
        } else if (end < start) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.12"));
        }
        Interval interval = new Interval(start, end);
        return interval;
    }

    public static synchronized double[] parseInitalValues(String strinitials, String name) throws InputException {
        if (strinitials == null || strinitials.equals("")) {
            throw new InputException(String.valueOf(Messages.getString(BUNDLE_NAME, "Misc.14")) + name + Messages.getString(BUNDLE_NAME, "Misc.15"));
        }
        String str = strinitials.trim();
        if (str.charAt(0) == ',' || str.charAt(strinitials.length() - 1) == ',' || str.indexOf(",,") >= 0) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "Misc.17"));
        }
        String[] strvalues = Misc.split(str, ",");
        if (strvalues == null || strvalues.length == 0) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "Misc.19"));
        }
        double[] values = new double[strvalues.length];
        int i = 0;
        while (i < values.length) {
            try {
                values[i] = Misc.parseConstantExpr(strvalues[i]);
            }
            catch (InputException ex) {
                throw new InputException(String.valueOf(Messages.getString(BUNDLE_NAME, "Misc.20")) + name + Messages.getString(BUNDLE_NAME, "Misc.21"));
            }
            ++i;
        }
        return values;
    }

    public static synchronized double[] parseBracketInitalValues(String strinitials, String name) throws InputException {
        String str = strinitials.trim();
        if (str.charAt(0) != '(' || str.charAt(str.length() - 1) != ')') {
            try {
                double[] ret = new double[]{Misc.parseConstantExpr(str)};
                return ret;
            }
            catch (InputException ex) {
                throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.22"));
            }
        }
        str = str.substring(1, str.length() - 1);
        return Misc.parseInitalValues(str, name);
    }

    public static synchronized String[] split(String aString, String delimiter) {
        StringTokenizer st = new StringTokenizer(aString, delimiter);
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i++] = st.nextToken();
        }
        return result;
    }

    public static synchronized double parseEps(String streps, double min) throws InputException {
        return Misc.parseDoubleValue(streps, Messages.getString(BUNDLE_NAME, "Misc.23"), new Double(min), null, true);
    }

    public static synchronized double parseDoubleValue(String strvalue, String name, Double min, Double max, Boolean positive) throws InputException {
        double val = 0.0;
        if (strvalue == null || strvalue.equals("")) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.25"));
        }
        try {
            val = Misc.parseConstantExpr(strvalue);
        }
        catch (InputException ex) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.26"));
        }
        if (positive != null && positive.booleanValue() && val <= 0.0) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.27"));
        }
        if (positive != null && !positive.booleanValue() && val >= 0.0) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.28"));
        }
        if (max != null && val > max) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.29") + max + Messages.getString(BUNDLE_NAME, "Misc.30"));
        }
        if (min != null && val < min) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.31") + min + Messages.getString(BUNDLE_NAME, "Misc.32"));
        }
        return val;
    }

    public static synchronized int parseIntegerValue(String strvalue, String name, Integer min, Integer max) throws InputException {
        int val = 0;
        boolean natural = false;
        if (min != null && min >= 0) {
            natural = true;
        }
        if (strvalue == null || strvalue.equals("")) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.34"));
        }
        try {
            val = Integer.parseInt(strvalue);
        }
        catch (Exception ex) {
            String type = natural ? Messages.getString(BUNDLE_NAME, "Misc.35") : Messages.getString(BUNDLE_NAME, "Misc.36");
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.37") + type + Messages.getString(BUNDLE_NAME, "Misc.38"));
        }
        if (natural && val < 0) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.39"));
        }
        if (max != null && max < 0 && val >= 0) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.40"));
        }
        if (max != null && (double)val > max.doubleValue()) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.41") + max + Messages.getString(BUNDLE_NAME, "Misc.42"));
        }
        if (min != null && (double)val < min.doubleValue()) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.43") + min + Messages.getString(BUNDLE_NAME, "Misc.44"));
        }
        return val;
    }

    public static synchronized CoordinateRect2D parseRectArea(String strxmin, String strxmax, String strymin, String strymax) throws InputException {
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        if (strxmin == null || strxmin.equals("")) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "Misc.46"));
        }
        if (strxmax == null || strxmax.equals("")) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "Misc.48"));
        }
        if (strymin == null || strymin.equals("")) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "Misc.50"));
        }
        if (strymax == null || strymax.equals("")) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "Misc.52"));
        }
        try {
            xmin = Misc.parseConstantExpr(strxmin);
        }
        catch (InputException e) {
            throw new InputException(String.valueOf(Messages.getString(BUNDLE_NAME, "Misc.53")) + e.getMessage());
        }
        try {
            xmax = Misc.parseConstantExpr(strxmax);
        }
        catch (InputException e) {
            throw new InputException(String.valueOf(Messages.getString(BUNDLE_NAME, "Misc.54")) + e.getMessage());
        }
        try {
            ymin = Misc.parseConstantExpr(strymin);
        }
        catch (InputException e) {
            throw new InputException(String.valueOf(Messages.getString(BUNDLE_NAME, "Misc.55")) + e.getMessage());
        }
        try {
            ymax = Misc.parseConstantExpr(strymax);
        }
        catch (InputException e) {
            throw new InputException(String.valueOf(Messages.getString(BUNDLE_NAME, "Misc.56")) + e.getMessage());
        }
        if (xmax <= xmin) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "Misc.57"));
        }
        if (ymax <= ymin) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "Misc.58"));
        }
        return new CoordinateRect2D(xmin, xmax, ymin, ymax);
    }

    public static Punkt2D parsePunkt2D(String strpoint, String name) throws InputException {
        if (strpoint == null || strpoint.equals("")) {
            throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.60"));
        }
        try {
            double[] coords = Misc.parseBracketInitalValues(strpoint, "");
            return new Punkt2D(coords[0], coords[1]);
        }
        catch (InputException e) {
            throw new InputException(String.valueOf(Messages.getString(BUNDLE_NAME, "Misc.62")) + name + Messages.getString(BUNDLE_NAME, "Misc.63"));
        }
    }

    public static int[] parseVarsIndices(String del, String varname, String str) {
        if (str == null) {
            return new int[0];
        }
        String[] v = Misc.split(str.trim(), del);
        if (v == null || v.length == 0) {
            return new int[0];
        }
        Vector<Integer> indices = new Vector<Integer>();
        int i = 0;
        while (i < v.length) {
            int pos = -1;
            do {
                ++pos;
                if ((pos = v[i].indexOf(varname, pos)) == -1) break;
                int index = Misc.scanNumber(pos + varname.length(), v[i]);
                if (index == -1) continue;
                boolean add = true;
                int k = 0;
                while (k < indices.size()) {
                    if ((Integer)indices.elementAt(k) == index) {
                        add = false;
                    }
                    ++k;
                }
                if (!add) continue;
                indices.add(new Integer(index));
            } while (pos >= 0);
            ++i;
        }
        int[] ind = new int[indices.size()];
        int i2 = 0;
        while (i2 < indices.size()) {
            ind[i2] = (Integer)indices.elementAt(i2);
            ++i2;
        }
        return ind;
    }

    public static String parseCharListValue(String name, char del, char[] var, String strvalue) throws InputException {
        String outStr = "";
        if (strvalue == null || var == null) {
            return outStr;
        }
        int i = 0;
        while (i < strvalue.length()) {
            char zeichen = strvalue.charAt(i);
            boolean isPermitted = false;
            int j = 0;
            while (j < var.length) {
                if (zeichen == var[j]) {
                    isPermitted = true;
                }
                ++j;
            }
            if (!isPermitted) {
                throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.70") + zeichen);
            }
            outStr = String.valueOf(outStr) + zeichen;
            if (i + 1 < strvalue.length() && (zeichen = strvalue.charAt(i + 1)) != del) {
                throw new InputException(String.valueOf(name) + Messages.getString(BUNDLE_NAME, "Misc.71") + zeichen);
            }
            i += 2;
        }
        return outStr;
    }

    private static int scanNumber(int i, String s) {
        if (i >= s.length()) {
            return -1;
        }
        int from = i;
        while (i < s.length()) {
            if (!Character.isDigit(s.charAt(i))) break;
            ++i;
        }
        if (from == i || i > s.length()) {
            return -1;
        }
        String text = s.substring(from, i);
        int nval = Integer.valueOf(text);
        return nval;
    }
}

