/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

public final class Rounder {
    private static final int ROUND_HALF_UP = 1;
    private static final int ROUND_FLOOR = 2;
    private static final int ROUND_CEIL = 3;
    private static final int ROUND_DOWN = 4;
    private static final int ROUND_RINT = 5;
    private static int roundingmode = 1;

    private Rounder() {
    }

    private static synchronized double round(double x) {
        switch (roundingmode) {
            case 1: {
                return Math.floor(x + 0.5);
            }
            case 2: {
                return Math.floor(x);
            }
            case 3: {
                return Math.ceil(x);
            }
            case 4: {
                if (x >= 0.0) {
                    return Math.floor(x);
                }
                return -Math.floor(-x);
            }
            case 5: {
                return Math.rint(x);
            }
        }
        throw new IllegalArgumentException("");
    }

    private static synchronized double roundentire(double x, double distance) {
        double temp;
        double r = x;
        if (r == 0.0) {
            return 0.0;
        }
        int c = 1;
        do {
            temp = r;
            if ((r = Rounder.round(r / Math.pow(10.0, c)) * Math.pow(10.0, c)) == 0.0) {
                if (Math.abs(x) <= distance) {
                    return 0.0;
                }
                return temp;
            }
            ++c;
        } while (Math.abs(r - x) <= distance);
        return temp;
    }

    private static synchronized double roundplaces(double x, double distance) {
        int i = 1;
        double r = x;
        while (Math.abs((r = Rounder.roundNumPlaces(x, i)) - x) >= distance && ++i < 15) {
        }
        return r;
    }

    private static synchronized double roundit(double x, double distance) {
        if (Double.isInfinite(distance) && Double.isNaN(distance) || Double.isInfinite(x) && Double.isNaN(x)) {
            return x;
        }
        double r = Rounder.round(x);
        if (Math.abs(r - x) <= distance) {
            return Rounder.roundentire(r, distance);
        }
        return Rounder.roundplaces(x, distance);
    }

    public static synchronized double getRoundValue(double x, double distance) {
        roundingmode = 1;
        return Rounder.roundit(x, Math.abs(distance));
    }

    public static double getLowerRoundValue(double x, double distance) {
        double r = Rounder.getUpperRoundValue(-x, distance);
        if (r != 0.0) {
            return -r;
        }
        return 0.0;
    }

    public static double getUpperRoundValue(double x, double distance) {
        roundingmode = 3;
        return Rounder.roundit(x, distance);
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized double roundDownToLeadingDec(double x) {
        block3: {
            fac = 1;
            r = Math.abs(x);
            if (!(r > 1.0)) ** GOTO lbl10
            while (Math.floor(r / (double)fac) > 0.0) {
                fac *= 10;
            }
            ret = Math.floor(r / (double)(fac /= 10)) * (double)fac;
            break block3;
lbl-1000:
            // 1 sources

            {
                fac *= 10;
lbl10:
                // 2 sources

                ** while (Math.floor((double)(r * (double)fac)) == 0.0)
            }
lbl11:
            // 1 sources

            ret = Math.floor(r * (double)fac) / (double)fac;
        }
        if (x < 0.0) {
            return -ret;
        }
        return ret;
    }

    public static synchronized double roundNumPlaces(double x, int places) {
        long factor = (long)Math.pow(10.0, places);
        double tmp = Rounder.round(x *= (double)factor);
        return tmp / (double)factor;
    }

    public static synchronized double roundNumPlacesNext(double x, int places) {
        long factor = (long)Math.pow(10.0, places);
        roundingmode = 5;
        double tmp = Rounder.round(x *= (double)factor);
        return tmp / (double)factor;
    }
}

