/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;

public class MultiGraph2D
extends Drawable2D {
    protected Vector graphs = new Vector();

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        int i = 0;
        while (i < this.graphs.size()) {
            ((Graph2D)this.graphs.elementAt(i)).draw(framebuffer, g2);
            ++i;
        }
    }

    public void clear() {
        this.graphs.clear();
    }

    public void addGraph(Graph2D graph) {
        graph.setMathPanel2D(this.panel);
        this.graphs.add(graph);
    }

    public void addGraphs(Vector v) {
        int i = 0;
        while (i < v.size()) {
            Graph2D g = (Graph2D)v.elementAt(i);
            g.setMathPanel2D(this.panel);
            this.graphs.add(g);
            ++i;
        }
    }

    public CoordinateRect2D getLimits() {
        Iterator it = ((AbstractList)this.graphs).iterator();
        CoordinateRect2D max = null;
        while (it.hasNext()) {
            Graph2D graph = (Graph2D)it.next();
            CoordinateRect2D rect = graph.getLimits();
            if (max == null) {
                max = rect;
                continue;
            }
            if (max.contains(rect)) continue;
            max = max.combine(rect);
        }
        return max;
    }

    public Graph2D getGraphAt(int index) {
        return (Graph2D)this.graphs.get(index);
    }

    public int getGraphSize() {
        return this.graphs.size();
    }

    public Graph2D getLastGraph() {
        return (Graph2D)this.graphs.lastElement();
    }
}

