/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.fraktale;

import java.util.Vector;
import uibk.applets.fraktale.AppletFraktale;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MultiGraph2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.lang.Messages;

public class Fraktale {
    private final AppletFraktale main;
    protected MultiGraph2D graphflow = new MultiGraph2D();

    Fraktale(AppletFraktale main) {
        this.main = main;
        main.mathPanel2D.add(this.graphflow);
        main.mathPanel2D.getScene2d().axesequal(true);
    }

    public CoordinateRect2D paint(String str, double p, double m, double winkel0, CoordinateRect2D limitsIn) throws Exception {
        this.graphflow.clear();
        Graph2D graph = new Graph2D();
        this.graphflow.addGraph(graph);
        double x = 0.0;
        double y = 0.0;
        double winkel = winkel0;
        graph.addPoint(x, y);
        Stack stack = new Stack();
        stack.addElement(winkel, graph);
        if (str == null || str == "") {
            return null;
        }
        int i = 0;
        while (i < str.length()) {
            char zeichen = str.charAt(i);
            winkel = stack.getWinkel();
            switch (zeichen) {
                case 'f': {
                    graph.addPoint(x += Math.cos(winkel), y += Math.sin(winkel));
                    break;
                }
                case 'p': {
                    stack.setWinkel(winkel + p);
                    break;
                }
                case 'm': {
                    stack.setWinkel(winkel - m);
                    break;
                }
                case 'e': {
                    stack.removeLastElement();
                    if (stack.getAnz() == 0) {
                        throw new Exception(Messages.getString("uibk.applets.fraktale.messages", "Fraktale.1"));
                    }
                    graph = stack.getGraph();
                    x = graph.getLastPoint().x;
                    y = graph.getLastPoint().y;
                    break;
                }
                case 'v': {
                    graph = new Graph2D();
                    this.graphflow.addGraph(graph);
                    graph.addPoint(x, y);
                    stack.addElement(winkel, graph);
                    break;
                }
            }
            ++i;
        }
        CoordinateRect2D limits = this.graphflow.getLimits();
        if (limitsIn != null) {
            if (!limitsIn.contains(limits)) {
                limits = limits.combine(limitsIn);
                this.main.mathPanel2D.getScene2d().setLimits(limits);
            } else {
                limits = limitsIn;
            }
        } else {
            this.main.mathPanel2D.getScene2d().setLimits(limits);
        }
        this.main.mathPanel2D.repaint();
        return limits;
    }

    public void loeschen() {
        this.graphflow.clear();
        this.main.mathPanel2D.repaint();
    }

    private class Stack {
        private Vector v = new Vector();

        Stack() {
        }

        public void addElement(double winkel, Graph2D graph) {
            StackElement element = new StackElement(winkel, graph);
            this.v.add(element);
        }

        public void setWinkel(double winkel) {
            StackElement element = (StackElement)this.v.lastElement();
            element.winkel = winkel;
        }

        public void removeLastElement() {
            this.v.remove(this.v.lastElement());
        }

        public double getWinkel() {
            return ((StackElement)this.v.lastElement()).winkel;
        }

        public Graph2D getGraph() {
            return ((StackElement)this.v.lastElement()).graph;
        }

        public int getAnz() {
            return this.v.size();
        }

        private class StackElement {
            public double winkel;
            public Graph2D graph;

            StackElement(double winkel, Graph2D graph) {
                this.winkel = winkel;
                this.graph = graph;
            }
        }
    }
}

